<?php
/**
 * Creative black-red-white footer – WAVE USED AS TOP BORDER ONLY
 * Theme: Fmwave  |  v5.1
 */
namespace radiustheme\fmwave;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;

defined( 'ABSPATH' ) || exit;

$copyright_text = RDTheme::$options['copyright_text'] ?? '';
$footer_logo_id = RDTheme::$options['footer_logo_image'] ?? 0;
$fm_footer_logo = $footer_logo_id
	? wp_get_attachment_image( $footer_logo_id, 'full', false, [
		'class'   => 'footer-logo img-fluid',
		'loading' => 'lazy',
		'alt'     => get_bloginfo( 'name', 'display' ),
	  ] )
	: sprintf(
		'<img class="footer-logo img-fluid" src="%1$s" alt="%2$s" loading="lazy">',
		esc_url( Helper::get_img( 'logo-light.png' ) ),
		esc_attr( get_bloginfo( 'name', 'display' ) )
	  );
?>

<!-- FOOTER STARTS HERE – wave is the TOP BORDER -->
<footer class="crt-footer">

	<!-- 1. WAVE TOP BORDER (no bottom wave) -->
	<div class="top-wave-border" aria-hidden="true">
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120" preserveAspectRatio="none">
			<defs>
				<linearGradient id="waveGradient" x1="0%" y1="0%" x2="0%" y2="100%">
					<stop offset="0%" style="stop-color:#ffffff;stop-opacity:1" />
					<stop offset="30%" style="stop-color:#f8f9fa;stop-opacity:1" />
					<stop offset="70%" style="stop-color:#e9ecef;stop-opacity:1" />
					<stop offset="100%" style="stop-color:#000000;stop-opacity:1" />
				</linearGradient>
				<filter id="waveGlow" x="-50%" y="-50%" width="200%" height="200%">
					<feGaussianBlur stdDeviation="2" result="coloredBlur"/>
					<feMerge> 
						<feMergeNode in="coloredBlur"/>
						<feMergeNode in="SourceGraphic"/>
					</feMerge>
				</filter>
			</defs>
			<path fill="url(#waveGradient)" filter="url(#waveGlow)"
				  d="M0,60 C240,20 480,100 720,60 C960,20 1200,100 1440,60 L1440,0 L0,0 Z"/>
		</svg>
	</div>

	<!-- 2. MAIN FOOTER BLOCK -->
	<?php if ( RDTheme::$options['footer_area'] ?? true ) : ?>
	<div class="footer-main">
		<div class="container-fluid px-4 p-5">
			<div class="row g-4 g-lg-5">
				<?php for ( $i = 1; $i <= 4; $i++ ) :
					if ( is_active_sidebar( "footer-4-{$i}" ) ) : ?>
						<div class="col-12 col-sm-6 col-lg-3">
							<div class="tilt-card h-100">
								<?php dynamic_sidebar( "footer-4-{$i}" ); ?>
							</div>
						</div>
					<?php endif;
				endfor; ?>
			</div>

			<div class="logo-social text-center mt-5">
			
				<?php if ( $socials = Helper::socials() ) : ?>
					<div class="social-links d-flex justify-content-center flex-wrap gap-3 mt-4">
						<?php foreach ( $socials as $link ) : ?>
							<a href="<?php echo esc_url( $link['url'] ); ?>" target="_blank" rel="noopener" aria-label="<?php echo esc_attr( $link['icon'] ); ?>" class="social-link">
								<i class="fab fa-<?php echo esc_attr( $link['icon'] ); ?>"></i>
							</a>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php endif; ?>

	<!-- 3. BOTTOM BAR -->
	<div class="footer-bottom">
		<div class="container-fluid px-4">
			<div class="row">
				<div class="col-12 text-center">
					<small class="copyright"><?php echo wp_kses( $copyright_text, 'allow_link' ); ?></small>
				</div>
			</div>
		</div>
	</div>
</footer>

<style>
/* ---------- vars ---------- */
:root{ 
	--black:#000; 
	--red:#ff0000; 
	--white:#fff; 
	--neon:red; 
	--logo-max-w:180px; 
	--wave-light:#ffffff; 
	--wave-dark:#2d4a2d;
	--wave-glow:rgba(255,255,255,0.3);
	--card-bg:rgba(255,255,255,0.08);
	--card-border:rgba(255,0,0,0.3);
	--text-muted:rgba(255,255,255,0.7);
	--gradient-primary:linear-gradient(135deg, #ff0000 0%, #cc0000 100%);
	--gradient-secondary:linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%);
}

/* ---------- base ---------- */
*{box-sizing:border-box}
.crt-footer{
	background: 
		radial-gradient(circle at 20% 80%, rgba(255,0,0,0.1) 0%, transparent 50%),
		radial-gradient(circle at 80% 20%, rgba(255,0,0,0.05) 0%, transparent 50%),
		linear-gradient(135deg, #000000 0%, #1a1a1a 100%);
	color:var(--white);
	position:relative;
	overflow:hidden;
	font-family:'Segoe UI',Roboto,Oxygen,Ubuntu,Cantarell,sans-serif;
	animation: footerFadeIn 1s ease-out;
}

@keyframes footerFadeIn {
	0% { opacity: 0; transform: translateY(50px); }
	100% { opacity: 1; transform: translateY(0); }
}

/* ---------- top wave border ---------- */
.top-wave-border{
	position:absolute;
	top:-1px;
	left:0;
	width:100%;
	line-height:0;
	z-index:2;
	animation: waveSlideIn 1.2s ease-out 0.3s both;
}

@keyframes waveSlideIn {
	0% { transform: translateX(-100%); opacity: 0; }
	100% { transform: translateX(0); opacity: 1; }
}

.top-wave-border svg{
	display:block;
	width:100%;
	height:140px;
	filter: 
		drop-shadow(0 4px 8px rgba(0,0,0,0.15))
		drop-shadow(0 2px 4px rgba(0,0,0,0.1));
	animation: 
		waveFloat 4s ease-in-out infinite,
		waveGlow 3s ease-in-out infinite alternate,
		waveRipple 6s ease-in-out infinite;
}

@keyframes waveFloat {
	0%, 100% { transform: translateY(0px) scale(1); }
	25% { transform: translateY(-3px) scale(1.01); }
	50% { transform: translateY(-1px) scale(1.005); }
	75% { transform: translateY(-4px) scale(1.015); }
}

@keyframes waveGlow {
	0% { 
		filter: 
			drop-shadow(0 4px 8px rgba(0,0,0,0.15))
			drop-shadow(0 2px 4px rgba(0,0,0,0.1))
			drop-shadow(0 0 10px rgba(255,255,255,0.1));
	}
	100% { 
		filter: 
			drop-shadow(0 4px 8px rgba(0,0,0,0.15))
			drop-shadow(0 2px 4px rgba(0,0,0,0.1))
			drop-shadow(0 0 20px rgba(255,255,255,0.3))
			drop-shadow(0 0 30px rgba(255,0,0,0.2));
	}
}

@keyframes waveRipple {
	0%, 100% { transform: translateY(0px) rotate(0deg); }
	33% { transform: translateY(-2px) rotate(0.5deg); }
	66% { transform: translateY(1px) rotate(-0.3deg); }
}

/* Add subtle background pattern behind wave */
.top-wave-border::before {
	content: '';
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	background: 
		radial-gradient(circle at 20% 50%, rgba(255,255,255,0.05) 0%, transparent 50%),
		radial-gradient(circle at 80% 20%, rgba(255,255,255,0.03) 0%, transparent 50%),
		radial-gradient(circle at 40% 80%, rgba(255,255,255,0.04) 0%, transparent 50%);
	pointer-events: none;
	animation: 
		patternPulse 5s ease-in-out infinite,
		patternMove 8s ease-in-out infinite;
}

@keyframes patternPulse {
	0%, 100% { opacity: 0.3; transform: scale(1); }
	50% { opacity: 0.7; transform: scale(1.05); }
}

@keyframes patternMove {
	0%, 100% { transform: translateX(0px) translateY(0px); }
	25% { transform: translateX(10px) translateY(-5px); }
	50% { transform: translateX(-5px) translateY(5px); }
	75% { transform: translateX(5px) translateY(-3px); }
}

/* ---------- content ---------- */
.footer-main{ 
	padding:100px 0 60px; 
	position:relative; 
	z-index:1; 
	animation: contentSlideUp 1s ease-out 0.6s both;
}

@keyframes contentSlideUp {
	0% { transform: translateY(30px); opacity: 0; }
	100% { transform: translateY(0); opacity: 1; }
}


/* Remove all hover effects from cards */
.tilt-card:hover{ 
	transform: none;
	border-color: var(--card-border);
	box-shadow: none;
}

.tilt-card .widget-title{
	font-size:1.3rem;
	font-weight:600;
	margin-bottom:20px;
	color:var(--white);
	text-shadow:0 0 8px var(--neon);
	letter-spacing:1px;
	position:relative;
	animation: titleGlow 3s ease-in-out infinite alternate;
}

@keyframes titleGlow {
	0% { text-shadow: 0 0 8px var(--neon); }
	100% { text-shadow: 0 0 12px var(--neon), 0 0 20px rgba(255,0,0,0.3); }
}

.tilt-card .widget-title::after {
	content: '';
	position: absolute;
	bottom: -8px;
	left: 0;
	width: 40px;
	height: 2px;
	background: var(--gradient-primary);
	border-radius: 2px;
	animation: underlineExpand 0.8s ease-out 1.2s both;
}

@keyframes underlineExpand {
	0% { width: 0; }
	100% { width: 40px; }
}

.tilt-card ul{ 
	list-style:none; 
	padding:0; 
	margin:0; 
}

.tilt-card li{ 
	margin-bottom:12px; 
	position:relative;
	padding-left:20px;
	animation: listItemSlide 0.6s ease-out both;
	animation-delay: calc(1.4s + var(--item-delay, 0s));
}

.tilt-card li:nth-child(1) { --item-delay: 0.1s; }
.tilt-card li:nth-child(2) { --item-delay: 0.2s; }
.tilt-card li:nth-child(3) { --item-delay: 0.3s; }
.tilt-card li:nth-child(4) { --item-delay: 0.4s; }
.tilt-card li:nth-child(5) { --item-delay: 0.5s; }

@keyframes listItemSlide {
	0% { transform: translateX(-20px); opacity: 0; }
	100% { transform: translateX(0); opacity: 1; }
}

.tilt-card li::before {
	content: '▶';
	position: absolute;
	left: 0;
	color: var(--red);
	font-size: 0.8rem;
	opacity: 0.7;
	animation: bulletBounce 2s ease-in-out infinite;
}

@keyframes bulletBounce {
	0%, 100% { transform: translateX(0); }
	50% { transform: translateX(2px); }
}

.tilt-card a{ 
	color:var(--text-muted); 
	text-decoration:none; 
	transition:all .3s ease;
	font-weight:400;
	position:relative;
}

/* Remove hover effects from links */
.tilt-card a:hover{ 
	color:var(--text-muted);
	text-shadow:none;
	transform: none;
}

/* Enhanced logo + social section */
.logo-social{ 
	position:relative;
	animation: logoSectionFade 1s ease-out 1.6s both;
}

@keyframes logoSectionFade {
	0% { transform: translateY(30px); opacity: 0; }
	100% { transform: translateY(0); opacity: 1; }
}

.logo-social::before {
	content: '';
	position: absolute;
	top: -30px;
	left: 50%;
	transform: translateX(-50%);
	width: 200px;
	height: 1px;
	background: linear-gradient(90deg, transparent, var(--red), transparent);
	animation: lineExpand 1.2s ease-out 1.8s both;
}

@keyframes lineExpand {
	0% { width: 0; }
	100% { width: 200px; }
}

.footer-logo{ 
	max-width:var(--logo-max-w); 
	height:auto; 
	margin-bottom:30px; 
	filter:
		drop-shadow(0 0 10px var(--neon))
		drop-shadow(0 4px 8px rgba(0,0,0,0.3));
	transition: all 0.3s ease;
	animation: logoFloat 4s ease-in-out infinite;
}

@keyframes logoFloat {
	0%, 100% { transform: translateY(0px) rotate(0deg); }
	25% { transform: translateY(-3px) rotate(0.5deg); }
	50% { transform: translateY(-5px) rotate(0deg); }
	75% { transform: translateY(-2px) rotate(-0.3deg); }
}

/* Remove logo hover effects */
.footer-logo:hover {
	transform: none;
	filter:
		drop-shadow(0 0 10px var(--neon))
		drop-shadow(0 4px 8px rgba(0,0,0,0.3));
	animation: logoFloat 4s ease-in-out infinite;
}

.social-links{ 
	display:flex; 
	gap:20px; 
}

.social-link{
	display:inline-flex;
	align-items:center; 
	justify-content:center;
	width:50px; 
	height:50px;
	background:var(--gradient-secondary);
	border:2px solid var(--card-border);
	border-radius:50%;
	color:var(--white); 
	font-size:20px;
	animation: socialPulse 4s infinite, socialSlideIn 0.8s ease-out both;
	animation-delay: calc(2s + var(--social-delay, 0s));
	transition:all .3s ease;
	position:relative;
	overflow:hidden;
	text-decoration: none;
}

.social-link:nth-child(1) { --social-delay: 0.1s; }
.social-link:nth-child(2) { --social-delay: 0.2s; }
.social-link:nth-child(3) { --social-delay: 0.3s; }
.social-link:nth-child(4) { --social-delay: 0.4s; }
.social-link:nth-child(5) { --social-delay: 0.5s; }

@keyframes socialSlideIn {
	0% { transform: translateY(30px) scale(0.5); opacity: 0; }
	100% { transform: translateY(0) scale(1); opacity: 1; }
}

/* Remove social hover effects */
.social-link:hover{ 
	background:var(--gradient-secondary);
	border-color:var(--card-border);
	color:var(--white);
	animation: socialPulse 4s infinite;
	transform: none;
	box-shadow: none;
}

@keyframes socialPulse{
	0%{box-shadow:0 0 0 0 rgba(255,0,0,.4)}
	50%{box-shadow:0 0 0 10px rgba(255,0,0,0.1)}
	100%{box-shadow:0 0 0 0 rgba(255,0,0,0)}
}

/* Enhanced bottom bar */
.footer-bottom{
	padding:25px 0;
	font-size:.9rem;
	border-top:1px solid rgba(255,0,0,.2);
	text-align:center;
	background: rgba(0,0,0,0.3);
	backdrop-filter: blur(5px);
	position:relative;
	animation: bottomBarSlide 1s ease-out 2.2s both;
}

@keyframes bottomBarSlide {
	0% { transform: translateY(20px); opacity: 0; }
	100% { transform: translateY(0); opacity: 1; }
}

.footer-bottom::before {
	content: '';
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	height: 1px;
	background: linear-gradient(90deg, transparent, var(--red), transparent);
	animation: topLineExpand 1.5s ease-out 2.4s both;
}

@keyframes topLineExpand {
	0% { width: 0; left: 50%; }
	100% { width: 100%; left: 0; }
}

.copyright {
	color: var(--text-muted);
	font-weight: 300;
	letter-spacing: 0.5px;
	animation: copyrightFade 1s ease-out 2.6s both;
}

@keyframes copyrightFade {
	0% { opacity: 0; transform: translateY(10px); }
	100% { opacity: 1; transform: translateY(0); }
}

/* Bootstrap responsive improvements */
@media (max-width: 1200px) {
	.footer-main { padding: 80px 0 50px; }
	.tilt-card { padding: 28px 20px; }
}

@media (max-width: 992px) {
	.footer-main { padding: 70px 0 45px; }
	.tilt-card { padding: 24px 18px; }
	.social-link { width: 45px; height: 45px; font-size: 18px; }
}

@media (max-width: 768px) {
	.footer-main { padding: 60px 0 40px; }
	.top-wave-border svg { 
		height: 100px; 
		animation: 
			waveFloat 5s ease-in-out infinite,
			waveGlow 4s ease-in-out infinite alternate,
			waveRipple 7s ease-in-out infinite;
	}
	.tilt-card { padding: 20px 16px; }
	.social-links { gap: 15px; }
	.social-link { width: 42px; height: 42px; font-size: 16px; }
	.logo-social { margin-top: 40px; }
	.footer-logo { max-width: 150px; }
}

@media (max-width: 576px) {
	.footer-main { padding: 50px 0 30px; }
	.top-wave-border svg { 
		height: 80px; 
		animation: 
			waveFloat 6s ease-in-out infinite,
			waveGlow 5s ease-in-out infinite alternate,
			waveRipple 8s ease-in-out infinite;
	}
	.tilt-card { padding: 18px 14px; }
	.social-links { gap: 12px; }
	.social-link { width: 40px; height: 40px; font-size: 14px; }
	.footer-logo { max-width: 120px; margin-bottom: 20px; }
	.copyright { font-size: 0.8rem; }
}

@media (max-width: 400px) {
	.footer-main { padding: 40px 0 25px; }
	.tilt-card { padding: 16px 12px; }
	.social-links { gap: 10px; }
	.social-link { width: 38px; height: 38px; font-size: 13px; }
	.footer-logo { max-width: 100px; }
}

/* Reduced motion for accessibility */
@media (prefers-reduced-motion: reduce) {
	* {
		animation-duration: 0.01ms !important;
		animation-iteration-count: 1 !important;
		transition-duration: 0.01ms !important;
	}
}
</style>