<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\fmwave;

$fmwave      	= FMWAVE_THEME_PREFIX;
$cpt         	= FMWAVE_THEME_CPT_PREFIX;
$thumb_size  	= "fmwave-team-1";
$id             = get_the_id();
$tv_year   		= get_post_meta( $id, "{$cpt}_tvshow_year", true );
$tv_imbd        = get_post_meta( $id, "{$cpt}_tvshow_imdb", true );
$get_video_link = get_post_meta( get_the_ID(), "{$cpt}_tvshow_video_link" , true );

$tv_cat = get_the_term_list( $id, "{$cpt}_tvshow_category", '', ', ' );


$comments_number = number_format_i18n( get_comments_number() );
$comments_html  = $comments_number;


?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="tvshow-box">
        <div class="item-img">
            <?php the_post_thumbnail( $thumb_size ); ?>
            <?php if( $get_video_link ) { ?>
            <div class="video-icon">
                <a class="play-btn popup-youtube" href="<?php echo esc_url( $get_video_link ); ?>">
                    <i class="fas fa-play"></i>
                </a>
            </div>
            <?php } ?>
        </div>
        <div class="item-content">
            <?php if( $tv_year ) { ?>
            <div class="item-year"><?php echo esc_html( $tv_year ); ?></div>
            <?php } ?>
            <h3 class="item-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
            <div class="rating-comment">
                <?php if( $tv_imbd ) { ?>
                <div class="item-rating"><i class="fas fa-star"></i><?php echo esc_html( $tv_imbd ); ?></div>
                <?php } ?>
                <div class="item-comment"><i class="far fa-comment-dots"></i><?php echo esc_html( $comments_html ); ?></div>
            </div>
        </div>
    </div>
</article>