<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_editor_style( 'style-editor.css' );

if ( !isset( $content_width ) ) {
	$content_width = 1200;
}

class Fmwave_Main {
	public $theme   = 'fmwave';
	public $action  = 'fmwave_theme_init';
	public function __construct() {
		add_action( 'after_setup_theme', array( $this, 'load_textdomain' ) );
		add_action( 'admin_notices',     array( $this, 'plugin_update_notices' ) );
		add_filter( 'get_the_archive_title',  array( $this, 'prefix_get_the_archive_title' ) );
		$this->includes();	
	}
	public function load_textdomain(){
		load_theme_textdomain( $this->theme, get_template_directory() . '/languages' );
	}
	public function includes(){
		do_action( $this->action );
		require_once get_template_directory() . '/inc/constants.php';
		require_once get_template_directory() . '/inc/includes.php';
	}
	public function plugin_update_notices() {
		$plugins = array();

		if ( defined( 'FMWAVE_CORE' ) ) {
			if ( version_compare( FMWAVE_CORE, '1.0', '<' ) ) {
				$plugins[] = 'Fmwave Core';
			}
		}

		foreach ( $plugins as $plugin ) {
			$notice = '<div class="error"><p>' . sprintf( __( "Please update plugin <b><i>%s</b></i> to the latest version otherwise some functionalities will not work properly. You can update it from <a href='%s'>here</a>", 'fmwave' ), $plugin, menu_page_url( 'fmwave-install-plugins', false ) ) . '</p></div>';
			echo wp_kses( $notice, 'alltext_allow' );
		}
	}

	function prefix_get_the_archive_title($title) {    
	    if ( is_category() ) {    
	            $title = single_cat_title( '', false );    
	        } elseif ( is_tag() ) {    
	            $title = single_tag_title( '', false );    
	        } elseif ( is_author() ) {    
	            $title = '<span class="vcard">' . get_the_author() . '</span>' ;    
	        } elseif ( is_tax() ) { //for custom post types
	            $title = sprintf( __( '%1$s' ), single_term_title( '', false ) );
	        } elseif (is_post_type_archive()) {
	            $title = post_type_archive_title( '', false );
	        }
	    return $title;    
	}
	
}
new Fmwave_Main;