<?php
/**
 * Template for WP News and Scrolling Widgets Pro Loop - design-29
 *
 * This template can be overridden by copying it to yourtheme/wp-news-and-widget-pro/slider/design-29.php
 *
 * @package WP News and Scrolling Widgets Pro
 * @version 2.1.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

if(( $count % 2 ) > 0) { ?>
	<div class="wpnaw-news-slides wpnaw-news-inner-wrap">
		<div class="wpnaw-news-grid-content">
			<a class="wpnaw-link-overlay" href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"></a>
			<div class="wpnaw-news-image-bg" style="<?php echo esc_attr( $height_css ); ?>">
				<?php if( ! empty( $slider_orig_img ) ) { ?>
					<img class="wpnaw-post-img" src="<?php echo esc_url( $post_featured_image ); ?>" alt="<?php the_title_attribute(); ?>" <?php if( $lazyload ) { ?>data-lazy="<?php echo esc_url( $slider_orig_img ); ?>" <?php } ?> />
				<?php } ?>
			</div>

			<?php if( $show_category_name && $cate_name !='' ) { ?>
				<div class="wpnaw-news-categories"><?php echo wp_kses_post( $cate_name ); ?></div>
			<?php } ?>

			<div class="wpnaw-title-content">
				<?php if( $news_post_title ) { ?>
					<h2 class="wpnaw-news-title">
						<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo wp_kses_post( $news_post_title ); ?></a>
					</h2>
				<?php }

				if( $show_date || $show_author ) { ?>
					<div class="wpnaw-news-date">
						<?php if( $show_author ) { ?><span><?php esc_html_e( 'By', 'sp-news-and-widget' ); ?> <a href="<?php echo esc_url( get_author_posts_url( $post->post_author ) ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo get_the_author(); ?></a></span><?php }

						echo ( $show_author && $show_date ) ? '&nbsp;/&nbsp;' : '';

						if( $show_date ) { echo get_the_date(); } ?>
					</div>
				<?php }

				if( $show_content ) { ?>
					<div class="wpnaw-news-content">
						<div class="wpnaw-news-subshort-content"><?php echo wpnw_pro_get_post_excerpt( NULL, get_the_content(), $content_words_limit, $content_tail ); ?></div>
						<?php if( $show_read_more ) { ?>
							<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="readmorebtn"><?php echo wp_kses_post( $read_more_text ); ?></a>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
	
<?php } else { ?>
	
	<div class="wpnaw-news-slides wpnaw-news-inner-wrap wpnaw-news-smallimage" style="<?php echo esc_attr( $height_css ); ?>">
		<div class="wpnaw-news-grid-content">
			<?php if ( $slider_orig_img ) { ?>
				<div class="wpnaw-news-image-bg">
					<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
						<img class="wpnaw-post-img" src="<?php echo esc_url( $post_featured_image ); ?>" alt="<?php the_title_attribute(); ?>" <?php if( $lazyload ) { ?>data-lazy="<?php echo esc_url( $slider_orig_img ); ?>" <?php } ?> />
					</a>

					<?php if( $show_category_name && $cate_name !='' ) { ?>
						<div class="wpnaw-news-categories"><?php echo wp_kses_post( $cate_name ); ?></div>
					<?php } ?>
				</div>
			<?php } ?>

			<div class="wpnaw-news-title-content">
				<?php if( $news_post_title ) { ?>
					<h2 class="wpnaw-news-title">
						<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo wp_kses_post( $news_post_title ); ?></a>
					</h2>
				<?php }

				if( $show_date || $show_author ) { ?>
					<div class="wpnaw-news-date">
						<?php if( $show_author ) { ?><span><?php esc_html_e( 'By', 'sp-news-and-widget' ); ?> <a href="<?php echo esc_url( get_author_posts_url( $post->post_author ) ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo get_the_author(); ?></a></span><?php }

						echo ( $show_author && $show_date ) ? '&nbsp;/&nbsp;' : '';

						if( $show_date ) { echo get_the_date(); } ?>
					</div>
				<?php }

				if( $show_content ) {  ?>
					<div class="wpnaw-news-content">
						<div class="wpnaw-news-subshort-content"><?php echo wpnw_pro_get_post_excerpt( NULL, get_the_content(), $content_words_limit, $content_tail ); ?></div>
						<?php if( $show_read_more ) { ?>
							<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="readmorebtn"><?php echo wp_kses_post( $read_more_text ); ?></a>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
<?php } ?>