<?php
/**
 * Template for WP News and Five Widgets Pro Loop - design-2
 *
 * This template can be overridden by copying it to yourtheme/wp-news-and-widgets-pro/grid-box-slider/design-2.php
 *
 * @package WP News and Five Widgets Pro
 * @version 2.1.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} 

global $post;

$grid_box_count 	= ( $count % 3 );
$grid_box_count 	= ! empty( $grid_box_count ) 	? $grid_box_count : 3;
$image_height 		= ( ! empty( $image_height ) ) 	? $image_height : 500;
$dynamic_height 	= ( ( $count % 3 ) == 1 ) 		? $image_height : ( ( $image_height/2 )-2 );
$height_css 		= ( $dynamic_height ) 			? 'height:'.$dynamic_height.'px;' : '';
$dynamic_class 		= ( ( $count % 3 )  == 1 ) 		? 'wpnews-medium-8' : 'wpnews-medium-4';

if( ( $count % 3 ) == 1 ) { ?>
<div class="wpnaw-grid-slider-wrp">
<?php } ?>
	<div class="wpnaw-news-slides wpnaw-news-inner-wrap wpnaw-clr-<?php echo esc_attr( $grid_box_count ); ?> <?php echo esc_attr( $dynamic_class ); ?> wpnews-columns">
	<a class="wpnaw-link-overlay" href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"></a>
		<div class="wpnaw-news-grid-content">
			<div class="wpnaw-news-overlay">
				<div class="wpnaw-news-image-bg" style="<?php echo esc_attr( $height_css ); ?>">
					<?php if( ! empty( $slider_orig_img ) ) { ?>
						<img class="wpnaw-post-img" src="<?php echo esc_url( $post_featured_image ); ?>" alt="<?php the_title_attribute(); ?>" <?php if( $lazyload ) { ?>data-lazy="<?php echo esc_url( $slider_orig_img ); ?>"<?php } ?> />
					<?php } ?>
				</div>

				<div class="wpnaw-title-content">
					<?php if( $show_category_name && $cate_name !='' ) { ?>
					<div class="wpnaw-news-categories"><?php echo wp_kses_post( $cate_name ); ?></div>
					<?php } ?>

					<div class="wpnaw-bottom-content">
						<?php if( $news_post_title ) { ?>
							<h2 class="wpnaw-news-title">
								<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo wp_kses_post( $news_post_title ); ?></a>
							</h2>
						<?php } 

						if( $show_date || $show_author ) { ?>
							<div class="wpnaw-news-date">
								<?php if( $show_author ) { ?><span><?php esc_html_e( 'By', 'sp-news-and-widget' ); ?> <a href="<?php echo esc_url( get_author_posts_url( $post->post_author ) ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo get_the_author(); ?></a></span><?php }

								echo ( $show_author && $show_date ) ? '&nbsp;/&nbsp;' : '';

								if( $show_date ) { echo get_the_date(); } ?>
							</div>
						<?php }

						if( $show_content ) { ?>
							<div class="wpnaw-news-content">
								<div><?php echo wpnw_pro_get_post_excerpt( NULL, get_the_content(), $content_words_limit, $content_tail ); ?></div>
								<?php if( $show_read_more ) { ?>
									<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="readmorebtn"><?php echo wp_kses_post( $read_more_text ); ?></a>
								<?php } ?>
							</div>
						<?php } ?> 
					</div>
				</div>
			</div>
		</div>
	</div>
<?php if( ( $count % 3 ) == 0 || ( $post_count == $count ) ) { ?>
</div>
<?php } ?>