<?php
/**
 * Handles 'News' post settings metabox HTML
 *
 * @package WP News and Scrolling Widgets Pro
 * @since 1.1.6
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

$prefix = WPNW_META_PREFIX; // Metabox prefix

// Getting saved values
$read_more_link = get_post_meta( $post->ID, $prefix.'more_link', true );
$wpnw_setts 	= get_post_meta( $post->ID, $prefix.'setts', true );
$read_more_text	= isset( $wpnw_setts['read_more_text'] ) ? $wpnw_setts['read_more_text'] : '';
?>

<table class="form-table wpnw-post-sett-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="wpnw-more-link"><?php esc_html_e( 'Read More Link', 'sp-news-and-widget' ); ?></label>
			</th>
			<td>
				<input type="text" value="<?php echo esc_url( $read_more_link ); ?>" class="large-text wpnw-more-link" id="wpnw-more-link" name="<?php echo esc_attr( $prefix ); ?>more_link" /><br/>
				<span class="description"><?php esc_html_e( 'If you have different URL then enter read more link for post or Leave empty for current post URL. e.g https://www.essentialplugin.com', 'sp-news-and-widget' ); ?></span>
			</td>
		</tr>

		<tr>
			<th scope="row">
				<label for="wpnw-read-more-text"><?php esc_html_e( 'Read More Text', 'sp-news-and-widget' ); ?></label>
			</th>
			<td>
				<input type="text" value="<?php echo esc_attr( $read_more_text ); ?>" class="large-text wpnw-read-more-text" id="wpnw-read-more-text" name="<?php echo esc_attr( $prefix ); ?>setts[read_more_text]" /><br/>
				<span class="description"><?php esc_html_e( 'Enter read more button text. Leave it empty for default text.', 'sp-news-and-widget' ); ?></span>
			</td>
		</tr>
	</tbody>
</table><!-- end .wtwp-tstmnl-table -->