<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use \WP_Widget;
use \RT_Widget_Fields;

class About_Widget extends WP_Widget {
	public function __construct() {
		$id = 'fmwave_about';
		parent::__construct(
            $id, // Base ID
            esc_html__( 'Fmwave: About', 'fmwave-core' ), // Name
            array( 'description' => esc_html__( 'Fmwave: About Widget', 'fmwave-core' )
            	) );
	}
	public function widget( $args, $instance ){
		echo wp_kses_post( $args['before_widget'] );
		if ( !empty( $instance['logo'] ) ) { 
		$img   = wp_get_attachment_image( $instance['logo'],'full' );
		
		?>
		<?php }
		elseif ( !empty( $instance['title'] ) ) { ?>
			<div class="footer-title"><h3 class="widget-title"><?php echo wp_kses( $instance['title'] , 'alltext_allow' ); ?></h3></div>
		<?php }
			if( !empty( $instance['description'] ) ){
		?>
		
		<div class="footer-about">
		<?php
		if( !empty( $instance['logo'] ) ){
				?><span><?php echo wp_kses( $img, 'alltext_allow' ); ?></span><?php
			} 
		?>
		<p class="rtin-des"><?php if( !empty( $instance['description'] ) ) echo wp_kses_post( $instance['description'] ); ?></p></div>
		<?php } 
		if( !empty( $instance['address']) || !empty( $instance['phone']  ) || !empty( $instance['phone2']  ) || !empty( $instance['fax']  ) || !empty( $instance['email']  ) ){ ?>
		<div class="footer-address">
			<ul>
				<?php
				if( !empty( $instance['address'] ) ){
                    ?><li><i class="fas fa-map-marker-alt" aria-hidden="true"></i><?php echo wp_kses_post( $instance['address'] ); ?></li><?php
                }
				if( !empty( $instance['phone'] ) ){
					?><li><i class="fas fa-phone-alt" aria-hidden="true"></i> <a href="tel:<?php echo esc_attr( $instance['phone'] ); ?>"><?php echo esc_html( $instance['phone'] ); ?></a></li><?php
				}
				if( !empty( $instance['phone2'] ) ){
					?><li><i class="fas fa-phone" aria-hidden="true"></i> <a href="tel:<?php echo esc_attr( $instance['phone2'] ); ?>"><?php echo esc_html( $instance['phone2'] ); ?></a></li><?php
				}
				if( !empty( $instance['fax'] ) ){
					?><li><i class="fas fa-fax" aria-hidden="true"></i> <?php echo esc_html( $instance['fax'] ); ?></li><?php
				}
				if( !empty( $instance['email'] ) ){
					?><li><i class="far fa-envelope" aria-hidden="true"></i> <a href="mailto:<?php echo esc_attr( $instance['email'] ); ?>"><?php echo esc_html( $instance['email'] ); ?></a></li><?php
				}				
				?>
			</ul>
		</div>
				<?php } ?>
				
		<div class="footer-social">
		<ul>
			<?php
			if( !empty( $instance['facebook'] ) ){
				?><li><a href="<?php echo esc_url( $instance['facebook'] ); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a></li><?php
			}
			if( !empty( $instance['twitter'] ) ){
				?><li><a href="<?php echo esc_url( $instance['twitter'] ); ?>" target="_blank"><i class="fab fa-x-twitter"></i></a></li><?php
			}
			if( !empty( $instance['linkedin'] ) ){
				?><li><a href="<?php echo esc_url( $instance['linkedin'] ); ?>" target="_blank"><i class="fab fa-linkedin"></i></a></li><?php
			}
			if( !empty( $instance['pinterest'] ) ){
				?><li><a href="<?php echo esc_url( $instance['pinterest'] ); ?>" target="_blank"><i class="fab fa-pinterest"></i></a></li><?php
			}
			if( !empty( $instance['rss'] ) ){
				?><li><a href="<?php echo esc_url( $instance['rss'] ); ?>" target="_blank"><i class="fa fa-rss"></i></a></li><?php
			}
			if( !empty( $instance['instagram'] ) ){
				?><li><a href="<?php echo esc_url( $instance['instagram'] ); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li><?php
			}
			if( !empty( $instance['tiktok'] ) ){
				?><li><a href="<?php echo esc_url( $instance['tiktok'] ); ?>" target="_blank"><i class="fab fa-tiktok"></i></a></li><?php
			}
			?>
		</ul>
	</div>
		<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ){
		$instance                  = array();
		$instance['title']         = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['logo']          = ( ! empty( $new_instance['logo'] ) ) ? sanitize_text_field( $new_instance['logo'] ) : '';
		$instance['description']   = ( ! empty( $new_instance['description'] ) ) ? wp_kses_post( $new_instance['description'] ) : '';
		$instance['address']   = ( ! empty( $new_instance['address'] ) ) ? wp_kses_post( $new_instance['address'] ) : '';
		$instance['phone']     = ( ! empty( $new_instance['phone'] ) ) ? sanitize_text_field( $new_instance['phone'] ) : '';
		$instance['phone2']    = ( ! empty( $new_instance['phone2'] ) ) ? sanitize_text_field( $new_instance['phone2'] ) : '';
		$instance['email']     = ( ! empty( $new_instance['email'] ) ) ? sanitize_email( $new_instance['email'] ) : '';
		$instance['fax']       = ( ! empty( $new_instance['fax'] ) ) ? sanitize_text_field( $new_instance['fax'] ) : '';
		$instance['facebook']      = ( ! empty( $new_instance['facebook'] ) ) ? sanitize_text_field( $new_instance['facebook'] ) : '';
		$instance['twitter']       = ( ! empty( $new_instance['twitter'] ) ) ? sanitize_text_field( $new_instance['twitter'] ) : '';
		$instance['linkedin']      = ( ! empty( $new_instance['linkedin'] ) ) ? sanitize_text_field( $new_instance['linkedin'] ) : '';
		$instance['pinterest']     = ( ! empty( $new_instance['pinterest'] ) ) ? sanitize_text_field( $new_instance['pinterest'] ) : '';
		$instance['rss']           = ( ! empty( $new_instance['rss'] ) ) ? sanitize_text_field( $new_instance['rss'] ) : '';
		$instance['instagram']     = ( ! empty( $new_instance['instagram'] ) ) ? sanitize_text_field( $new_instance['instagram'] ) : '';
		$instance['tiktok']         = ( ! empty( $new_instance['tiktok'] ) ) ? sanitize_text_field( $new_instance['tiktok'] ) : '';
		return $instance;
	}

	public function form( $instance ){
		$defaults = array(
			'title'         => '',
			'logo'          => '',
			'description'   => '',
			'address' 		=> '',
			'phone'   		=> '',
			'phone2'  		=> '',
			'email'   		=> '',
			'fax'     		=> '',
			'facebook'      => '',
			'twitter'       => '',
			'linkedin'      => '',
			'pinterest'     => '',
			'rss'           => '', 
			'instagram'     => '',
			'tiktok'      	=> '',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'       => array(
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'type'    => 'text',
			),
			'logo'        => array(
				'label'   => esc_html__( 'Logo', 'fmwave-core' ),
				'type'    => 'image',
			),
			'description' => array(
				'label'   => esc_html__( 'Description', 'fmwave-core' ),
				'type'    => 'textarea',
			),
			'address'   => array(
				'label' => esc_html__( 'Address', 'fmwave-core' ),
				'type'  => 'textarea',
			),
			'phone'     => array(
				'label' => esc_html__( 'Phone 1', 'fmwave-core' ),
				'type'  => 'text',
			),
			'phone2'    => array(
				'label' => esc_html__( 'Phone 2', 'fmwave-core' ),
				'type'  => 'text',
			),
			'fax'       => array(
				'label' => esc_html__( 'Fax', 'fmwave-core' ),
				'type'  => 'text',
			),
			'email'     => array(
				'label' => esc_html__( 'Email', 'fmwave-core' ),
				'type'  => 'text',
			),
			'facebook'    => array(
				'label'   => esc_html__( 'Facebook URL', 'fmwave-core' ),
				'type'    => 'url',
			),
			'twitter'     => array(
				'label'   => esc_html__( 'Twitter URL', 'fmwave-core' ),
				'type'    => 'url',
			),
			'linkedin'    => array(
				'label'   => esc_html__( 'Linkedin URL', 'fmwave-core' ),
				'type'    => 'url',
			),
			'pinterest'   => array(
				'label'   => esc_html__( 'Pinterest URL', 'fmwave-core' ),
				'type'    => 'url',
			),
			'rss'         => array(
				'label'   => esc_html__( 'Rss Feed URL', 'fmwave-core' ),
				'type'    => 'url',
			),
			'instagram'   => array(
				'label'   => esc_html__( 'Instagram URL', 'fmwave-core' ),
				'type'    => 'url',
			),
			'tiktok'     => array(
				'label'    => esc_html__( 'Tiktok URL', 'zilly-core' ),
				'type'     => 'url',
			),
		);

		RT_Widget_Fields::display( $fields, $instance, $this );
	}
}