<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use radiustheme\fmwave\RDTheme;
use \RT_Posts;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'RT_Posts' ) ) {
	return;
}

$prefix = FMWAVE_CORE_CPT;

$fmwave_post_types = array(

	"{$prefix}_music"  => array(
		'title'        => esc_html__( 'Music Track', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Music Tracks', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-format-audio',
		'rewrite'      => RDTheme::$options['music_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	"{$prefix}_team"   => array(
		'title'        => esc_html__( 'Team Member', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Team Members', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-businessman',
		'rewrite'      => RDTheme::$options['team_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	"{$prefix}_show"   => array(
		'title'        => esc_html__( 'Show', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Shows', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-video-alt',
		'rewrite'      => RDTheme::$options['show_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	"{$prefix}_event"        => array(
		'title'        => esc_html__( 'Event', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Events', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-media-interactive',
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
		'rewrite'      => RDTheme::$options['event_slug'],
	),
	"{$prefix}_podcast" => array(
		'title'        => esc_html__( 'Podcast', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Podcasts', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-microphone',
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
		'rewrite'      => RDTheme::$options['podcast_slug'],
	),
	"{$prefix}_tvshow" => array(
		'title'        => esc_html__( 'TV Show', 'fmwave-core' ),
		'plural_title' => esc_html__( 'TV Shows', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-microphone',
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes', 'comments' ),
		'rewrite'      => RDTheme::$options['tvshow_slug'],
		//'taxonomies' => array('post_tag'),
	),
	"{$prefix}_video"  => array(
		'title'        => esc_html__( 'video', 'fmwave-core' ),
		'plural_title' => esc_html__( 'videos', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-format-video',
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
		'rewrite'      => RDTheme::$options['video_slug'],
	),
	"{$prefix}_gallery"  => array(
		'title'           => esc_html__( 'Gallery', 'fmwave-core' ),
		'plural_title'    => esc_html__( 'Gallery', 'fmwave-core' ),
		'menu_icon'       => 'dashicons-book',
		'rewrite'         => RDTheme::$options['gallery_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	"{$prefix}_logoshowcase" => array(
		'title'        => esc_html__( 'Logo', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Logos', 'fmwave-core' ),
		'menu_icon'    => 'dashicons-slides',
		'supports'     => array( 'title', 'thumbnail', 'excerpt', 'page-attributes' ),
	),

);

$fmwave_taxonomies = array(

	"{$prefix}_team_category" => array(
		'title'        => esc_html__( 'Team Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_team",
		'rewrite'      => array( 'slug' => RDTheme::$options['team_cat_slug'] ),
	),
	"{$prefix}_music_category" => array(
		'title'        => esc_html__( 'Music Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_music",
		'rewrite'      => array( 'slug' => RDTheme::$options['music_cat_slug'] ),
	),
	"{$prefix}_music_genre" => array(
		'title'        => esc_html__( 'Music Genre', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Genre', 'fmwave-core' ),
		'post_types'   => "{$prefix}_music",
		'rewrite'      => array( 'slug' => RDTheme::$options['music_genre_slug'] ),
	),
	"{$prefix}_music_album" => array(
		'title'        => esc_html__( 'Music Album', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Albums', 'fmwave-core' ),
		'post_types'   => "{$prefix}_music",
		'rewrite'      => array( 'slug' => RDTheme::$options['music_album_slug'] ),
	),
	"{$prefix}_show_category" => array(
		'title'        => esc_html__( 'Show Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_show",
		'rewrite'      => array( 'slug' => RDTheme::$options['show_cat_slug'] ),
	),
	"{$prefix}_event_category" => array(
		'title'        => esc_html__( 'Event Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_event",
		'rewrite'      => array( 'slug' => RDTheme::$options['event_cat_slug'] ),
	),
	"{$prefix}_podcast_category" => array(
		'title'        => esc_html__( 'Podcast Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_podcast",
		'rewrite'      => array( 'slug' => RDTheme::$options['podcast_cat_slug'] ),
	),
	"{$prefix}_tvshow_category" => array(
		'title'        => esc_html__( 'TV Show Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_tvshow",
		'rewrite'      => array( 'slug' => RDTheme::$options['tvshow_cat_slug'] ),
	),
	"{$prefix}_video_category" => array(
		'title'        => esc_html__( 'Video Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_video",
		'rewrite'      => array( 'slug' => RDTheme::$options['video_cat_slug'] ),
	),
	"{$prefix}_gallery_category" => array(
		'title'        => esc_html__( 'Gallery Category', 'fmwave-core' ),
		'plural_title' => esc_html__( 'Categories', 'fmwave-core' ),
		'post_types'   => "{$prefix}_gallery",
		'rewrite'      => array( 'slug' => RDTheme::$options['gallery_cat_slug'] ),
	),
	
);

$fmwave_Posts = RT_Posts::getInstance();
$fmwave_Posts->add_post_types( $fmwave_post_types );
$fmwave_Posts->add_taxonomies( $fmwave_taxonomies );