<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
use \RT_Postmeta;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'RT_Postmeta' ) ) {
	return;
}

$fmwave_Postmeta  = RT_Postmeta::getInstance();
$prefix 			= FMWAVE_CORE_CPT;
$nav_menus 			= wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus 			= array( 'default' => esc_html__( 'Default', 'fmwave-core' ) ) + $nav_menus;
$sidebars  			= array( 'default' => esc_html__( 'Default', 'fmwave-core' ) ) + Helper::custom_sidebar_fields();

$fmwave_Postmeta->add_meta_box( 'page_settings', esc_html__( 'Layout Settings', 'fmwave-core' ), array( 'page', 'post', "{$prefix}_team", "{$prefix}_event", "{$prefix}_show", "{$prefix}_music", "{$prefix}_podcast", "{$prefix}_tvshow" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_layout" => array(
			'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default'       => esc_html__( 'Default', 'fmwave-core' ),
				'full-width'    => esc_html__( 'Full Width', 'fmwave-core' ),
				'left-sidebar'  => esc_html__( 'Left Sidebar', 'fmwave-core' ),
				'right-sidebar' => esc_html__( 'Right Sidebar', 'fmwave-core' ),
				),
			'default'  			=> 'default',
			),			
		"{$prefix}_sidebar" => array(
			'label'    		=> esc_html__( 'Custom Sidebar', 'fmwave-core' ),
			'type'     		=> 'select',
			'options'  		=> $sidebars,
			'default'  		=> 'default',
			),
		"{$prefix}_page_menu" => array(
			'label'   => esc_html__( 'Main Menu', 'fmwave-core' ),
			'type'    => 'select',
			'options' => $nav_menus,
			'default' => 'default',
			),
		"{$prefix}_tr_header" => array(
			'label'   => esc_html__( 'Transparent Header', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				'on'      => esc_html__( 'Enabled', 'fmwave-core' ),
				'off'     => esc_html__( 'Disabled', 'fmwave-core' ),
				),
			'default'  => 'default',
			),	
		"{$prefix}_header" => array(
			'label'   => esc_html__( 'Header Layout', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				'1'       => esc_html__( 'Layout 1', 'fmwave-core' ),
				'2'       => esc_html__( 'Layout 2', 'fmwave-core' ),
				'3'       => esc_html__( 'Layout 3', 'fmwave-core' ),
				'4'       => esc_html__( 'Layout 4', 'fmwave-core' ),
						
				),
			'default'  => 'default',
			),
		"{$prefix}_footer" => array(
			'label'   => esc_html__( 'Footer Layout', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				'1'       => esc_html__( 'Layout 1', 'fmwave-core' ),
				'2'       => esc_html__( 'Layout 2', 'fmwave-core' ),
				'3'       => esc_html__( 'Layout 3', 'fmwave-core' ),
				'4'       => esc_html__( 'Layout 4', 'fmwave-core' ),
			),
			'default'  => 'default',
			),
		"{$prefix}_footer_top_area" => array(
			'label' 	  => __( 'Footer Top Area', 'fmwave-core' ),
			'type'  	  => 'select',
			'options' => array(
				'default' => __( 'Default', 'fmwave-core' ),
				'on'      => __( 'Enabled', 'fmwave-core' ),
				'off'     => __( 'Disabled', 'fmwave-core' ),
			),
			'default'  	  => 'default',
		),
		"{$prefix}_top_padding" => array(
			'label'   => esc_html__( 'Content Padding Top', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				 '0px'     => '0px',
				'10'    => '10px',
				'20'    => '20px',
				'30'    => '30px',
				'40'    => '40px',
				'50'    => '50px',
				'60'    => '60px',
				'70'    => '70px',
				'80'    => '80px',
				'90'    => '90px',
				'100'   => '100px',
				),			
			'default'  => 'default',
			),
		"{$prefix}_bottom_padding" => array(
			'label'   => esc_html__( 'Content Padding Bottom', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				 '0px'     => '0px',
				'10'    => '10px',
				'20'    => '20px',
				'30'    => '30px',
				'40'    => '40px',
				'50'    => '50px',
				'60'    => '60px',
				'70'    => '70px',
				'80'    => '80px',
				'90'    => '90px',
				'100'   => '100px',
				),
			'default'  => 'default',
			),
		"{$prefix}_banner" => array(
			'label'   => esc_html__( 'Banner', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				'on'      => esc_html__( 'Enable', 'fmwave-core' ),
				'off'     => esc_html__( 'Disable', 'fmwave-core' ),
				),
			'default'  => 'default',
			),
		"{$prefix}_breadcrumb" => array(
			'label'   => esc_html__( 'Breadcrumb', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				'on'      => esc_html__( 'Enable', 'fmwave-core' ),
				'off'     => esc_html__( 'Disable', 'fmwave-core' ),
				),
			'default'  => 'default',
			),
		"{$prefix}_banner_type" => array(
			'label'   => esc_html__( 'Banner Background Type', 'fmwave-core' ),
			'type'    => 'select',
			'options' => array(
				'default'  => esc_html__( 'Default', 'fmwave-core' ),
				'bgimg'    => esc_html__( 'Background Image', 'fmwave-core' ),
				'bgcolor'  => esc_html__( 'Background Color', 'fmwave-core' ),
				),
			'default'  => 'default',
			),
		"{$prefix}_banner_bgimg" => array(
			'label' => esc_html__( 'Banner Background Image', 'fmwave-core' ),
			'type'  => 'image',
			'desc'  => esc_html__( 'If not selected, default will be used', 'fmwave-core' ),
			),
		"{$prefix}_banner_bgcolor" => array(
			'label' => esc_html__( 'Banner Background Color', 'fmwave-core' ),
			'type'  => 'color_picker',
			'desc'  => esc_html__( 'If not selected, default will be used', 'fmwave-core' ),
			),
		"{$prefix}_inner_padding_top" => array(
				'label' => esc_html__( 'Banner Padding Top', 'fmwave-core' ),
				'type'  => 'text',
				'default'  => '',
				'desc'  => esc_html__( 'If not selected, default will be used 120 "px"', 'fmwave-core' ),
			),	
		"{$prefix}_inner_padding_bottom" => array(
				'label' => esc_html__( 'Banner Padding Bottom', 'fmwave-core' ),
				'type'  => 'text',
				'default'  => '',
				'desc'  => esc_html__( 'If not selected, default will be used 120 "px" ', 'fmwave-core' ),
			),	
		),
	) 
);

$fmwave_Postmeta->add_meta_box( 'member_info', esc_html__( 'Personal Info', 'fmwave-core' ), array( "{$prefix}_team" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_show_designation" => array(
			'label' => esc_html__( 'Designation', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_show_name" => array(
			'label' => esc_html__( 'Show Name', 'fmwave-core' ),
			'type'  => 'text',
		),	
		"{$prefix}_show_date" => array(
			'label' => esc_html__( 'Show Date', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_team_button" => array(
			'label' => esc_html__( 'Button', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_team_button_url" => array(
			'label' => esc_html__( 'Button url', 'fmwave-core' ),
			'type'  => 'text',
		),
	)
	)
);


$fmwave_Postmeta->add_meta_box( 'team_socials', esc_html__( 'Team Socials', 'fmwave-core' ), array( "{$prefix}_team" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_team_socials_header" => array(
			'label' => esc_html__( 'Socials', 'fmwave-core' ),
			'type'  => 'header',
			'desc'  => esc_html__( 'Put your Team links here', 'fmwave-core' ),
			),
		"{$prefix}_team_social" => array(
			'type'  => 'group',
			'value'  => Helper::team_socials()
			),
		)
	)
);

// Testimonial //
$fmwave_Postmeta->add_meta_box( 'testimonial_info',
	esc_html__( 'Testimonial Information', 'fmwave-core' ), array( "{$prefix}_testimonial" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_testimonial_rating" => array(
			'label' => esc_html__( 'Select the Rating', 'fmwave-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => esc_html__( 'Default', 'fmwave-core' ),
				'0'     => '',
				'1'    => '1',
				'2'    => '2',
				'3'    => '3',
				'4'    => '4',
				'5'    => '5'
				),
			'default'  => 'default',
			),
		"{$prefix}_testimonial_designation" => array(
			'label' => esc_html__( 'Designation', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
			)		
		)
	)
);
/*	 Schedule  */
$fmwave_event_social = array(
	'facebook' => array(
		'label' => esc_html__( 'Facebook', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-facebook',
		),
	'twitter' => array(
		'label' => esc_html__( 'Twitter', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-twitter',
		),
	'linkedin' => array(
		'label' => esc_html__( 'Linkedin', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-linkedin',
		),
	'gplus' => array(
		'label' => esc_html__( 'Google Plus', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-google-plus',
		),
	'skype' => array(
		'label' => esc_html__( 'Skype', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-skype',
		),
	'youtube' => array(
		'label' => esc_html__( 'Youtube', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-youtube-play',
		),
	'pinterest' => array(
		'label' => esc_html__( 'Pinterest', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-pinterest-p',
		),
	'instagram' => array(
		'label' => esc_html__( 'Instagram', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-instagram',
		),
	'github' => array(
		'label' => esc_html__( 'Github', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-github',
		),
	'stackoverflow' => array(
		'label' => esc_html__( 'Stackoverflow', 'fmwave-core' ),
		'type'  => 'text',
		'icon'  => 'fa-stack-overflow',
		),
	);

$fmwave_Postmeta->add_meta_box( 'services_single_layout', esc_html__( 'Services Layout', 'fmwave-core' ), array( "{$prefix}_services"), '', '', 'high', array(
		'fields' => array(
			"{$prefix}_single_services_arc_style" => array(
				'label'   => esc_html__( 'Services Single Layout', 'fmwave-core' ),
				'type'    => 'select',
				'options' => array(
					'default' => esc_html__( 'Default', 'fmwave-core' ),
					'style1'       => esc_html__( 'Layout 1', 'fmwave-core' ),
					'style2'       => esc_html__( 'Layout 2', 'fmwave-core' ),
					),
				'default'  => 'default',
			),	
		)
) );

$fmwave_Postmeta->add_meta_box( 'services_info', esc_html__( 'Services Info', 'fmwave-core' ), array( "{$prefix}_services"), '', '', 'high', array(
		'fields' => array(
			"{$prefix}_slider_title" => array(
				'label' => esc_html__( 'Slider Sub Title', 'fmwave-core' ),
				'type'  => 'textarea_html',
				'default'  => '',
			),
			"{$prefix}_sub_title" => array(
				'label' => esc_html__( 'Sub Title', 'fmwave-core' ),
				'type'  => 'text',
				'default'  => '',
			),
			"{$prefix}_short_detail" => array(
				'label' => esc_html__( 'Short Detail', 'fmwave-core' ),
				'type'  => 'textarea_html',			
			),
			"{$prefix}_doc_pdf" => array(
				'label' => esc_html__( 'Document .pdf', 'fmwave-core' ),
				'type'  => 'file',			
			),
			"{$prefix}_doc_Word" => array(
				'label' => esc_html__( 'Document .Word', 'fmwave-core' ),
				'type'  => 'file',			
			),
		"{$prefix}_video_link" => array(
				'label' => esc_html__( 'Video link', 'fmwave-core' ),
				'type'  => 'text',			
			),
		)
) );

$fmwave_Postmeta->add_meta_box( 'services_additional_image', esc_html__( 'Additional Image', 'fmwave-core' ), array( "{$prefix}_services"), '', '', 'high', array(
	'fields' => array(		
		"{$prefix}_services_image" => array(
			'type'  => 'repeater',
			'button' => esc_html__( 'Add New Image', 'fmwave-core' ),
			'value'  => array(				
				"service_additional_img" => array(
					'label' => esc_html__( 'Additional Image', 'fmwave-core' ),
					'type'  => 'image',
					'default'  => '',
				),	
			)
		),
	)
) );

//Event
$fmwave_Postmeta->add_meta_box( 'event_info', esc_html__( 'Event Information', 'fmwave-core' ), array( "{$prefix}_event"), '', '', 'high', array(
		'fields' => array(
		"{$prefix}_video_link" => array(
			'label' => esc_html__( 'Event Video Link', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_start_date" => array(
			'label' => esc_html__( 'Event Start Date', 'fmwave-core' ),
			'type'  => 'date_picker',
			'default'  => '',
		),
        "{$prefix}_event_start_time" => array(
            'label' => __( 'Start Time', 'fmwave-core' ),
            'type'  => 'time_picker_24',
            'default'  => '',
        ),
		"{$prefix}_end_date" => array(
			'label' => esc_html__( 'Event End Date', 'fmwave-core' ),
			'type'  => 'date_picker',
			'default'  => '',
		),
        "{$prefix}_event_end_time" => array(
            'label' => __( 'End Time', 'fmwave-core' ),
            'type'  => 'time_picker_24',
            'default'  => '',
        ),
		"{$prefix}_location" => array(
			'label' => esc_html__( 'Event Location', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_address" => array(
			'label' => esc_html__( 'Event Address', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_phone" => array(
			'label' => esc_html__( 'Event Phone', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_website" => array(
			'label' => esc_html__( 'Event Website', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_event_type" => array(
			'label' => esc_html__( 'Event Type', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_seat" => array(
			'label' => esc_html__( 'Event Seat', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_place" => array(
			'label' => esc_html__( 'Event Place', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
        "{$prefix}_ticket" => array(
			'label' => esc_html__( 'Event Ticket Buy Link', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
        "{$prefix}_map" => array(
			'label' => esc_html__( 'Event Map', 'fmwave-core' ),
			'type'  => 'textarea_html',
			'default'  => '',
		),

	)
) );
/*
* for Podcast Post Type
*/
$fmwave_Postmeta->add_meta_box( 'podcast_info', esc_html__( 'Podcast Information', 'fmwave-core' ), array( "{$prefix}_podcast" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_soundcloud" => array(
			'label' => esc_html__( 'SoundCloud Link', 'fmwave-core' ),
			'type'  => 'textarea_html',
			'default'  => '',
		),
		"{$prefix}_spotify" => array(
			'label' => esc_html__( 'Spotify', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_extenal_link" => array(
			'label' => esc_html__( 'External Link', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_inner_link" => array(
			'label' => esc_html__( 'Inner Link / Uploaded Sound Link', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_pod_track" => array(
			'label' => esc_html__( 'Music Tracks', 'fmwave-core' ),
			'type'  => 'file',
		),

		"{$prefix}_pod_team" => array(
			'label' => esc_html__( 'Team Member', 'fmwave-core' ),
			'type'  => 'select',
			'options' => Helper::get_team(),
			'default'  => 'default',
		),

	)
)
);
/*
* for video Post Type
*/
$fmwave_Postmeta->add_meta_box( 'video_info', esc_html__( 'Video Information', 'fmwave-core' ), array( "{$prefix}_video" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_video_link" => array(
			'label' => esc_html__( 'Video Link', 'fmwave-core' ),
			'type'  => 'textarea_html',
			'default'  => '',
		),
		"{$prefix}_video_length" => array(
			'label' => esc_html__( 'Video Length', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
	)
)
);
/*
* for Show time  -  options
*/
$time_picker_format = 'time_picker_24';

$fmwave_Postmeta->add_meta_box( 'fmwave_schedule', esc_html__( 'Show Schedule', 'fmwave-core' ), array(
"{$prefix}_show" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_show_color" => array(
			'label' => esc_html__( 'Color', 'fmwave-core' ),
			'type'  => 'color_picker',
			'desc'  => esc_html__( 'Only Used to display for Show Schedule', 'fmwave-core' ),
		),
		"{$prefix}_show_schedule" => array(
			'type'  => 'repeater',
			'button' => esc_html__( 'Add New Schedule', 'fmwave-core' ),
			'value'  => array(
				'team' => array(
					'label' => __( 'Team Member', 'fmwave-core' ),
					'type'  => 'select',
					'options' => Helper::get_team(),
					'default'  => 'default',
				),
				'week' => array(
					'label' => __( 'Weekday', 'fmwave-core' ),
					'type'  => 'select',
					'options' => array(
						'none' => __( 'Select a Weekday', 'fmwave-core' ),
						'mon'  => __( 'Monday', 'fmwave-core' ),
						'tue'  => __( 'Tuesday', 'fmwave-core' ),
						'wed'  => __( 'Wednesday', 'fmwave-core' ),
						'thu'  => __( 'Thursday', 'fmwave-core' ),
						'fri'  => __( 'Friday', 'fmwave-core' ),
						'sat'  => __( 'Saturday', 'fmwave-core' ),
						'sun'  => __( 'Sunday', 'fmwave-core' ),
					),
				),
				'start_time' => array(
					'label' => __( 'Start Time', 'fmwave-core' ),
					'type'  => $time_picker_format,
				),
				'end_time' => array(
					'label' => __( 'End Time', 'fmwave-core' ),
					'type'  => $time_picker_format,
				),
				'schedule_date' => array(
					'label' => esc_html__( 'Show Date', 'fmwave-core' ),
					'type'  => 'text',
					'default'  => '',
				),
				'show_details' => array(
					'label' => esc_html__( 'Show Details', 'fmwave-core' ),
					'type'  => 'textarea_html',
					'default'  => '',
				),
			)
		),
	)
) );
$fmwave_Postmeta->add_meta_box( 'fmwave_social', esc_html__( 'Team Socials', 'fmwave-core' ), array( "{$prefix}_show" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_show_socials_header" => array(
			'label' => esc_html__( 'Socials', 'fmwave-core' ),
			'type'  => 'header',
			'desc'  => esc_html__( 'Put your Team links here', 'fmwave-core' ),
			),
		"{$prefix}_show_social" => array(
			'type'  => 'group',
			'value'  => Helper::team_socials()
			),
		)
	)
);
/*
* for Music
*/
$fmwave_Postmeta->add_meta_box( 'fmwave_music_track', esc_html__( 'Music Information', 'fmwave-core' ), array(
"{$prefix}_music" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_track" => array(
			'label' => esc_html__( 'Music Tracks', 'fmwave-core' ),
			'type'  => 'file',
		),
		"{$prefix}_album_name" => array(
			'label' => esc_html__( 'Track Album Name', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_track_length" => array(
			'label' => esc_html__( 'Music Tracks Length', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_artist" => array(
			'label' => esc_html__( 'Artist Name', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_release_day" => array(
			'label' => esc_html__( 'Release Day', 'fmwave-core' ),
			'type'  => 'date_picker',
			'format' => 'mm/dd/yy',
		),
		"{$prefix}_produce" => array(
			'label' => esc_html__( 'Produce By', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_track_no" => array(
			'label' => esc_html__( 'Number Of Track', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_details" => array(
			'label' => esc_html__( 'Album/Track Details', 'fmwave-core' ),
			'type'  => 'textarea_html',
			'default'  => '',
		),
		"{$prefix}_track_image" => array(
			'label' => esc_html__( 'Music Track Image', 'fmwave-core' ),
			'type'  => 'file',
		),
		"{$prefix}_track_album" => array(
			'label' => esc_html__( 'Music Track Album Image', 'fmwave-core' ),
			'type'  => 'file',
		),
		"{$prefix}_track_rating" => array(
			'label' => __( 'Select the Rating', 'fmwave-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'fmwave-core' ),
				'1'    => '1',
				'2'    => '2',
				'3'    => '3',
				'4'    => '4',
				'5'    => '5'
				),
			'default'  => 'default',
		),
	)
) 
);
$fmwave_Postmeta->add_meta_box( 'music_socials', esc_html__( 'Music Socials', 'fmwave-core' ), array( "{$prefix}_music" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_music_socials_header" => array(
			'label' => esc_html__( 'Socials', 'fmwave-core' ),
			'type'  => 'header',
			'desc'  => esc_html__( 'Music Social links here', 'fmwave-core' ),
			),
		"{$prefix}_music_social" => array(
			'type'  => 'group',
			'value'  => Helper::team_socials()
			),
		)
	)
);
/*tv show*/
$fmwave_Postmeta->add_meta_box( 'tvshow', esc_html__( 'TV Show', 'fmwave-core' ), array( "{$prefix}_tvshow" ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_tvshow_year" => array(
			'label' => esc_html__( 'Year', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_tvshow_imdb" => array(
			'label' => esc_html__( 'Imdb', 'fmwave-core' ),
			'type'  => 'text',
		),
		"{$prefix}_tvshow_video_link" => array(
			'label' => esc_html__( 'Video Link', 'fmwave-core' ),
			'type'  => 'textarea_html',
			'default'  => '',
		),
		"{$prefix}_tvshow_director" => array(
			'label' => esc_html__( 'Director', 'fmwave-core' ),
			'type'  => 'text',
			'default'  => '',
		),
		"{$prefix}_tv_slider" => array(
			'label' => esc_html__( 'Slider Image', 'fmwave-core' ),
			'type'  => 'image',
			'desc'  => esc_html__( 'If not selected, default will be used', 'fmwave-core' ),
		),
	)
)
);
