<?php
/*
Plugin Name: Fmwave-Core
Plugin URI: https://www.radiustheme.com
Description: Fmwave Core Plugin for Fmwave Theme
Version: 2.9.4
Author: RadiusTheme
Author URI: https://www.radiustheme.com
*/

if (! defined('ABSPATH')) {
    exit;
}
if (! defined('FMWAVE_CORE')) {
    define('FMWAVE_CORE', ( WP_DEBUG ) ? time() : '1.0');
    define('FMWAVE_CORE_THEME', 'fmwave');
    define('FMWAVE_CORE_THEME_VAR', 'fmwave');
    define('FMWAVE_CORE_CPT', 'rtcpt');

    define('FMWAVE_CORE_DIR', plugin_dir_path(__FILE__));
    define('FMWAVE_CORE_URL', plugin_dir_url(__FILE__));
    define('FMWAVE_CORE_ASSETS', trailingslashit(FMWAVE_CORE_URL . 'assets'));
}
class Fmwave_Core
{
    public $plugin  = 'fmwave-core';
    public $action  = 'fmwave_theme_init';
    public function __construct()
    {
        $prefix = FMWAVE_CORE_THEME_VAR;
        add_action('plugins_loaded', array( $this, 'demo_importer' ), 15);
        add_action('plugins_loaded', array( $this, 'load_textdomain' ), 16);
        add_action('after_setup_theme', array( $this, 'post_types' ), 15);
        add_action('after_setup_theme', array( $this, 'elementor_widgets' ));
        add_action($this->action, array( $this, 'after_theme_loaded' ));
        // Redux Flash permalink after options changed
        add_action("redux/options/{$prefix}/saved", array( $this, 'flush_redux_saved' ), 10, 2);
        add_action("redux/options/{$prefix}/section/reset", array( $this, 'flush_redux_reset' ));
        add_action("redux/options/{$prefix}/reset", array( $this, 'flush_redux_reset' ));
        add_action('init', array( $this, 'rewrite_flush_check' ));
        
        require_once 'module/rt-post-views.php';
        require_once 'module/rt-post-share.php';
        require_once 'lib/optimization/__init__.php';
    }
    public function demo_importer()
    {
        require_once FMWAVE_CORE_DIR . 'inc/demo-importer.php';
    }
    public function load_textdomain()
    {
        load_plugin_textdomain($this->plugin, false, dirname(plugin_basename(__FILE__)) . '/languages');
    }

    public function after_theme_loaded()
    {
        require_once FMWAVE_CORE_DIR . 'lib/wp-svg/init.php'; // SVG support
    }

    public function post_types()
    {
        if (!did_action($this->action) || ! defined('RT_FRAMEWORK_VERSION')) {
            return;
        }

        require_once 'post-types.php';
        require_once 'post-meta.php';
        require_once 'widgets/init.php';
        require_once 'sidebar-generator.php';
    }

    public function elementor_widgets()
    {
        if (did_action('elementor/loaded')) {
            require_once 'elementor/init.php';
        }
    }

    // Flush rewrites
    public function flush_redux_saved($saved_options, $changed_options)
    {
        if (empty($changed_options)) {
            return;
        }
        $prefix = FMWAVE_CORE_THEME_VAR;
        $flush  = false;
        if ($flush) {
            update_option("{$prefix}_rewrite_flash", true);
        }
    }

    public function flush_redux_reset()
    {
        $prefix = FMWAVE_CORE_THEME_VAR;
        update_option("{$prefix}_rewrite_flash", true);
    }

    public function rewrite_flush_check()
    {
        $prefix = FMWAVE_CORE_THEME_VAR;
        if (get_option("{$prefix}_rewrite_flash") == true) {
            flush_rewrite_rules();
            update_option("{$prefix}_rewrite_flash", false);
        }
    }
}
new Fmwave_Core;
// Plugin Hooks
require_once FMWAVE_CORE_DIR . 'plugin-hooks.php';
