<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;


if ( ! defined( 'ABSPATH' ) ) exit;
class RT_Video extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Video Box', 'fmwave-core' );
		$this->rt_base = 'rt-video-box';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'jquery-magnific-popup' );	
		wp_enqueue_style( 'magnific-popup' );	
	}
	public function rt_fields(){

		$prefix = FMWAVE_CORE_CPT;
		$terms = get_terms( array( 'taxonomy' => "{$prefix}_video_category" ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'fmwave-core' ) );
		foreach ( $terms as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),

			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),					
					'layout3' => esc_html__( 'Layout 3', 'fmwave-core' ),
					'layout4' => esc_html__( 'Layout 4', 'fmwave-core' ),
					'layout5' => esc_html__( 'Layout 5', 'fmwave-core' ),
					'layout6' => esc_html__( 'Layout 6', 'fmwave-core' ),
				),
				'default' => 'layout1',
			),
			array(
				'id'    => 'cat',
				'label' => __( 'Category', 'fmwave-core' ),
				'type'  =>  Controls_Manager::SELECT,
				'options'   => $category_dropdown,
				'default'   => '0',
				'condition'   => array( 'layout' => array( 'layout2','layout3','layout4','layout5','layout6' )),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'How many video you want to show?', 'fmwave-core' ),
				'default' => '1',
				'condition'   => array( 'layout' => array( 'layout2', 'layout4','layout5','layout6' )),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'fm_post_id',
				'label'   => esc_html__( 'Post ID to show only post', 'fmwave-core' ),
				'default' => '',
				'condition'   => array( 'layout' => array( 'layout1' )),
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'fmwave-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'fmwave-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'fmwave-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'post_orderby',
				'label'   => esc_html__( 'Post Sorting', 'fmwave-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'fmwave-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'fmwave-core' ),
					'title' 		=> esc_html__( 'By Name', 'fmwave-core' ),
				),
				'default' => 'recent',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'fm_post_ids',
				'label'   => esc_html__( 'Post IDs to show post. Comma Separated', 'fmwave-core' ),
				'default' => '',
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_small_count',
				'label'   => esc_html__( 'Title small count', 'fmwave-core' ),
				'default' => '5',
				'condition'   => array( 'layout' => array( 'layout4','layout5','layout6' )),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'title_style',
				'label'       =>esc_html__( 'Show Title', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide Title. Default: On', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout1', 'layout2', 'layout4','layout5','layout6' )),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_count',
				'label'       =>esc_html__( 'Show View Count', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide View Style. Default: On', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout1', 'layout2', 'layout4','layout5','layout6' )),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_length',
				'label'       =>esc_html__( 'Show Length', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide Length Style. Default: On', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout1', 'layout2', 'layout4','layout5','layout6' )),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'button_text',
				'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
				'default' => esc_html__('More Videos', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout3' )),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'button_url',
				'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
				'default' => esc_html__('#', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout3' )),
			),
			
			array(
				'mode' => 'section_end',
			),
			
			/*button*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button',
				'label'   => esc_html__( 'Button', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout5' )),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'btntext',
				'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
				'default' => esc_html__( 'SEE ALL VIDEOS', 'fmwave-core' ),
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => esc_html__( 'Button Link', 'fmwave-core' ),
				'placeholder' => 'https://your-link.com',
			),
			
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   =>esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   =>esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   =>esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   =>esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   =>esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   =>esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
				'condition'   => array( 'layout' => array( 'layout2' )),
			),
			array(
				'mode' => 'section_end',
			),

			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .video-story .video-box .item-content .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab .tab-content .tab-pane .item-content .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab .nav-tabs .nav-item .item-content .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-2 .tab-content .tab-pane .item-content .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-2 .nav-tabs .nav-item .item-content .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-3 .tab-content .tab-pane .item-content .item-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_hover_color',
				'label'   => __( 'Title Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .video-story .video-box .item-content .item-title a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab .tab-content .tab-pane .item-content .item-title a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab .nav-tabs .nav-item .item-content .item-title a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-2 .tab-content .tab-pane .item-content .item-title a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-3 .tab-content .tab-pane .item-content .item-title a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_text_color',
				'label'   => __( 'Meta Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .video-story .video-box .item-content .entry-meta li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab .tab-content .tab-pane .item-content .entry-meta li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-2 .tab-content .tab-pane .item-content .entry-meta li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-3 .tab-content .tab-pane .item-content .entry-meta li' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_icon_color',
				'label'   => __( 'Meta Icon Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .video-story .video-box .item-content .entry-meta li i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab .tab-content .tab-pane .item-content .entry-meta li i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-2 .tab-content .tab-pane .item-content .entry-meta li i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-2 .tab-content .tab-pane .item-content .entry-meta li:after' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-tab-3 .tab-content .tab-pane .item-content .entry-meta li i' => 'color: {{VALUE}}',
				),
			),

			array(
				'mode' => 'section_end',
			),
			// Button style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style',
				'label'   => esc_html__( 'Button', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'layout' => array( 'layout5' )),
			),			
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'button_typo',
				'label'   => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .video-tab-2 .rt-item-btn a',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_color',
				'label'   => __( 'Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_color',
				'label'   => __( 'Background Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a' => 'background-color: {{VALUE}}',
				),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_hover_color',
				'label'   => __( 'Background Hover Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a:after' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'button_radius',
				'label'   => __( 'Border Radius', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				 'mode'          => 'responsive',
				'id'      => 'button_padding',
				'label'   => __( 'Padding', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),  
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'button_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .video-tab-2 .rt-item-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),
			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['layout'] ) {
			case 'layout6':
				$template = 'video-6';
			break;
			case 'layout5':
				$template = 'video-5';
			break;
			case 'layout4':
				$template = 'video-4';
			break;
			case 'layout3':
				$template = 'video-3';
			break;
			case 'layout2':
				$template = 'video-2';
			break;
			default:
				$template = 'video-1';
			break;
			}
		return $this->rt_template( $template, $data );
	}
}