<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;


if ( ! defined( 'ABSPATH' ) ) exit;
class Video_With_Image extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Video With Image', 'fmwave-core' );
		$this->rt_base = 'rt-video-with-image';
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'jquery-magnific-popup' );	
		wp_enqueue_style( 'magnific-popup' );	
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],			
				'description' => esc_html__( 'Recommended full image', 'fmwave-core' ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',			
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' 	  => 'image_size', 
				'separator' => 'none',		
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'videourl',
				'label'   => esc_html__( 'Video URL', 'fmwave-core' ),
				'default' => 'http://www.youtube.com/watch?v=1iIZeIy7TqM',
			),
			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		$template = 'video-with-image';

		return $this->rt_template( $template, $data );
	}
}