<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Track extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Music Track Widget', 'fmwave-core' );
		$this->rt_base = 'rt-track';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'wp-mediaelement' );
	}
	public function rt_fields(){

		$prefix = FMWAVE_CORE_CPT;

		$terms = get_terms( array( 'taxonomy' => "{$prefix}_music_category" ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'fmwave-core' ) );
		foreach ( $terms as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),

			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),
					'layout3' => esc_html__( 'Layout 3', 'fmwave-core' ),
				),
				'default' => 'layout1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'auto_start_option',
				'label'   => esc_html__( 'Auto Start on Page Load', 'fmwave-core' ),
				'options' => array(
					'on' => esc_html__( 'Auto Play On', 'fmwave-core' ),
					'off' => esc_html__( 'Auto Play Off', 'fmwave-core' ),
				),
				'default' => 'off',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'fm_track_ids',
				'label'   => esc_html__( 'Track ID to play the track.', 'fmwave-core' ),
				'default' => '',
				'description' => esc_html__( 'Track ID, Like: 258', 'fmwave-core' ),
			),
			array(
				'type'    	=> Controls_Manager::MEDIA,
				'id'    	=> 'chart_top_image',
				'default' 	=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'label'   => esc_html__( 'Chart Heading Image', 'fmwave-core' ),
				'description' => esc_html__( 'Upload the chart heading Image', 'fmwave-core' ),
				'condition'   => array( 'layout' => array( 'layout3' )),
			),			
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',
				'condition'   => array( 'layout' => array( 'layout3' )),
			),
			array(
				'mode' => 'section_end',
			),

			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .single-music .music-name .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .media .media-body .item-heading .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-music .media .media-body .item-heading .item-title a' => 'color: {{VALUE}}',

					'{{WRAPPER}} .music-channel .channel-content .item-img .top-content .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .music-channel .channel-content .item-img .top-content .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .music-channel-3 .music-box .item-content .item-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'artis_color',
				'label'   => __( 'Artist Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .music-channel .channel-content .item-img .top-content .item-subtitle' => 'color: {{VALUE}}',
					'{{WRAPPER}} .music-channel-3 .music-box .item-content .item-album' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout2','layout3' )),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'category_color',
				'label'   => esc_html__( 'Category Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
						'{{WRAPPER}} .music-channel .channel-content .item-content .item-title' => 'color: {{VALUE}}',
						'{{WRAPPER}} .music-channel .channel-content .item-content .item-title a' => 'color: {{VALUE}}',
						'{{WRAPPER}} .music-channel-3 .music-box .item-content .item-subtitle' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => __( 'Content Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .music-channel .channel-content .item-content p' => 'color: {{VALUE}}',
				),
				'condition'         => [ 'layout'   => 'layout2' ],
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_color',
				'label'   => __( 'Meta Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .music-channel .channel-content .item-img .top-content .action-icon li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .music-channel-3 .music-box .item-content .item-album span' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array( 'layout2','layout3' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'track_bg_color',
				'label'   => esc_html__( 'Track Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-audio-player-wrap' => 'background-color: {{VALUE}}',
				),
				'condition'         => [ 'layout'   => 'layout1' ],
			),

			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['layout'] ) {
			case 'layout3':
				$template = 'track-3';
			break;
			case 'layout2':
				$template = 'track-2';
			break;
			default:
				$template = 'track-1';
			break;
			}
		return $this->rt_template( $template, $data );
	}
}