<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;
class Title extends Custom_Widget_Base {
    public function __construct( $data = [], $args = null ){
            $this->rt_name = esc_html__( 'Section Title', 'fmwave-core' );
            $this->rt_base = 'rt-title';
            parent::__construct( $data, $args );
    }
public function rt_fields(){
    $fields = array(
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_general',
                'label'   => esc_html__( 'General', 'fmwave-core' ),
            ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   =>esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'style1' =>esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' =>esc_html__( 'Style 2', 'fmwave-core' ),
					'style3' =>esc_html__( 'Style 3', 'fmwave-core' ),

				),
				'default' => 'style1',
			),
            array(
            	'type'    => Controls_Manager::CHOOSE,
				'mode'	  => 'responsive',
				'id'      => 'alignment',
				'label'   => esc_html__( 'Alignment', 'fmwave-core' ),
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'htmega-addons' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'htmega-addons' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'htmega-addons' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-defauly-style' => 'text-align: {{VALUE}};',
                ],
				'default' => 'center',
            ),
            array(
                'type'    => Controls_Manager::TEXTAREA,
                'id'      => 'title',
                'label'   => esc_html__( 'Section Title', 'fmwave-core' ),
                'default' => 'Section Title Here',
                 'separator' => 'before',
            ),
           array(
            'type'    => Controls_Manager::CHOOSE,
            'id'      => 'title_tag',
            'label'   => esc_html__( 'Title HTML Tag', 'fmwave-core' ),
            'options' => array(
                'h1'  => [
                    'title' => esc_html__( 'H1', 'fmwave-core' ),
                    'icon' => 'eicon-editor-h1'
                ],
                'h2'  => [
                    'title' => esc_html__( 'H2', 'fmwave-core' ),
                    'icon' => 'eicon-editor-h2'
                ],
                'h3'  => [
                    'title' => esc_html__( 'H3', 'fmwave-core' ),
                    'icon' => 'eicon-editor-h3'
                ],
                'h4'  => [
                    'title' => esc_html__( 'H4', 'fmwave-core' ),
                    'icon' => 'eicon-editor-h4'
                ],
                'h5'  => [
                    'title' => esc_html__( 'H5', 'fmwave-core' ),
                    'icon' => 'eicon-editor-h5'
                ],
                'h6'  => [
                    'title' => esc_html__( 'H6', 'fmwave-core' ),
                    'icon' => 'eicon-editor-h6'
                ],
                'div'  => [
                    'title' => esc_html__( 'div', 'fmwave-core' ),
                    'icon' => 'eicon-font'
                ]
            ),
            'default' => 'h2',
        ),  
        array(
            'type'    => Controls_Manager::TEXTAREA,
            'id'      => 'subtitle',
            'label'   => esc_html__( 'Subtitle', 'fmwave-core' ),
            'default' => 'Lorem Ipsum has been standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
             'separator' => 'before',
        ),
        array(
            'mode' => 'section_end',
        ),
    
        // Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'sec_title_style',
            'label'   => esc_html__( 'Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),
        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'title_color',
            'label'   => __( 'Color', 'fmwave-core' ),
            'default' => '#111111',                       
            'selectors' => array(
                    '{{WRAPPER}} .heading-title' => 'color: {{VALUE}}',
                ),
        ),		
		array (
			'mode'    => 'group',
			'type'    => Group_Control_Typography::get_type(),
			'name'    => 'title_typo',
			'label'   => esc_html__( 'Title Typography', 'fmwave-core' ),
			'selector' => '{{WRAPPER}} .heading-title',
		),			
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
             'mode'          => 'responsive',
            'id'      => 'title_padding',
            'label'   => __( 'Padding', 'fmwave-core' ),
            'selectors' => array(
                '{{WRAPPER}} .heading-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ),
            'separator' => 'before',
        ),  
        array(
			'type'    => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em' ],
			'mode'          => 'responsive',
			'id'      => 'title_margin',
			'label'   => __( 'Margin', 'fmwave-core' ),
			'selectors' => array(
				'{{WRAPPER}} .heading-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
			),
	        'separator' => 'before',
        ),
        array(
            'mode' => 'section_end',
        ),

        // section subtitle  style
        array(
            'mode'    => 'section_start',
            'id'      => 'sec_subtitle_style',
            'label'   => esc_html__( 'Sub Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ), 
        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'subtitle_color',
            'label'   => __( 'Color', 'fmwave-core' ),
            'default' => '#646464',                       
            'selectors' => array(
                '{{WRAPPER}} .section-subtitle' => 'color: {{VALUE}}',                           
            ),
        ), 
		array (
			'mode'    => 'group',
			'type'    => Group_Control_Typography::get_type(),
			'name'    => 'subtitle_font_typo',
			'label'   => esc_html__( 'Subtitle Typography', 'fmwave-core' ),
			'selector' => '{{WRAPPER}} .section-subtitle',
		),
		
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'mode'          => 'responsive',
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'subtitle_padding',
            'label'   => __( 'Padding', 'fmwave-core' ),
            'selectors' => array(
                '{{WRAPPER}} .section-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
            ),
            'separator' => 'before',
        ),  
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'mode'          => 'responsive',
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'subtitle_margin',
            'label'   => __( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .section-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
            ),
            'separator' => 'before',
        ),
		array(
			'type' 			=> Controls_Manager::SLIDER,
			'mode' 			=> 'responsive',
			'id'      		=> 'subtext_width',
			'label'   		=> esc_html__( 'Sub Text Width', 'fmwave-core' ),						
			'size_units' => array( 'px', '%', 'em' ),
			'default' => array(
			'unit' => '%',
			'size' => '',
			),
			'selectors' => array(
				'{{WRAPPER}} .section-defauly-style .section-subtitle' => 'width: {{SIZE}}{{UNIT}};',
			)
		),

        array(
            'mode' => 'section_end',
        ),

    );
    return $fields;
}
protected function render() {
        $data = $this->get_settings();

		switch ( $data['style'] ) {
			case 'style3':
				$template = 'title-3';
				break;
			case 'style2':
				$template = 'title-2';
				break;
			default:
				$template = 'title-1';
				break;
		}
        
        return $this->rt_template( $template, $data );
    }
}