<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

class Slider extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Slider', 'fmwave-core' );
		$this->rt_base = 'rt-slider';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style(  'fmwave-nivo-slider' );
		wp_enqueue_script( 'jquery-nivo-slider' );
		wp_enqueue_script( 'fmwave-nivo-home' );
	}

	public function rt_fields(){
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'banner_image', [
                'type' => Controls_Manager::MEDIA,
                'label'   => __( 'Banner Image', 'fmwave-core' ),
                'label_block' => true,
				'description' => esc_html__( 'Recommended image size is 1920px X 880px', 'fmwave-core' ),
            ]
        );
        $repeater->add_control(
			'banner_text', [
				'type' 		  => Controls_Manager::TEXTAREA,
				'label'       => esc_html__( 'Banner Text', 'fmwave-core' ),
				'default'     => '<span>THERE IS ALWAYS</span> Something Great Idea Work...',
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'button_text', [
				'type' 		  => Controls_Manager::TEXT,
				'label'       => esc_html__( 'Button Text', 'fmwave-core' ),
				'default' => __( 'BY THIS THEME', 'fmwave-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'button_url', [
				'type' 		  => Controls_Manager::URL,
				'label'       => esc_html__( 'Button URL', 'fmwave-core' ),
				'placeholder' => esc_url('https://your-link.com' ),
			]
		);
		$repeater->add_control(
			'show_title', [
				'type' 		  => Controls_Manager::TEXTAREA,
				'label'       => esc_html__( 'Title', 'fmwave-core' ),
				'default'     => esc_html__('With Jazmyne Shields', 'fmwave-core' ),
				'label_block' => true,
			]
		);

		$fields = array(		
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'banner_list',
				'label'   => __( 'Add as many slide as you want', 'fmwave-core' ),
				'fields'  => $repeater->get_controls(),
				'default'  => [
					[
						'banner_text'  => '<span>THERE IS ALWAYS</span> Something Great Idea Work...',
						'button_text'  => __( 'BY THIS THEME', 'fmwave-core' ),
						'show_time'  => __( 'Sun-Thu 12 pm', 'fmwave-core' ),
						'show_title'  => __( 'With Jazmyne Shields', 'fmwave-core' ),
					],
				],
			),

			array(
				'mode' => 'section_end',
			),

		);
		return $fields;
	}

	protected function render() {

		$data = $this->get_settings();
		$this->rt_load_scripts();
		$template = 'slider';
		return $this->rt_template( $template, $data );

	}
}