<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Show_Now extends Custom_Widget_Base {
	

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Current Show', 'fmwave-core' );
		$this->rt_base = 'rt-show-now';
		parent::__construct( $data, $args ); 
	}  

	public function rt_fields(){
		$prefix = FMWAVE_CORE_CPT;
		global $post;
		$post_dropdown = array( '0' => esc_html__( 'All Show', 'fmwave-core' ) );
		$args = array( 'post_type' => "{$prefix}_show", 'numberposts' => -1);
		$myposts = get_posts( $args );
		foreach( $myposts as $post ) {
			setup_postdata($post);
			
			$post_dropdown[$post->ID] = $post->post_title;
			
		} wp_reset_postdata();
		
		//Show post
		$all_post_list = [];
		$default_post = '';

		$post_args = array(
		    'post_type' => 'rtcpt_show',
		    'post_status' => 'publish',
		    'posts_per_page' => -1,
		);
		$custom_posts = get_posts($post_args);   
		if(!empty($custom_posts)){
			$i = 1;
			foreach($custom_posts as $single_post){
				if ( $i == 1 ) {
					$default_post = $single_post->ID;
				}
			    $all_post_list[ $single_post->ID ] = $single_post->post_title;
			    $i++;
			}
		} 

		//Track post
		$all_track_list = [];
		$default_track = '';

		$post_args = array(
		    'post_type' => 'rtcpt_music',
		    'post_status' => 'publish',
		    'posts_per_page' => -1,
		);
		$custom_tracks = get_posts($post_args);   
		if(!empty($custom_tracks)){
			$m = 1;
			foreach($custom_tracks as $single_track){
				if ( $m == 1 ) {
					$default_track = $single_track->ID;
				}
			    $all_track_list[ $single_track->ID ] = $single_track->post_title;
			    $m++;
			}
		} 

		$fields = array(
	
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_image_icon',
				'label'   => esc_html__( 'Options', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'show_display_type',
				'label'   => esc_html__( 'Show Display Type', 'fmwave-core' ),
				'options' => array(
					'dynamic' => esc_html__( 'Dynamic Show', 'fmwave-core' ),
					'manual' => esc_html__( 'Manual Show', 'fmwave-core' ),
					'manual2' => esc_html__( 'Dynamic Show 2', 'fmwave-core' ),
					'manual3' => esc_html__( 'Dynamic Show 3', 'fmwave-core' ),
				),
				'default' => 'manual',
				'description' => esc_html__( 'Manually type means you insert the show data, Dynamic type means it will automatically select show for database as per time of the show',
					'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'fm_track_ids',
				'label'   => esc_html__( 'Show Name.', 'fmwave-core' ),
				'options' => $all_post_list,
				'default' => $default_post, 
				'condition'   => array( 'show_display_type' => array( 'dynamic', 'manual2', 'manual3')),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'fm_music_id',
				'label'   => esc_html__( 'Music Lists', 'fmwave-core' ),
				'options' => $all_track_list,
				'default' => $default_track, 
				'condition'   => array( 'show_display_type' => array( 'manual2')),
			),
			array(
				'type'    	=> Controls_Manager::MEDIA,
				'id'    	=> 'image',
				'default' 	=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'label'   => esc_html__( "RJ's Image / Host's Image", 'fmwave-core' ),
				'description' => esc_html__( 'Upload the Host Image', 'fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'dynamic','manual','manual2','manual3')),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',
				'condition'   => array( 'show_display_type' => array( 'dynamic','manual','manual2','manual3')),
			),	
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'button_text',
				'label'   => esc_html__( 'Top Button Text', 'fmwave-core' ),
				'default' =>  esc_html__('Current Show','fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'manual')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'rj_title',
				'label'   => esc_html__( 'Name of the RJ\'s name', 'fmwave-core' ),
				'default' =>  esc_html__('RJ Anna Yost','fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'manual')),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'show_description',
				'label'   => esc_html__( 'Show Description', 'fmwave-core' ),
				'default' => esc_html__('Grursus mal suada faci lisis Lorem ipsum dolarorit more a ametion consectetur elit. Vesti at bulum nec odio aea the dumm ipsumm is ipsum that dolocons rsus mal suada.',
			'fmwave-cre'),
				'condition'   => array( 'show_display_type' => array( 'manual')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'show_time_text',
				'label'   => esc_html__( 'Show Time Heading Text', 'fmwave-core' ),
				'default' =>  esc_html__('Show Time','fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'manual', 'manual2')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'show_day',
				'label'   => esc_html__( 'Show Day', 'fmwave-core' ),
				'default' => esc_html__('Sunday - Monday', 'fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'manual')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'show_title',
				'label'   => esc_html__( 'Show Title', 'fmwave-core' ),
				'default' => esc_html__('Jazmyne Shields', 'fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'manual')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'show_time',
				'label'   => esc_html__( 'Show Time', 'fmwave-core' ),
				'default' => esc_html__('12.00am - 2.00am', 'fmwave-core' ),
				'condition'   => array( 'show_display_type' => array( 'manual')),
			),
			array(
				'mode' => 'section_end',
			),

			/*Title*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .default-show .media .media-body .item-title, {{WRAPPER}} .current-show-3 .item-content .item-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-show .media .media-body .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .default-show .media .media-body .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .current-show-3 .item-content .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .current-show-3 .item-content .item-title a' => 'color: {{VALUE}}',
				),
			),
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'size_units' => [ 'px', '%', 'em' ],
	             'mode'          => 'responsive',
	            'id'      => 'title_padding',
	            'label'   => __( 'Padding', 'fmwave-core' ),
	            'selectors' => array(
	                '{{WRAPPER}} .default-show .media .media-body .item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
	                '{{WRAPPER}} .current-show-3 .item-content .item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
	            ),
	            'separator' => 'before',
	        ),  
	        array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'title_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .default-show .media .media-body .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					'{{WRAPPER}} .current-show-3 .item-content .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
		        'separator' => 'before',
	        ),			
			array(
				'mode' => 'section_end',
			),
			/*Rj Title*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_rj_style',
				'label'   => esc_html__( 'RJ Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'rj_typo',
				'label'   => esc_html__( 'RJ Typo', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .default-show .media .media-body .host-name, {{WRAPPER}} .current-show-3 .item-content .host-name',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'rj_color',
				'label'   => esc_html__( 'RJ Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-show .media .media-body .host-name' => 'color: {{VALUE}}',
					'{{WRAPPER}} .current-show-3 .item-content .host-name' => 'color: {{VALUE}}',
				),
			),
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'size_units' => [ 'px', '%', 'em' ],
	             'mode'          => 'responsive',
	            'id'      => 'rj_padding',
	            'label'   => __( 'Padding', 'fmwave-core' ),
	            'selectors' => array(
	                '{{WRAPPER}} .default-show .media .media-body .host-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
	                '{{WRAPPER}} .current-show-3 .item-content .host-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
	            ),
	            'separator' => 'before',
	        ),  
	        array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'rj_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .default-show .media .media-body .host-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					'{{WRAPPER}} .current-show-3 .item-content .host-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
		        'separator' => 'before',
	        ),			
			array(
				'mode' => 'section_end',
			),

			/*Title*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style',
				'label'   => esc_html__( 'Button', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'show_display_type' => array( 'dynamic','manual')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'top_button_bg_color',
				'label'   => esc_html__( 'Top Button Bg Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
						'{{WRAPPER}} .current-show .media .media-body .show-status' => 'background-color: {{VALUE}}',
					),
			),
			array(
				'mode' => 'section_end',
			),
	
		);
		return $fields;
	}
	
	protected function render() {
		$data = $this->get_settings();
		
		switch ( $data['show_display_type'] ) {
			case 'manual3':
				$template = 'show-now-manually-3';
				break;
			case 'manual2':
				$template = 'show-now-manually-2';
				break;			
			case 'manual':
				$template = 'show-now-manually';
				break;
			default:
				$template = 'show-now-dynamic';
		}
		
		return $this->rt_template( $template, $data );
	}
	
}