<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use Elementor\Controls_Manager;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;


if ( ! defined( 'ABSPATH' ) ) exit;
class RT_Podcast extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Podcast', 'fmwave-core' );
		$this->rt_base = 'rt-podcast';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$prefix = FMWAVE_CORE_CPT;
		$terms = get_terms( array( 'taxonomy' => "{$prefix}_podcast_category" ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'fmwave-core' ) );
		foreach ( $terms as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Podcast Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),					
				),
				'default' => 'layout1',
			),
			array(
				'id'    => 'cat',
				'label' => __( 'Category', 'fmwave-core' ),
				'type'  =>  Controls_Manager::SELECT,
				'options'   => $category_dropdown,
				'default'   => '0',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'How many video you want to show?', 'fmwave-core' ),
				'default' => '6',
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'fmwave-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'fmwave-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'fmwave-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'post_orderby',
				'label'   => esc_html__( 'Post Sorting', 'fmwave-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'fmwave-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'fmwave-core' ),
					'title' 		=> esc_html__( 'By Name', 'fmwave-core' ),
				),
				'default' => 'recent',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title Count', 'fmwave-core' ),
				'default' => '3',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'excerpt_count',
				'label'   => esc_html__( 'Excerpt Count', 'fmwave-core' ),
				'default' => '30',
				'condition'   => array('layout' => array( 'layout2'  ) ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'pod_pagination',
				'label'       => esc_html__( 'Show Pagination', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   =>esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   =>esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   =>esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   =>esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   =>esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   =>esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();

		switch ( $data['layout'] ) {
			case 'layout2':
			$template = 'podcast-2';
			break;
			default:
			$template = 'podcast';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}