<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;
    class Paragraph_Title extends Custom_Widget_Base {
        public function __construct( $data = [], $args = null ){
                $this->rt_name = esc_html__( 'Paragraph With Title', 'fmwave-core' );
                $this->rt_base = 'rt-paragraph-title';
                parent::__construct( $data, $args );
        }
        public function rt_fields(){
            $fields = array(
                array(
                        'mode'    => 'section_start',
                        'id'      => 'sec_general',
                        'label'   => esc_html__( 'Title Before', 'fmwave-core' ),
                ),
                array(
                    'type'    => Controls_Manager::TEXTAREA,
                    'id'      => 'subtitle',
                    'label'   => esc_html__( 'Title Before', 'fmwave-core' ),
                    'default' => 'Who We are ',
                ),
                array(
                    'mode' => 'section_end',
                ),
                array(
                        'mode'    => 'section_start',
                        'id'      => 'sec_title',
                        'label'   => esc_html__( 'Title', 'fmwave-core' ),
                ),
                array(
                    'type'    => Controls_Manager::TEXTAREA,
                    'id'      => 'title',
                    'label'   => esc_html__( 'Title', 'fmwave-core' ),
                    'default' => 'The Right Choice for Quality Home Improvement for More Than 70 Years',
                ),
                array(
                    'type'    => Controls_Manager::CHOOSE,
                    'id'      => 'title_tag',
                    'label'   => esc_html__( 'Title HTML Tag', 'fmwave-core' ),
                    'options' => array(
                        'h1'  => [
                            'title' => esc_html__( 'H1', 'fmwave-core' ),
                            'icon' => 'eicon-editor-h1'
                        ],
                        'h2'  => [
                            'title' => esc_html__( 'H2', 'fmwave-core' ),
                            'icon' => 'eicon-editor-h2'
                        ],
                        'h3'  => [
                            'title' => esc_html__( 'H3', 'fmwave-core' ),
                            'icon' => 'eicon-editor-h3'
                        ],
                        'h4'  => [
                            'title' => esc_html__( 'H4', 'fmwave-core' ),
                            'icon' => 'eicon-editor-h4'
                        ],
                        'h5'  => [
                            'title' => esc_html__( 'H5', 'fmwave-core' ),
                            'icon' => 'eicon-editor-h5'
                        ],
                        'h6'  => [
                            'title' => esc_html__( 'H6', 'fmwave-core' ),
                            'icon' => 'eicon-editor-h6'
                        ],
                        'div'  => [
                            'title' => esc_html__( 'div', 'fmwave-core' ),
                            'icon' => 'eicon-font'
                        ]
                    ),
                    'default' => 'h2',
                    
                ), 
                array(
                        'mode' => 'section_end',
                ),

                array(
                        'mode'    => 'section_start',
                        'id'      => 'sec_content',
                        'label'   => esc_html__( 'Content', 'fmwave-core' ),
                ),
                array(
                        'type'    => Controls_Manager::WYSIWYG,
                        'id'      => 'paragraph',
                        'label'   => esc_html__( 'Paragraph', 'fmwave-core' ),
                        'default' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elitwesed diam nonummconsectetuer adipiscing euismod tinciduntrem ipsum dolor sit amet, consecteturm ipsum dolor.Dorem ipsum dolor sit amet, consectetuer adipiscing elitwesed diam nonummconsectetuer adipiscing euismod tinciduntrem ipsum dolor sit amet, consecteturm ipsum dolor.Dorem ipsum dolor sit amet, consectetuer adipiscing elitwesed diam nonummer.',                            
                ),  
        array(
                'mode' => 'section_end',
        ),
         // Before Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'pwt_before_style',
            'label'   => esc_html__( 'Before Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),


            array(
                'type'    => Controls_Manager::COLOR,
                'id'      => 'before_color',
                'label'   => esc_html__( 'Color', 'fmwave-core' ),
                'default' => '',
                'selectors' => array(
                        '{{WRAPPER}} .about-box-layout2 .item-subtitle' => 'color: {{VALUE}}',
                    ),
            ),
            array(
                'mode'      => 'group',
                'type'      => Group_Control_Typography::get_type(),
                'name'      => 'pt_before_font_size',
                'label'     => esc_html__( 'Before Title Typography', 'fmwave-core' ),
                'selector'  => '{{WRAPPER}} .item-subtitle',
            ),
            array(
                'type'    => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'id'      => 'content_padding',
                'label'   => esc_html__( 'Padding', 'fmwave-core' ),
                'selectors' => array(
                    '{{WRAPPER}} .about-box-layout2 .item-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ),
                'separator' => 'before',
            ),
            array(
                'type'    => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'id'      => 'content_margin',
                'label'   => esc_html__( 'Margin', 'fmwave-core' ),
                'selectors' => array(
                    '{{WRAPPER}} .about-box-layout2 .item-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ),
                'separator' => 'before',
            ),

    array(
        'mode' => 'section_end',
    ),

    // Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'pwt_title_style',
            'label'   => esc_html__( 'Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),
        array(
            'type'    => Controls_Manager::CHOOSE,
            'mode'    => 'responsive',
            'id'      => 'alignment',
            'label'   => esc_html__( 'Alignment', 'fmwave-core' ),
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'htmega-addons' ),
                    'icon' => 'fa fa-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'htmega-addons' ),
                    'icon' => 'fa fa-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'htmega-addons' ),
                    'icon' => 'fa fa-align-right',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .about-box-layout2 .item-title' => 'text-align: {{VALUE}};',
            ],
            'default' => 'left',
        ),
        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'title_color2',
            'label'   => __( 'Color', 'fmwave-core' ),
            'default' => '#111111',
            'selectors' => array(
                    '{{WRAPPER}} .about-box-layout2 .item-title' => 'color: {{VALUE}}',
                ),
        ),
         array(
                'mode'      => 'group',
                'type'      => Group_Control_Typography::get_type(),
                'name'      => 'pt_title_font_size',
                'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
                'selector'  => '{{WRAPPER}} .item-title',
            ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'title_padding',
            'label'   => __( 'Padding', 'fmwave-core' ),
            'mode'    => 'responsive',
            'selectors' => array(
                '{{WRAPPER}} .about-box-layout2 .item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ),
            'separator' => 'before',
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'title_margin',
            'label'   => __( 'Margin', 'fmwave-core' ),
            'mode'    => 'responsive',
            'selectors' => array(
                '{{WRAPPER}} .about-box-layout2 .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ),
            'separator' => 'before',
        ),
        array(
            'type'              => Controls_Manager::SLIDER,
            'mode'              => 'responsive',
            'id'                => 'title_style_size',
            'label'             => __( 'Title Style Width', 'fmwave-core' ),
            'size_units'        => [ 'px', '%' ],

            'range'             => [
               'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ]
            ],
            'range'             => [
               '%' => [
                        'min' => 0,
                        'max' => 100,
                    ]
            ],
            'default' => array(
            'unit' => 'px',
            'size' => '',
            ),
                'selectors' => array(
                    '{{WRAPPER}} .about-box-layout2 .item-title' => 'width: {{SIZE}}{{UNIT}};',
                )
        ),


    array(
        'mode' => 'section_end',
    ),

        // section subtitle  style
        array(
            'mode'    => 'section_start',
            'id'      => 'pwt_subtitle_style',
            'label'   => esc_html__( 'Content', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),               
        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'subtitle_color',
            'label'   => __( 'Color', 'fmwave-core' ),
            'default' => '#646464',                       
            'selectors' => array(
                '{{WRAPPER}} .about-box-layout2 .rtin-paragraph' => 'color: {{VALUE}}',                           
            ),
        ),  
        array( 
            'mode'      => 'group',
            'type'      => Group_Control_Typography::get_type(),
            'name'      => 'subtitle_font_size',                
            'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
            'selector'  => '{{WRAPPER}} .rtin-paragraph',
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'subtitle_padding',
            'label'   => __( 'Padding', 'fmwave-core' ),
            'selectors' => array(
                '{{WRAPPER}} .about-box-layout2 .rtin-paragraph' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                   
            ),
            'separator' => 'before',
        ),  
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'subtitle_margin',
            'label'   => __( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .about-box-layout2 .rtin-paragraph' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
            ),
            'separator' => 'before',
        ),  
        array(
            'mode' => 'section_end',
        ),

    );
     return $fields;
    }
    protected function render() {
        $data = $this->get_settings();
         $template = 'paragraph-title';
        return $this->rt_template( $template, $data );
    }
}