<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Info_Box extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Info Box', 'fmwave-core' );
		$this->rt_base = 'rt-info-box';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(

		//layout
		array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'layout', 'fmwave-core' ),				
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' => esc_html__( 'Style 2', 'fmwave-core' ),
					'style3' => esc_html__( 'Style 3', 'fmwave-core' ),
					'style4' => esc_html__( 'Style 4', 'fmwave-core' ),
					'style5' => esc_html__( 'Style 5', 'fmwave-core' ),
				),
				'default' => 'style1',
			),
			array(
	            'type'    => Controls_Manager::CHOOSE,
	            'id'      => 'Alignment',
	            'label'   => esc_html__( 'Style', 'fmwave-core' ),
	                'options' => [
	                    'left' => [
	                        'title' => esc_html__( 'Left', 'htmega-addons' ),
	                        'icon' => 'fa fa-align-left',
	                    ],
	                    'center' => [
	                        'title' => esc_html__( 'Center', 'htmega-addons' ),
	                        'icon' => 'fa fa-align-center',
	                    ],
	                    'right' => [
	                        'title' => esc_html__( 'Right', 'htmega-addons' ),
	                        'icon' => 'fa fa-align-right',
	                    ],
	                    'justify' => [
	                        'title' => esc_html__( 'Justified', 'htmega-addons' ),
	                        'icon' => 'fa fa-align-justify',
	                    ],
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .service-box-layout3' 		=> 'text-align: {{VALUE}};',
	                    '{{WRAPPER}} .service-box-layout3d' 	=> 'text-align: {{VALUE}};',
	                    '{{WRAPPER}} .why-choose-box-layout1'   => 'text-align: {{VALUE}};',
	                    '{{WRAPPER}} .info-box-5 .info-box'   => 'text-align: {{VALUE}};',
	                ],

	             'default' => 'center',
	            ),
			array(
				'mode' => 'section_end',
			),
			// image
			array(
					'mode'    => 'section_start',
					'id'      => 'sec_image_icon',
					'label'   => esc_html__( 'Image', 'fmwave-core' ),				
			),			
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'info_image',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],			
				'description' => esc_html__( 'Recommended full image', 'fmwave-core' ),
			),
			array(
				'type'    	=> Group_Control_Image_Size::get_type(),
				'mode'    	=> 'group',
				'label'   	=> esc_html__( 'Image size', 'fmwave-core' ),	
				'name' 		=> 'info_image_size', 
			),			
		
			array(
				'mode' => 'section_end',
			),

			// content
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content',
				'label'   => esc_html__( 'Title / Content', 'fmwave-core' ),
			),
				array(
					'type'    => Controls_Manager::TEXT,
					'id'      => 'title',
					'label'   => esc_html__( 'Title', 'fmwave-core' ),
					'default' => 'Lorem Ipsum',
				),
				array(
					'type'    => Controls_Manager::TEXTAREA,
					'id'      => 'content',
					'label'   => esc_html__( 'Content', 'fmwave-core' ),
					'default' => 'Lorem Ipsum hasbeen standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
				),
			array(
				'mode' => 'section_end',
			),

			// sec_button
				array(
					'mode'    => 'section_start',
					'id'      => 'sec_button',
					'label'   => esc_html__( 'Button', 'fmwave-core' ),		
					'condition'   => array('style' => array( 'style1','style3','style4','style5'  ) ),
				),
				array(
					'type'  				=> Controls_Manager::URL,
					'id'    				=> 'url',
					'label' 				=> esc_html__( 'Link (Optional)', 'fmwave-core' ),
					'placeholder' 	=> 'https://your-link.com',
				),
				array(
					'type'  => Controls_Manager::TEXT,
					'id'    => 'url_text',
					'label' => esc_html__( 'Botton Text (Optional)', 'fmwave-core' ),
					'default' => 'Read More',					
				),
				array(
					'type'    => Controls_Manager::ICON,
					'id'      => 'button_icon',
					'label'   => esc_html__( 'Button Icon', 'fmwave-core' ),
					'default' => 'fas fa-angle-right',	
					'condition'   => array('style' => array( 'style1','style3','style4'  ) ),
				),	
				array(
					'mode' => 'section_end',
				),


				array(
				'mode'    => 'section_start',
				'id'      => 'sec_image_style',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array('style' => array( 'style1' ) ),
				),

				array(
					'type' 				=> Controls_Manager::SLIDER,
					'mode' 				=> 'responsive',
					'id'      		=> 'bottom_image_spacing',
					'label'   		=> esc_html__( 'Image Spacing', 'fmwave-core' ),
					
					'size_units' => array( 'px' ),	

					 'range' => [
			         'px' => [
			           'min' => 0,
			           'max' => 250,
			         ],
			       ],

       			
					'default' => array(
					'unit' => 'px',
					'size' => 20,
					),
						'selectors' => array(
							'{{WRAPPER}} .item-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',						
						)
					),

			array(
					'mode' => 'section_end',
				),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title ', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),


			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'bottom_title_spacing',
				'label'   		=> esc_html__( 'Bottom Spacing', 'fmwave-core' ),
				
				'size_units' => array( 'px' ),				
				'default' => array(
				'unit' => 'px',
				'size' => 20,
				),
					'selectors' => array(
						'{{WRAPPER}} .item-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',						
					)
				),

			array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'title_color',
					'label'   => esc_html__( 'Title Color', 'fmwave-core' ),
					'default' => '',
					'selectors' => array(
							'{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
							'{{WRAPPER}} .item-title a' => 'color: {{VALUE}}',
							'{{WRAPPER}} .info-box-5 .item-title a' => 'color: {{VALUE}}',
						),
				),	

			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'title_style',
				'label'       => esc_html__( 'Title Style', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'condition'   => array('style' => array( 'style1','style3' ,'style2' ) ),
				'description' =>esc_html__( 'Show or Hide Title Style. Default: On', 'fmwave-core' ),
			),	
				array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'title_style_color',
					'label'   => esc_html__( 'Title Style Color', 'fmwave-core' ),
					'default' => '#ee212b',
					'condition'   => array(
						'title_style' => array( 'yes' ),
						'style' => array( 'style1', 'style2', 'style3' ) ,
					),
					'selectors' => array(
							'{{WRAPPER}} .item-title::after' => 'background-color: {{VALUE}}',	
							'{{WRAPPER}} .title-style' => 'background-color: {{VALUE}}',	

						),
				),

			array(
			    'type'    => Controls_Manager::CHOOSE,
			    'id'      => 'title_tag',
			    'label'   => esc_html__( 'Title HTML Tag', 'fmwave-core' ),
			    'options' => array(
			        'h1'  => [
			            'title' => esc_html__( 'H1', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h1'
			        ],
			        'h2'  => [
			            'title' => esc_html__( 'H2', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h2'
			        ],
			        'h3'  => [
			            'title' => esc_html__( 'H3', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h3'
			        ],
			        'h4'  => [
			            'title' => esc_html__( 'H4', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h4'
			        ],
			        'h5'  => [
			            'title' => esc_html__( 'H5', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h5'
			        ],
			        'h6'  => [
			            'title' => esc_html__( 'H6', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h6'
			        ],
			        'div'  => [
			            'title' => esc_html__( 'div', 'fmwave-core' ),
			            'icon' => 'eicon-font'
			        ]
			    ),
			    'default' => 'h3',
			    
			),  

			array( 
					'mode'      => 'group',
					'type'      => Group_Control_Typography::get_type(),
					'name'      => 'title_typo',
					'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
					'selector'  => '{{WRAPPER}} .item-title',
				),


			array(
				'mode' => 'section_end',
			),

		array(
				'mode'    => 'section_start',
				'id'      => 'sec_content_style',
				'label'   => esc_html__( 'Content', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'bottom_content_spacing',
				'label'   		=> esc_html__( 'Bottom Spacing', 'fmwave-core' ),
				'condition' 	=> [
					'button_icon!' => '',
					],
					'size_units' => array( 'px' ),				
					'default' => array(
					'unit' => 'px',
					'size' => 20,
				),
				'selectors' => array(
					'{{WRAPPER}} p.item-content' => 'margin-bottom: {{SIZE}}{{UNIT}};',						
				)
			),

			array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'content_color',
					'label'   => esc_html__( 'Content Color', 'fmwave-core' ),
					'default' => '',
					'selectors' => array(
							'{{WRAPPER}} p.item-content' => 'color: {{VALUE}}',							
						),
				),	
		array( 
					'mode'      => 'group',
					'type'      => Group_Control_Typography::get_type(),
					'name'      => 'content_typo',
					'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
					'selector'  => '{{WRAPPER}} p.item-content',
				),
	array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_btn_style',
				'label'   => esc_html__( 'Button', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array('style' => array( 'style1','style3','style4' ) ),
			),

			array( 
					'mode'      => 'group',
					'type'      => Group_Control_Typography::get_type(),
					'name'      => 'button_typo',
					'label'     => esc_html__( 'Button Typography', 'fmwave-core' ),
					'selector'  => '{{WRAPPER}} a.btn-fill-lg , {{WRAPPER}} a.btn-fill-lg i',
					
				),
			array(					 
			   'type'    => Controls_Manager::CHOOSE,
			   'options' => [
			     'icon' => [
			      'before' => esc_html__( 'Before', 'fmwave-core' ),
			     	'icon' => 'eicon-text-align-left',
			     ],
			     'after' => [
			       'title' => esc_html__( 'After', 'fmwave-core' ),
			       'icon' => 'eicon-text-align-right',
			     ],		     
			   ],
			   'id'      => 'button_icon_position',				 
			   'label'   => esc_html__( 'Icon Position', 'fmwave-core' ),
			   'default' => 'after',
			   'label_block' => false,
			   'toggle' => false,	
					'condition' => [
						'button_icon!' => '',
					],			 
			),

			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'button_icon_spacing',
				'label'   		=> esc_html__( 'Position Top', 'fmwave-core' ),
				'condition' 	=> [
						'button_icon!' => '',
						],
				'size_units' => array( 'px' ),
					'range' => array(
						'px' => array(
						'min' => 0,
						'max' => 100,
						),
					),
				'default' => array(
				'unit' => 'px',
				'size' => 5,
				),
					'selectors' => array(
						'{{WRAPPER}} .icon-before i' => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .icon-after i' => 'margin-left: {{SIZE}}{{UNIT}};',
					)
				),
			array(
				'mode' => 'section_end',
			),



			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();	

			$template 	= 'info-box-' . str_replace("style", "", $data['style']);
		
		return $this->rt_template( $template, $data );
	}
}