<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;
class Icon_List extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Icon List', 'fmwave-core' );
		$this->rt_base = 'rt-icon-list';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),				
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'theme',
				'label'   => esc_html__( 'List Type', 'fmwave-core' ),
				'options' => array(
					'theme1' 	=> esc_html__( 'Inline List', 'fmwave-core' ),
					'theme2'  	=> esc_html__( 'Block List', 'fmwave-core' ),
				),
				'default' => 'theme1',
			),

			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'list',
				'label'   => esc_html__( 'Add as many list as you want', 'fmwave-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::TEXTAREA,
						'name'    => 'list_title',
						'label'   => esc_html__( 'List Title', 'fmwave-core' ),
						'default' => 'LOREM IPSUM DUMMY TEXT',
					),					
					array(
						'type'  => Controls_Manager::URL,
						'name'    => 'url',
						'label' => esc_html__( 'Link (Optional)', 'fmwave-core' ),
						'placeholder' => 'https://your-link.com',
					),
				),
				'default' => [
		         	['list_title' => 'Expert & Professional Engineers',],
		         	['list_title' => 'We are Award Winning Company',],
		         	['list_title' => 'Fully Satisfaction Guarantee',],
		         	['list_title' => '35 + Successfull Projects done',],		                 
		       ],
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_list_style',
				'label'   => esc_html__( 'List Style', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'list_title_color',
				'label'   => esc_html__( 'Title Style Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
						'{{WRAPPER}} .about-info li' => 'color: {{VALUE}}',	
						'{{WRAPPER}} .about-info li a' => 'color: {{VALUE}}',
					),
				),
				array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'icon_color',
					'label'   => esc_html__( 'Icon Color', 'fmwave-core' ),
					'default' => '',
					'selectors' => array(
						'{{WRAPPER}} .about-info li::after' => 'color: {{VALUE}}',
					),
				),
				array( 
					'mode'      => 'group',
					'type'      => Group_Control_Typography::get_type(),
					'name'      => 'content_typo',
					'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
					'selector'  => '{{WRAPPER}} .about-info li',	
				),
				array(
					'type' 				=> Controls_Manager::SLIDER,
					'mode' 				=> 'responsive',
					'id'      		=> 'icon_spacing',
					'label'   		=> esc_html__( 'Icon Spacing', 'fmwave-core' ),				
					'size_units' => array( 'px' ),
					'range' => [
						'px' => [
						'min' => 0,
						'max' => 100,
						],
					],		
					'default' => array(
					'unit' => 'px',
					'size' => 25,
					),
					'selectors' => array(
						'{{WRAPPER}} .about-info li' => 'padding-left: {{SIZE}}{{UNIT}};',
					)
				),

			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$template = 'list-1';	
		return $this->rt_template( $template, $data );
	}
}