<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class icon_Box extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Icon Box', 'fmwave-core' );
		$this->rt_base = 'rt-icon-box';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
	
			array(
					'mode'    => 'section_start',
					'id'      => 'sec_image_icon',
					'label'   => esc_html__( 'Icon', 'fmwave-core' ),				
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'icon_layout',
				'label'   => esc_html__( 'Icon Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),					
					'layout3' => esc_html__( 'Layout 3', 'fmwave-core' ),					
				),
				'default' => 'layout1',
			),
			array(
	            'type'    => Controls_Manager::CHOOSE,
	            'id'      => 'icon-alignment',
	            'label'   => esc_html__( 'Style', 'fmwave-core' ),
	                'options' => [
	                    'left' => [
	                        'title' => esc_html__( 'Left', 'fmwave-core' ),
	                        'icon' => 'fa fa-align-left',
	                    ],
	                    'center' => [
	                        'title' => esc_html__( 'Center', 'fmwave-core' ),
	                        'icon' => 'fa fa-align-center',
	                    ],
	                    'right' => [
	                        'title' => esc_html__( 'Right', 'fmwave-core' ),
	                        'icon' => 'fa fa-align-right',
	                    ],                   
	                ],
	                
	            'default' => 'left',
				'condition'   => array('icon_layout' => array( 'layout1' ) ),
	        ),
			array(					 
			   'type'    => Controls_Manager::CHOOSE,
			   'options' => [
			     'icon' => [
			       'title' => esc_html__( 'Left', 'fmwave-core' ),
			       'icon' => 'fa fa-smile-o',
			     ],
			     'image' => [
			       'title' => esc_html__( 'Center', 'fmwave-core' ),
			       'icon' => 'fa fa-image',
			     ],		     
			   ],
			   'id'      => 'icontype',
			   'label'   => esc_html__( 'Media Type', 'fmwave-core' ),
			   'default' => 'icon',
			   'label_block' => false,
			   'toggle' => false,				 
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon_class',
				'label'   => esc_html__( 'Icon', 'fmwave-core' ),
				'default' => [
			      'value' => 'fas fa-smile-wink',
			      'library' => 'fa-solid',
			  ],	
			  	'condition'   => array('icontype' => array( 'icon' ) ),
			),	
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'icon_image',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
				'condition'   => array('icontype' => array( 'image' ) ),
				'description' => esc_html__( 'Recommended full image', 'fmwave-core' ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',		
				'condition'   => array('icontype' => array( 'image' ) ),
			),			
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content',
				'label'   => esc_html__( 'Title / Content', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'default' => 'Lorem Ipsum',
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_post_count',
				'label'       =>esc_html__( 'Count Display', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide short Count. Default: On', 'fmwave-core' ),
				'condition'   => array('icon_layout' => array( 'layout3' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'post_count',
				'label'   => esc_html__( 'Post Count', 'fmwave-core' ),
				'default' => '',
				'condition'   => array('icon_layout' => array( 'layout3' ), 'show_post_count' => array( 'yes' ) ),


			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'fmwave-core' ),
				'default' => 'Lorem Ipsum hasbeen standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
				'condition'   => array('icon_layout' => array( 'layout1', 'layout2' ) ),
			),
			array(
				'type'  				=> Controls_Manager::URL,
				'id'    				=> 'url',
				'label' 				=> esc_html__( 'Link (Optional)', 'fmwave-core' ),
				'placeholder' 	=> 'https://your-link.com',
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_image_style',
				'label'   => esc_html__( 'Image/Icon', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				),

				array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'icon_box_width',
				'label'   		=> esc_html__( 'Icon Box Width', 'fmwave-core' ),
				'condition'   => array('icon_layout' => array( 'layout1', 'layout2' ) ),
				'size_units' => array( 'px' ),		
					'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 300,
				 ],
				],		
				'default' => array(
				'unit' => 'px',
				'size' => 40,
				),
				'selectors' => array(
					'{{WRAPPER}} .icon-box-media .item-icon' => 'width: {{SIZE}}{{UNIT}};',
				)
				
				),

				array(
					'type' 				=> Controls_Manager::SLIDER,
					'mode' 				=> 'responsive',
					'id'      		=> 'icon_box_height',
					'label'   		=> esc_html__( 'Icon Box Height', 'fmwave-core' ),
					
					'size_units' => array( 'px' ),		
					'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 300,
				 ],
				],		
				'default' => array(
				'unit' => 'px',
				'size' => 40,
				),
				'selectors' => array(
					'{{WRAPPER}} .icon-box-media .item-icon' => 'height: {{SIZE}}{{UNIT}};',						
				),
				'condition'   => array('icon_layout' => array( 'layout1', 'layout2' ) ),
				),	
				
				array(
					'type' 				=> Controls_Manager::SLIDER,
					'mode' 				=> 'responsive',
					'id'      		=> 'icon_box_padding',
					'label'   		=> esc_html__( 'Icon Box Padding', 'fmwave-core' ),
					
					'size_units' => array( 'px' ),		
					'range' => [
				'px' => [
				'min' => 0,
				'max' => 100,
				],
				],		
				'default' => array(
				'unit' => 'px',
				'size' => 10,
				),
					'selectors' => array(
						'{{WRAPPER}} .icon-box-media .item-icon' => 'padding: {{SIZE}}{{UNIT}};',						
					),
					'condition'   => array('icon_layout' => array( 'layout1', 'layout2' ) ),
				),
				array(
					'type' 				=> Controls_Manager::SLIDER,
					'mode' 				=> 'responsive',
					'id'      		=> 'bottom_image_spacing',
					'label'   		=> esc_html__( 'Icon Box Spacing', 'fmwave-core' ),
					'size_units' => array( 'px' ),	
					'default' => array(
					'unit' => 'px',
					'size' => 40,
					),
					'selectors' => array(
						'{{WRAPPER}} .icon-box-layout1.left .media-body-wrp' => 'padding-left: {{SIZE}}{{UNIT}};',						
						'{{WRAPPER}} .icon-box-layout1.center .media-body-wrp' => 'padding-top: {{SIZE}}{{UNIT}};',						
						'{{WRAPPER}} .icon-box-layout1.right .media-body-wrp' => 'padding-right: {{SIZE}}{{UNIT}};',						
						'{{WRAPPER}} .icon-box-layout2 .media-body-wrp' => 'padding-left: {{SIZE}}{{UNIT}};',		
					),
					'condition'   => array('icon_layout' => array( 'layout1', 'layout2' ) ),
				),

				array(
					'type'    => Controls_Manager::COLOR,
					'id'      => 'icon_color',
					'label'   => esc_html__( 'Icon Color', 'fmwave-core' ),
					'default' => '',						
					'selectors' => array(
						'{{WRAPPER}} .item-icon i:before' => 'color: {{VALUE}}',
					),
				),	

				array( 
					'mode'      => 'group',
					'type'      => Group_Control_Typography::get_type(),
					'name'      => 'icon_font_size',
					'condition' 	=> [
							'icontype' => 'icon',
							],
					'label'     => esc_html__( 'Icon Typography', 'fmwave-core' ),
					'selector'  => '{{WRAPPER}} .item-icon i',
				),

				array(
					'mode' => 'section_end',
				),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title / Content', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'bottom_title_spacing',
				'label'   		=> esc_html__( 'Bottom Spacing', 'fmwave-core' ),
				'condition' 	=> [
						'button_icon!' => '',
						],
				'size_units' => array( 'px' ),				
				'default' => array(
				'unit' => 'px',
				'size' => 20,
				),
				'selectors' => array(
					'{{WRAPPER}} .item-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',						
				)
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .item-title a' => 'color: {{VALUE}}',
				),
			),		
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_hover_color',
				'label'   => esc_html__( 'Title Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .item-title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .item-title a:hover' => 'color: {{VALUE}}',
				),
			),	

			array(
			    'type'    => Controls_Manager::CHOOSE,
			    'id'      => 'title_tag',
			    'label'   => esc_html__( 'Title HTML Tag', 'fmwave-core' ),
			    'options' => array(
			        'h1'  => [
			            'title' => esc_html__( 'H1', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h1'
			        ],
			        'h2'  => [
			            'title' => esc_html__( 'H2', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h2'
			        ],
			        'h3'  => [
			            'title' => esc_html__( 'H3', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h3'
			        ],
			        'h4'  => [
			            'title' => esc_html__( 'H4', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h4'
			        ],
			        'h5'  => [
			            'title' => esc_html__( 'H5', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h5'
			        ],
			        'h6'  => [
			            'title' => esc_html__( 'H6', 'fmwave-core' ),
			            'icon' => 'eicon-editor-h6'
			        ],
			        'div'  => [
			            'title' => esc_html__( 'div', 'fmwave-core' ),
			            'icon' => 'eicon-font'
			        ]
			    ),
			    'default' => 'h3',
			    
			),  
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				 'mode'          => 'responsive',
				'id'      => 'content_margin',
				'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
				'selectors' => array(
				    '{{WRAPPER}} .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
				),
			'separator' => 'before',
			),  

			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .item-title',
			),	
			array(
				'id'  	=> 'hr-1',
				'type'	=> Controls_Manager::DIVIDER,
				'style' => 'thick',
			),
			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'content_typo',
				'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .item-content',
				'condition'   => array('icon_layout' => array( 'layout1', 'layout2' ) ),
			),
			array(
				'mode' => 'section_end',
			),
	
		);
		return $fields;
	}
	
	protected function render() {
		$data = $this->get_settings();		
		
		switch ( $data['icon_layout'] ) {
			case 'layout3':
			$template = 'icon-box-3';
			break;
			case 'layout2':
			$template = 'icon-box-2';
			break;
			default:
			$template = 'icon-box-1';
			break;
		}
		
		return $this->rt_template( $template, $data );
	}
}