<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Countdown extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Countdown', 'fmwave-core' );
		$this->rt_base = 'rt-countdown';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'jquery-countdown' );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' => esc_html__( 'Style 2', 'fmwave-core' ),
					'style3' => esc_html__( 'Style 3', 'fmwave-core' ),
				),
				'default' => 'style1',
			),
			array(
				'id'        => 'date_time',
				'label'     => esc_html__( 'Date & Time', 'fmwave-core' ),
				'type'      => Controls_Manager::DATE_TIME,
				'description'  => esc_html__('Set date and time', 'fmwave-core'),
				'default' => '2021-04-05',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'countdown_title',
				'label'   => esc_html__( 'Countdown Title', 'fmwave-core' ),
				'default' => esc_html__( 'Worldwide Speakers Talks', 'fmwave-core' ),
				'condition'   => array( 'style' => array( 'style2') ),
			),			
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rt_image',
				'label'   => esc_html__( 'Image', 'fmwave-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'fmwave-core' ),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'fmwave-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    => Controls_Manager::CHOOSE,
				'mode'    => 'responsive',
				'id'      => 'align',
				'label'   => esc_html__( 'Alignment', 'fmwave-core' ),
				'options' => array(

					'left'    => array(
						'title' => esc_html__( 'Left', 'fmwave-core' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'fmwave-core' ),
						'icon' => 'eicon-text-align-center',
					),
					'flex-end' => array(
						'title' => esc_html__( 'Right', 'fmwave-core' ),
						'icon' => 'eicon-text-align-right',
					),
				),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'prefix_class' => 'content-align-%s',
				'default' => 'left',
				'selectors' => array(
					'{{WRAPPER}} .countdown-default .fmwave-countdown' => 'justify-content: {{VALUE}};',
				),
			),
			array(
				'mode' => 'section_end',
			),
			// Title style
			array(
			    'mode'    => 'section_start',
			    'id'      => 'counter_number_style',
			    'label'   => esc_html__( 'Counter Number  Style', 'fmwave-core' ),
			    'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_number_color',
			    'label'   	=> __( 'Number Color', 'fmwave-core' ),
			    'default' 	=> '',                       
			    'selectors' => array(
			        '{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-number' => 'color: {{VALUE}}',
			        '{{WRAPPER}} .rt-countdown-layout2 .fmwave-countdown .countdown-section .countdown-number' => 'color: {{VALUE}}',
			    ),
			),
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_unit_color',
			    'label'   	=> __( 'Unit Color', 'fmwave-core' ),
			    'default' 	=> '',                       
			    'selectors' => array(
			        '{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-unit' => 'color: {{VALUE}}',
			        '{{WRAPPER}} .rt-countdown-layout2 .fmwave-countdown .countdown-section .countdown-unit' => 'color: {{VALUE}}',
			    ),
			),
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_bg_color',
			    'label'   	=> __( 'Background Color', 'fmwave-core' ),
			    'default' 	=> '',
			    'selectors' => array(
			        '{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-number' => 'background-color: {{VALUE}}',
			    ),
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_title_color',
			    'label'   	=> __( 'Title Color', 'fmwave-core' ),
			    'default' 	=> '',
			    'selectors' => array(
			        '{{WRAPPER}} .event-box .media .media-body .item-title' => 'color: {{VALUE}}',
			    ),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
			    'type'    	=> Controls_Manager::COLOR,
			    'id'      	=> 'count_border_color',
			    'label'   	=> __( 'Border Color', 'fmwave-core' ),
			    'default' 	=> '',                       
			    'selectors' => array(
			        '{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section' => 'border-color: {{VALUE}}',
			    ),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array( 
			    'mode'      => 'group',
			    'type'      => Group_Control_Typography::get_type(),
			    'name'      => 'counter_number_font_size',                
			    'label'     => esc_html__( 'Number Typo', 'fmwave-core' ),
			    'selector'  =>'{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-number, {{WRAPPER}} .rt-countdown-layout2 .fmwave-countdown .countdown-section .countdown-number',	    
			),
			
			array( 
			    'mode'      => 'group',
			    'type'      => Group_Control_Typography::get_type(),
			    'name'      => 'counter_unit_font_size',                
			    'label'     => esc_html__( 'Unit Typo', 'fmwave-core' ),
			    'selector'  =>'{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-unit, {{WRAPPER}} .rt-countdown-layout2 .fmwave-countdown .countdown-section .countdown-unit',	    
			),
			
			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'countdown_box_width',
				'label'   		=> esc_html__( 'Box Width', 'fmwave-core' ),
				'size_units' => array( 'px' ),
				 'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 250,
				 ],
			   ],
			
				'default' => array(
				'unit' => 'px',
				'size' => 120,
				),
				'selectors' => array(
					'{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-number' => 'width: {{SIZE}}{{UNIT}};',						
				),
				'condition'   => array( 'style' => array( 'style1','style3' ) ),
			),
			
			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'countdown_box_height',
				'label'   		=> esc_html__( 'Box Height', 'fmwave-core' ),
				'size_units' => array( 'px' ),
				 'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 250,
				 ],
			   ],
			   
				'default' => array(
				'unit' => 'px',
				'size' => 120,
				),
				'selectors' => array(
					'{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section .countdown-number' => 'height: {{SIZE}}{{UNIT}};',						
				),
				'condition'   => array( 'style' => array( 'style1','style3' ) ),
			),
			
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode' 				=> 'responsive',
				'id'      		=> 'countdown_box_margig',
				'label'   => __( 'Margin', 'fmwave-core' ),                 
				'selectors' => array(
					'{{WRAPPER}} .countdown-default .fmwave-countdown .countdown-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
				),
				'condition'   => array( 'style' => array( 'style1','style3' ) ),
			),
			array(
				'mode' => 'section_end',
			),

		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();

		switch ( $data['style'] ) {
			case 'style3':
				$template = 'countdown-3';
				break;
			case 'style2':
				$template = 'countdown-2';
				break;
			default:
				$template = 'countdown-1';
				break;
		}

		return $this->rt_template( $template, $data );
	}
}