<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Contact extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Contact', 'fmwave-core' );
		$this->rt_base = 'rt-contact';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'default' => 'Contact Information',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'fmwave-core' ),
				'default' => esc_html__( 'Lorem Ipsum hasbeen standard daand scrambled. Rimply dummy text of the printing and typesetting industry', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general_email',
				'label'   => esc_html__( 'Email', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'email_label',
				'label'   => esc_html__( 'Email label', 'fmwave-core' ),
				'default' => 'E-mail:',
			),

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'email',
				'label'   => esc_html__( 'Email 1', 'fmwave-core' ),
				'default' => 'info@fmfave.com',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'email2',
				'label'   => esc_html__( 'Email 2', 'fmwave-core' ),
				'default' => '',
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general_phone',
				'label'   => esc_html__( 'Phone', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'phone_label',
				'label'   => esc_html__( 'Phone label', 'fmwave-core' ),
				'default' => 'Phone:',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'phone',
				'label'   => esc_html__( 'Phone 1', 'fmwave-core' ),
				'default' => '+8123 (456) 788 99',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'phone2',
				'label'   => esc_html__( 'Phone 2', 'fmwave-core' ),
				'default' => '+8123 (456) 788 99',
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general_address',
				'label'   => esc_html__( 'Address', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'address_label',
				'label'   => esc_html__( 'Address label', 'fmwave-core' ),
				'default' => 'Location:',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'address',
				'label'   => esc_html__( 'Address 1', 'fmwave-core' ),
				'default' => '51 Street, Newyork City, NYPD',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'address2',
				'label'   => esc_html__( 'Address 2', 'fmwave-core' ),
				'default' => '18 Street, Newyork City, NYPD',
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Layout Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type' 	=> Controls_Manager::SLIDER,
				'mode' 	=> 'responsive',
				'id'    => 'bottom_title_spacing',
				'label' => __( 'Bottom Spacing', 'fmwave-core' ),
				'size_units' => array( 'px' ),
				'default' => array(
					'unit' => 'px',
					'size' => 20,
				),
				'selectors' => array(
					'{{WRAPPER}} .item-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				)
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .item-title',
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_lable_style',
				'label'   => esc_html__( 'Labal', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array('layout' => array( 'layout1' ) ),
			),
			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'bottom_email_spacing',
				'label'   		=> __( 'Labal Bottom Spacing', 'fmwave-core' ),
				'size_units' => array( 'px' ),
				'default' => array(
					'unit' => 'px',
					'size' => 20,
				),
				'selectors' => array(
					'{{WRAPPER}} .lab-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				)
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'email_lab_color',
				'label'   => __( 'Labal Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .lab-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .item-icon i' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'email_typo',
				'label'     => esc_html__( 'Labal Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .lab-title',
			),

			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content_style',
				'label'   => esc_html__( 'Content', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => __( 'Content Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .content-style li' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'content_typo',
				'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .content-style li',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template 	= 'contact';

		return $this->rt_template( $template, $data );
	}
}