<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
?>
<?php
	$selected_shows = isset( $data['posts_selected_show'] ) && is_array( $data['posts_selected_show'] ) ? $data['posts_selected_show'] : array();
	$posts_id_holder = array();

	foreach ( $selected_shows as $selected_show ){
		if ( isset( $selected_show['post_list'] ) && $selected_show['post_list'] ) {
			$posts_id_holder[] = (int) $selected_show['post_list'];
		}
	}

	if ( empty( $posts_id_holder ) ) {
		return;
	}

	$thumb_size = 'fmwave-v3-b';
	$col_lg = ! empty( $data['col_lg'] ) ? (int) $data['col_lg'] : 4;
	$col_md = ! empty( $data['col_md'] ) ? (int) $data['col_md'] : 6;
	$col_sm = ! empty( $data['col_sm'] ) ? (int) $data['col_sm'] : 6;
	$col_xs = ! empty( $data['col_xs'] ) ? (int) $data['col_xs'] : 12;
	$col_class = "col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
?>
<section class="default-upcoming upcoming-show">
	<div class="row">
		<?php
			// WP-aware current time
			$now_ts = current_time( 'timestamp' );
			$today_weekday_short = strtolower( date_i18n( 'D', $now_ts ) );
			$today_weekday_long  = date_i18n( 'l', $now_ts );

			$prefix = FMWAVE_CORE_CPT;
			$args = array(
				'posts_per_page'      => ! empty( $data['number'] ) ? (int) $data['number'] : -1,
				'post_type'           => "{$prefix}_show",
				'post__in'            => $posts_id_holder,
				'orderby'             => 'post__in',
				'ignore_sticky_posts' => true,
				'no_found_rows'       => true,
			);

			$query = new WP_Query( $args );
			$temp = Helper::wp_set_temp_query( $query );

			// Map WP long weekday to fmwave short keys
			$today_key = '';
			switch ( $today_weekday_long ) {
				case 'Monday':
					$today_key = 'mon';
					break;
				case 'Tuesday':
					$today_key = 'tue';
					break;
				case 'Wednesday':
					$today_key = 'wed';
					break;
				case 'Thursday':
					$today_key = 'thu';
					break;
				case 'Friday':
					$today_key = 'fri';
					break;
				case 'Saturday':
					$today_key = 'sat';
					break;
				case 'Sunday':
					$today_key = 'sun';
					break;
			}
		?>
		<?php if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();

				$metas = get_post_meta( get_the_ID(), "{$prefix}_show_schedule", true );
				$metas = is_array( $metas ) ? $metas : array();

				// Determine today's upcoming or first start time
				$current_time_ts = null;
				if ( $metas ) {
					$todays = array();
					foreach ( $metas as $schedule ) {
						if ( isset( $schedule['week'] ) && $schedule['week'] === $today_key && ! empty( $schedule['start_time'] ) ) {
							// Build a timestamp for today using WP timezone
							$time_str = trim( (string) $schedule['start_time'] );
							$parsed   = strtotime( date_i18n( 'Y-m-d', $now_ts ) . ' ' . $time_str, $now_ts );
							if ( $parsed ) {
								$todays[] = $parsed;
							}
						}
					}
					if ( $todays ) {
						sort( $todays, SORT_NUMERIC );
						// Choose the first start time that is >= now; otherwise fallback to the earliest today
						$chosen = null;
						foreach ( $todays as $ts ) {
							if ( $ts >= $now_ts ) {
								$chosen = $ts;
								break;
							}
						}
						$current_time_ts = $chosen !== null ? $chosen : $todays[0];
					}
				}

				$start_time_formatted = $current_time_ts ? date_i18n( get_option( 'time_format' ), $current_time_ts ) : '';

				// Attempt to get host/team title if available
				$host_title = '';
				if ( $metas && isset( $metas[0]['team'] ) && $metas[0]['team'] ) {
					$host_title = get_the_title( (int) $metas[0]['team'] );
				}
		?>
		<div class="<?php echo esc_attr( $col_class ); ?>">
			<div class="show-box">
				<div class="item-img">
					<?php if ( has_post_thumbnail() ) {
						the_post_thumbnail( $thumb_size );
					} ?>
				</div>
				<?php if ( $start_time_formatted ) : ?>
					<div class="item-date"><?php echo esc_html( $start_time_formatted ); ?></div>
				<?php endif; ?>
				<div class="item-content">
					<h3 class="item-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( get_the_title() ); ?></a></h3>
					<?php if ( $host_title ) : ?>
						<div class="host-name"><?php echo esc_html( $host_title ); ?></div>
					<?php endif; ?>
				</div>
			</div>
		</div>
			 <?php
			}
		} ?>
		<?php Helper::wp_reset_temp_query( $temp );?>
	</div>
</section>