<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;

$prefix      = FMWAVE_CORE_THEME;
$cpt         = FMWAVE_CORE_CPT;
$thumb_size  = "fmwave-size-team2";
$args = array(
	'post_type'      => "{$cpt}_team",
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);
if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$cpt}_team_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}
switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}
$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query );
?><?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;

$prefix      = FMWAVE_CORE_THEME;
$cpt         = FMWAVE_CORE_CPT;
$thumb_size  = "fmwave-size-team2";
$args = array(
	'post_type'      => "{$cpt}_team",
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);
if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$cpt}_team_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}
switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}
$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query );
?>
<style>
.team-default-layout.team-modern .team-box {
	background: #ffffff;
	border-radius: 14px;
	box-shadow: 0 8px 24px rgba(0,0,0,0.06);
	overflow: hidden;
	transition: transform 220ms ease, box-shadow 220ms ease;
	height: 100%;
	display: flex;
	flex-direction: column;
}

.team-default-layout.team-modern .team-box:hover {
	transform: translateY(-6px);
	box-shadow: 0 14px 36px rgba(0,0,0,0.12);
}

.team-default-layout.team-modern .item-img {
	position: relative;
	overflow: hidden;
}

.team-default-layout.team-modern .item-img img {
	width: 100%;
	display: block;
	transition: transform 400ms ease, filter 300ms ease;
	filter: saturate(92%) contrast(102%);
}

.team-default-layout.team-modern .team-box:hover .item-img img {
	transform: scale(1.05);
	filter: saturate(110%) contrast(104%);
}

.team-default-layout.team-modern .item-content {
	padding: 22px 22px 20px;
	text-align: center;
}

.team-default-layout.team-modern .item-title {
	margin: 0 0 6px;
	font-size: 20px;
	line-height: 1.35;
	font-weight: 700;
	word-break: break-word;
}

.team-default-layout.team-modern .item-title a {
	color: inherit;
	text-decoration: none;
	transition: color 180ms ease;
}

.team-default-layout.team-modern .item-title a:focus,
.team-default-layout.team-modern .item-title a:hover {
	color: var(--rt-primary, var(--e-global-color-primary, #ff3d00));
	outline: none;
}

.team-default-layout.team-modern .item-subtitle {
	color: rgba(0,0,0,0.6);
	font-size: 14px;
	font-weight: 600;
	margin-bottom: 10px;
}

.team-default-layout.team-modern .item-content p {
	margin: 0 0 12px;
	color: rgba(0,0,0,0.75);
	font-size: 15px;
	line-height: 1.7;
}

.team-default-layout.team-modern .item-time {
	display: inline-block;
	margin-top: 2px;
	padding: 6px 10px;
	border-radius: 999px;
	background: rgba(0,0,0,0.05);
	color: rgba(0,0,0,0.75);
	font-size: 12px;
	font-weight: 600;
}

.team-default-layout.team-modern .item-social {
	display: flex;
	justify-content: center;
	align-items: center;
	gap: 12px;
	margin-top: 14px;
}

.team-default-layout.team-modern .item-social a {
	width: 36px;
	height: 36px;
	border-radius: 50%;
	display: inline-flex;
	align-items: center;
	justify-content: center;
	background: #f3f5f7;
	color: #3b3f45;
	transition: background-color 180ms ease, color 180ms ease, transform 180ms ease;
}

.team-default-layout.team-modern .item-social a:hover,
.team-default-layout.team-modern .item-social a:focus {
	background: var(--rt-primary, var(--e-global-color-primary, #ff3d00));
	color: #ffffff;
	transform: translateY(-2px);
	outline: none;
}

.team-default-layout.team-modern .item-social i {
	font-size: 14px;
	line-height: 1;
}

@media (max-width: 991.98px) {
	.team-default-layout.team-modern .item-content { padding: 18px; }
	.team-default-layout.team-modern .item-title { font-size: 18px; }
}

@media (max-width: 575.98px) {
	.team-default-layout.team-modern .item-content { padding: 16px; }
	.team-default-layout.team-modern .item-title { font-size: 17px; }
	.team-default-layout.team-modern .item-social { gap: 10px; }
	.team-default-layout.team-modern .item-social a { width: 34px; height: 34px; }
}

/* Dark mode support */
@media (prefers-color-scheme: dark) {
	.team-default-layout.team-modern .team-box { background: #14161a; box-shadow: 0 8px 24px rgba(0,0,0,0.35); }
	.team-default-layout.team-modern .item-subtitle,
	.team-default-layout.team-modern .item-content p,
	.team-default-layout.team-modern .item-time { color: rgba(255,255,255,0.85); }
	.team-default-layout.team-modern .item-time { background: rgba(255,255,255,0.08); }
	.team-default-layout.team-modern .item-social a { background: #1e2127; color: #cfd3da; }
}
</style>
<div class="team-default-layout team-modern">
	<div class="row">
		<?php if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
		<?php
			$id            	= get_the_id();
			$show_name   	= get_post_meta( $id, "{$cpt}_show_name", true );
			$show_date   	= get_post_meta( $id, "{$cpt}_show_date", true );
			$socials       	= get_post_meta( $id, "{$cpt}_team_social", true );
			$social_fields 	= Helper::team_socials();
			$content = apply_filters( 'the_content', get_the_content() );
			$content 		= wp_trim_words( $content, $data['count'], '' );
			$content 		= "<p>$content</p>";
		?>
		<div class="<?php echo esc_attr( $col_class );?>">
			<div class="team-box">
				<?php if ( has_post_thumbnail() ){ ?>
					<div class="item-img"><?php the_post_thumbnail( $thumb_size ); ?></div>
				<?php } ?>
				<div class="item-content">
					<h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
					<?php if ( $data['show_display']  == 'yes' ) { ?>
					<div class="item-subtitle"><?php echo esc_html ($show_name); ?></div>
					<?php } ?>
					<?php if ( $data['content_display']  == 'yes' ) { ?>
						<?php echo wp_kses_post( $content );?>
					<?php } ?>
					<div class="item-time"><?php echo esc_html ($show_date); ?></div>
					<?php if ( !empty( $data['item_social'] ) ){ ?>
						<div class="item-social">
							<?php foreach ( $socials as $key => $social ) { ?>
								<?php if ( !empty( $social ) ){ ?>
									<a target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a>
								<?php } ?>
							<?php } ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php endwhile; ?>
	<?php endif; ?>
	<?php Helper::wp_reset_temp_query( $temp ); ?>
	</div>
</div>