<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 2.4 - Enhanced Responsiveness
 */
namespace radiustheme\Fmwave_Core;
extract($data);

/* ----------  Build slides  ---------- */
$banners = [];
foreach ($data['banner_list'] as $banner_list) {
    $banners[] = [
        'id'          => 'slider-' . time() . rand(1, 99),
        'banner_image'=> $banner_list['banner_image']['id'] ?? '',
        'banner_text' => $banner_list['banner_text'] ?? '',
        'button_text' => $banner_list['button_text'] ?? '',
        'button_url'  => $banner_list['button_url']['url'] ?? '',
        'show_title'  => $banner_list['show_title'] ?? '',
    ];
}

$slider_uid = 'rt-slider-' . uniqid();

/* ----------  Stream endpoint  ---------- */
$stream_url   = get_option('fmwave_stream_url') ?: 'http://162.244.80.52:8740/;stream.mp3';
$station_name = get_option('fmwave_station_name') ?: 'Radio One';
?>

<!-- Bootstrap Icons CDN -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<style>
:root{
  --rt-primary:#D71920;
  --rt-primary-dark:#b0141a;
  --rt-primary-light:#ff2830;
  --rt-secondary:#ffcf00;
  --rt-overlay:rgba(0,0,0,.65);
  --rt-shadow:0 12px 32px rgba(0,0,0,.18);
  --rt-radius:999px;
  --rt-ease:cubic-bezier(.4,0,.2,1);
  --rt-bounce:cubic-bezier(.68,-0.55,.265,1.55);
}

/* ----------  Slider with enhanced overlay  ---------- */
#<?php echo esc_attr($slider_uid); ?> {
  position: relative;
  overflow: hidden;
}

#<?php echo esc_attr($slider_uid); ?> .slides {
  position: relative;
}

#<?php echo esc_attr($slider_uid); ?> .slides::after {
  content: '';
  position: absolute;
  inset: 0;
  background: linear-gradient(
    to bottom,
    rgba(0,0,0,.3) 0%,
    rgba(0,0,0,.5) 50%,
    rgba(0,0,0,.75) 100%
  );
  pointer-events: none;
}

#<?php echo esc_attr($slider_uid); ?> .slides img{
  width:100%;
  height:clamp(380px,65vh,800px);
  object-fit:cover;
  filter:brightness(.85) contrast(1.1) saturate(1.1);
  transition: transform 8s var(--rt-ease);
  will-change:transform;
  transform:translateZ(0);
  backface-visibility:hidden;
}

#<?php echo esc_attr($slider_uid); ?> .slides img:hover {
  transform: scale(1.05);
}

/* ----------  Enhanced Typography with Better Mobile Scaling  ---------- */
#<?php echo esc_attr($slider_uid); ?> .slider-big-text{
  font-size:clamp(28px,5vw,64px);
  font-weight:900;
  line-height:1.15;
  color:#fff;
  text-shadow:0 4px 24px rgba(0,0,0,.6),
              0 2px 8px rgba(0,0,0,.4);
  margin-top:clamp(40px,8vw,80px);
  margin-bottom:clamp(20px,4vw,32px);
  letter-spacing:-0.02em;
  animation:fadeUp .9s var(--rt-ease) both;
  max-width:90%;
  padding-left:clamp(16px,3vw,24px);
  border-left:clamp(4px,1vw,6px) solid var(--rt-primary);
  position:relative;
  will-change:transform,opacity;
}

@keyframes fadeUp{
  from{opacity:0;transform:translateY(40px);}
  to  {opacity:1;transform:translateY(0);}
}

/* ----------  Container Responsive Padding  ---------- */
#<?php echo esc_attr($slider_uid); ?> .container-fluid {
  padding-left:clamp(16px,5vw,60px);
  padding-right:clamp(16px,5vw,60px);
}

/* ----------  Enhanced Button with Better Touch Targets - Bootstrap Icons  ---------- */
#<?php echo esc_attr($slider_uid); ?> .item-btn{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  gap:clamp(8px,2vw,12px);
  padding:clamp(14px,3vw,18px) clamp(28px,6vw,40px);
  background:linear-gradient(135deg, var(--rt-primary) 0%, var(--rt-primary-dark) 100%);
  color:#fff;
  border:none;
  border-radius:var(--rt-radius);
  box-shadow:0 8px 24px rgba(215,25,32,.3),
             0 4px 12px rgba(0,0,0,.2);
  font-weight:700;
  font-size:clamp(0.9rem,2.5vw,1.05rem);
  text-decoration:none;
  text-transform:uppercase;
  letter-spacing:0.5px;
  position: relative;
  overflow: hidden;
  transition:transform .3s var(--rt-ease),
             box-shadow .3s var(--rt-ease);
  min-height:48px;
  touch-action:manipulation;
  will-change:transform;
  transform:translateZ(0);
}

#<?php echo esc_attr($slider_uid); ?> .item-btn::before {
  content: '';
  position: absolute;
  inset: 0;
  background: linear-gradient(135deg, var(--rt-primary-light) 0%, var(--rt-primary) 100%);
  opacity: 0;
  transition: opacity .3s var(--rt-ease);
}

#<?php echo esc_attr($slider_uid); ?> .item-btn > * {
  position: relative;
  z-index: 1;
}

#<?php echo esc_attr($slider_uid); ?> .item-btn i {
  font-size: clamp(1.1rem, 2.5vw, 1.3rem);
}

@media (hover: hover) {
  #<?php echo esc_attr($slider_uid); ?> .item-btn:hover{
    transform:translateY(-6px);
    box-shadow:0 20px 48px rgba(215,25,32,.4),
               0 8px 16px rgba(0,0,0,.3);
  }
  
  #<?php echo esc_attr($slider_uid); ?> .item-btn:hover::before {
    opacity: 1;
  }
}

#<?php echo esc_attr($slider_uid); ?> .item-btn:active {
  transform: translateY(-2px);
}

/* ----------  Enhanced Radio Player with Better Mobile Layout  ---------- */
.rt-radio-player-v3{
  --disk:clamp(130px,35vw,180px);
  display:flex;
  flex-direction:column;
  align-items:center;
  margin-top:clamp(30px,6vw,50px);
  gap:clamp(12px,3vw,20px);
  padding:clamp(20px,4vw,32px);
  border-radius:clamp(16px,3vw,24px);
  box-shadow:0 12px 40px rgba(0,0,0,.3);
  max-width:min(320px,90vw);
  margin-left:auto;
  margin-right:auto;
  width:100%;
}

.rt-radio-player-v3 .disk-wrapper{
  position:relative;
  width:var(--disk);
  height:var(--disk);
  filter:drop-shadow(0 8px 24px rgba(0,0,0,.4));
  flex-shrink:0;
}

.rt-radio-player-v3 .disk{
  width:100%;
  height:100%;
  border-radius:50%;
  background:#11151b
    radial-gradient(circle at 30% 30%,#2a2f38 0%,#11151b 60%);
  box-shadow:inset 0 0 0 8px rgba(255,255,255,.05),
             inset 0 4px 8px rgba(0,0,0,.6);
  position:relative;
  transition:transform .6s linear;
  will-change:transform;
  transform:translateZ(0);
}

.rt-radio-player-v3 .disk::before {
  content:"";
  position:absolute;
  inset:0;
  border-radius:50%;
  background:conic-gradient(
    from 0deg,
    transparent 0deg,
    rgba(215,25,32,.2) 90deg,
    transparent 180deg,
    rgba(215,25,32,.2) 270deg,
    transparent 360deg
  );
  opacity:0;
  transition:opacity .3s var(--rt-ease);
}

.rt-radio-player-v3 .disk.spin::before {
  opacity:1;
}

.rt-radio-player-v3 .disk::after{
  content:"";
  position:absolute;
  inset:22%;
  border:3px solid rgba(255,255,255,.12);
  border-radius:50%;
  box-shadow:0 0 0 1px rgba(0,0,0,.3);
}

.rt-radio-player-v3 .disk.spin{
  animation:spin 3s linear infinite;
}

@keyframes spin{
  to{transform:rotate(360deg);}
}

/* ----------  Enhanced Play Button with Better Touch Target - Bootstrap Icons  ---------- */
.rt-radio-player-v3 .play-btn{
  position:absolute;
  inset:0;
  margin:auto;
  width:clamp(60px,18vw,72px);
  height:clamp(60px,18vw,72px);
  border-radius:50%;
  border:none;
  background:linear-gradient(135deg, var(--rt-primary) 0%, var(--rt-primary-dark) 100%);
  color:#fff;
  font-size:clamp(22px,5vw,28px);
  cursor:pointer;
  box-shadow:0 8px 28px rgba(215,25,32,.4),
             0 4px 12px rgba(0,0,0,.3);
  transition:transform .4s var(--rt-bounce),
             box-shadow .3s var(--rt-ease);
  display:flex;
  align-items:center;
  justify-content:center;
  touch-action:manipulation;
  -webkit-tap-highlight-color:transparent;
  will-change:transform;
  transform:translateZ(0);
}

.rt-radio-player-v3 .play-btn i {
  font-size: clamp(24px, 6vw, 30px);
}

.rt-radio-player-v3 .play-btn::before {
  content: '';
  position: absolute;
  inset: -4px;
  border-radius: 50%;
  border: 2px solid var(--rt-primary);
  opacity: 0;
  transform: scale(.9);
  transition: all .3s var(--rt-ease);
}

@media (hover: hover) {
  .rt-radio-player-v3 .play-btn:hover{
    transform:scale(1.15);
    box-shadow:0 12px 36px rgba(215,25,32,.5),
               0 6px 16px rgba(0,0,0,.4);
  }

  .rt-radio-player-v3 .play-btn:hover::before {
    opacity: 1;
    transform: scale(1.1);
  }
  
  #<?php echo esc_attr($slider_uid); ?> .slides img:hover {
    transform: scale(1.05);
  }
}

.rt-radio-player-v3 .play-btn:focus-visible{
  outline:3px solid var(--rt-secondary);
  outline-offset:4px;
  transform:scale(1.15);
}

.rt-radio-player-v3 .play-btn:active {
  transform: scale(1.05);
}

/* ----------  Enhanced Meta Info with Better Text Handling  ---------- */
.rt-radio-player-v3 .meta{
  color:#fff;
  font-size:clamp(0.95rem,2.5vw,1.1rem);
  font-weight:700;
  text-align:center;
  line-height:1.4;
  max-width:min(240px,80vw);
  white-space:nowrap;
  overflow:hidden;
  text-overflow:ellipsis;
  text-shadow:0 2px 8px rgba(0,0,0,.3);
}

.rt-radio-player-v3 .live-dot{
  display:inline-block;
  width:clamp(8px,2vw,10px);
  height:clamp(8px,2vw,10px);
  background:var(--rt-secondary);
  border-radius:50%;
  margin-right:8px;
  box-shadow:0 0 12px var(--rt-secondary);
  animation:pulse 1.4s infinite;
  flex-shrink:0;
}

@keyframes pulse{
  0%,100%{opacity:1;transform:scale(1);}
  50%    {opacity:.7;transform:scale(1.3);}
}

/* ----------  Enhanced Waveform with Better Scaling  ---------- */
.rt-wave{
  display:flex;
  align-items:center;
  justify-content:center;
  gap:clamp(3px,1vw,4px);
  height:clamp(24px,6vw,28px);
  margin-top:12px;
  padding:8px clamp(12px,3vw,16px);
  background:rgba(0,0,0,.25);
  border-radius:16px;
  min-width:clamp(140px,40vw,160px);
}

.rt-wave span{
  width:clamp(3px,0.8vw,4px);
  background:linear-gradient(to top, var(--rt-primary), var(--rt-primary-light));
  border-radius:2px;
  box-shadow:0 0 8px rgba(215,25,32,.4);
  animation:none;
  transition:all .3s var(--rt-ease);
}

.rt-wave.playing span{
  animation:wave 1.2s calc(var(--i)*.08s) infinite var(--rt-ease);
}

@keyframes wave{
  0%,100%{height:6px; opacity:.5;}
  50%    {height:100%; opacity:1;}
}

/* ----------  Show Title Enhancement  ---------- */
.show-details {
  margin-top:clamp(16px,3vw,24px);
  padding:clamp(12px,2.5vw,16px) clamp(16px,4vw,24px);
  background:rgba(255,255,255,.1);
  backdrop-filter:blur(8px);
  border-radius:12px;
  border:1px solid rgba(255,255,255,.15);
  display:inline-block;
  max-width:90%;
}

.show-title {
  color:#fff;
  font-size:clamp(0.9rem,2.2vw,1rem);
  font-weight:600;
  text-shadow:0 2px 8px rgba(0,0,0,.3);
  word-break:break-word;
}

/* ----------  Tablet Optimization (768px - 991px)  ---------- */
@media(min-width:768px) and (max-width:991px){
  #<?php echo esc_attr($slider_uid); ?> .slides img{
    height:clamp(400px,60vh,600px);
  }
  
  .rt-radio-player-v3{
    --disk:160px;
  }
  
  #<?php echo esc_attr($slider_uid); ?> .slider-big-text{
    font-size:clamp(32px,5.5vw,48px);
  }
}

/* ----------  Mobile Landscape Optimization  ---------- */
@media(max-height:500px) and (orientation:landscape){
  #<?php echo esc_attr($slider_uid); ?> .slides img{
    height:80vh;
  }
  
  .rt-radio-player-v3{
    --disk:110px;
    margin-top:20px;
    padding:16px;
    flex-direction:row;
    max-width:none;
    gap:20px;
  }
  
  .rt-radio-player-v3 .meta,
  .rt-wave{
    margin-top:0;
  }
  
  #<?php echo esc_attr($slider_uid); ?> .slider-big-text{
    margin-bottom:16px;
  }
  
  .show-details{
    margin-top:12px;
  }
}

/* ----------  Mobile Specific (< 576px)  ---------- */
@media(max-width:576px){
  #<?php echo esc_attr($slider_uid); ?> .slides img{
    height:clamp(300px,80vh,500px);
  }
  
  #<?php echo esc_attr($slider_uid); ?> .slider-big-text{
    font-size:clamp(24px,7vw,36px);
    margin-bottom:20px;
    line-height:1.2;
  }
  
  .rt-radio-player-v3{
    margin-top:24px;
  }
  
  #<?php echo esc_attr($slider_uid); ?> .item-btn i{
    font-size:clamp(1rem,2.5vw,1.2rem);
  }
}

/* ----------  Extra Small Devices (< 380px)  ---------- */
@media(max-width:380px){
  #<?php echo esc_attr($slider_uid); ?> .slider-big-text{
    font-size:clamp(20px,8vw,28px);
  }
  
  .rt-radio-player-v3{
    --disk:110px;
    padding:16px;
    gap:10px;
  }
  
  .rt-wave{
    min-width:120px;
  }
  
  .rt-wave span{
    width:3px;
  }
}

/* ----------  Fix for slider showing all images on load  ---------- */
#<?php echo esc_attr($slider_uid); ?> .slides {
  position: relative;
  height: clamp(380px,65vh,800px);
}

#<?php echo esc_attr($slider_uid); ?> .slides img {
  position: absolute !important;
  top: 0 !important;
  left: 0 !important;
  width: 100% !important;
  height: 100% !important;
  object-fit: cover;
  display: none !important;
}

#<?php echo esc_attr($slider_uid); ?> .slides img:first-child {
  display: block !important;
}

/* Nivo Slider active images */
#<?php echo esc_attr($slider_uid); ?> .slides img.nivo-main-image {
  display: block !important;
}

.nivoSlider {
  position: relative;
  width: 100%;
  height: 100%;
  overflow: hidden;
}

.nivoSlider img {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
}

/* ----------  Accessibility Improvements  ---------- */
@media (prefers-reduced-motion: reduce) {
  *,
  *::before,
  *::after {
    animation-duration: 0.01ms !important;
    animation-iteration-count: 1 !important;
    transition-duration: 0.01ms !important;
  }
  
  #<?php echo esc_attr($slider_uid); ?> .slides img{
    transition:none;
  }
  
  .rt-radio-player-v3 .disk.spin{
    animation:none;
  }
}

/* ----------  High Contrast Mode Support  ---------- */
@media (prefers-contrast: high) {
  #<?php echo esc_attr($slider_uid); ?> .item-btn{
    border:2px solid currentColor;
  }
  
  .rt-radio-player-v3 .play-btn{
    border:3px solid #fff;
  }
}

/* ----------  Print Styles  ---------- */
@media print {
  .rt-radio-player-v3,
  #<?php echo esc_attr($slider_uid); ?> .item-btn,
  .rt-wave {
    display: none !important;
  }
}
</style>

<div id="<?php echo esc_attr($slider_uid); ?>" class="slider-area slider-layout1" role="region" aria-label="Main Slider">
  <div class="bend niceties preview-1">
    <div id="ensign-nivoslider-3" class="slides">
      <?php foreach ($banners as $i => $banner) : 
        $attr = ['title'=>'#slider-direction-'.($i+1),'alt'=>esc_attr(wp_strip_all_tags($banner['banner_text'])),'decoding'=>'async','loading'=>$i===0?'eager':'lazy'];
        echo wp_get_attachment_image($banner['banner_image'],'full',false,$attr);
      endforeach; ?>
    </div>

    <?php foreach ($banners as $y => $banner) : ?>
    <div id="slider-direction-<?php echo esc_attr($y+1); ?>" class="t-cn slider-direction">
      <div class="slider-content s-tb slide-<?php echo esc_attr($y+1); ?>">
        <div class="text-left title-container s-tb-c">
          <div class="container-fluid">
            <h2 class="slider-big-text"><?php echo wp_kses($banner['banner_text'], ['span'=>[],'strong'=>[],'em'=>[],'br'=>[]]); ?></h2>

            <?php if (!empty($banner['button_url']) && !empty($banner['button_text'])) : ?>
            <div class="slider-btn-area">
              <a href="<?php echo esc_url($banner['button_url']); ?>" class="item-btn" aria-label="<?php echo esc_attr($banner['button_text']); ?>">
                <span><?php echo wp_kses($banner['button_text'], 'alltext_allow'); ?></span>
                <i class="bi bi-arrow-right-circle-fill"></i>
              </a>
            </div>
            <?php endif; ?>

            <!-- Radio Player v3 + Waveform -->
            <div class="rt-radio-player-v3" role="complementary" aria-label="Live radio player">
              <div class="disk-wrapper">
                <div class="disk" aria-hidden="true"></div>
                <button class="play-btn" aria-label="Play live stream" aria-pressed="false">
                  <i class="bi bi-play-fill"></i>
                </button>
              </div>
              <div class="meta">
                <span class="live-dot" aria-hidden="true"></span>
                <span class="station-name"><?php echo esc_html($station_name); ?> Live</span>
              </div>
              <div class="rt-wave" aria-hidden="true" role="presentation">
                <?php for($i=0;$i<12;$i++): ?>
                  <span style="--i:<?php echo $i; ?>"></span>
                <?php endfor; ?>
              </div>
            </div>

            <?php if (!empty($banner['show_title'])) : ?>
            <div class="show-details">
              <div class="show-title"><?php echo wp_kses($banner['show_title'], 'alltext_allow'); ?></div>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const streamUrl   = <?php echo wp_json_encode($stream_url); ?>;
  const stationName = <?php echo wp_json_encode($station_name); ?>;
  const audio       = new Audio(streamUrl);
  audio.crossOrigin = 'anonymous';
  audio.preload     = 'none';

  const players = document.querySelectorAll('.rt-radio-player-v3');
  
  // Cache DOM queries for better performance
  const playBtns = [];
  const disks = [];
  const waves = [];
  
  players.forEach(p => {
    playBtns.push(p.querySelector('.play-btn'));
    disks.push(p.querySelector('.disk'));
    waves.push(p.querySelector('.rt-wave'));
  });

  function syncAll(playing){
    // Use cached elements and requestAnimationFrame for smooth updates
    requestAnimationFrame(() => {
      playBtns.forEach((btn, i) => {
        if(btn) {
          btn.setAttribute('aria-pressed', playing);
          btn.innerHTML = playing ? '<i class="bi bi-pause-fill"></i>' : '<i class="bi bi-play-fill"></i>';
        }
        disks[i]?.classList.toggle('spin', playing);
        waves[i]?.classList.toggle('playing', playing);
      });
    });
  }

  // Debounced click handler for better performance
  let clickTimeout;
  document.querySelector('#<?php echo esc_js($slider_uid); ?>').addEventListener('click', e => {
    if(!e.target.closest('.play-btn')) return;
    
    if(clickTimeout) return; // Prevent multiple rapid clicks
    
    const btn = e.target.closest('.play-btn');
    
    // Add click animation with GPU acceleration
    requestAnimationFrame(() => {
      btn.style.transform = 'scale(0.95) translateZ(0)';
    });
    
    clickTimeout = setTimeout(() => {
      requestAnimationFrame(() => {
        btn.style.transform = '';
      });
      clickTimeout = null;
    }, 150);

    if(audio.paused){
      audio.play().then(()=>{
        syncAll(true);
      }).catch(err=>{
        console.error('Stream play failed:', err);
        syncAll(false);
        const msg = 'Unable to play stream. Please check your connection.';
        if(window.innerWidth > 768){
          alert(msg);
        } else {
          console.warn(msg);
        }
      });
    }else{
      audio.pause();
      syncAll(false);
    }
  }, { passive: true });

  // Optimized audio event listeners
  audio.addEventListener('ended', ()=>syncAll(false), { passive: true });
  audio.addEventListener('pause', ()=>syncAll(false), { passive: true });
  audio.addEventListener('play',  ()=>syncAll(true), { passive: true });
  audio.addEventListener('error', ()=>{
    syncAll(false);
    console.error('Audio stream error');
  }, { passive: true });

  // Throttled resize handler for better performance
  let resizeTimer;
  window.addEventListener('resize', () => {
    clearTimeout(resizeTimer);
    resizeTimer = setTimeout(() => {
      // Recalculate any layout-dependent values if needed
    }, 250);
  }, { passive: true });
  
  // Cleanup on page unload
  window.addEventListener('beforeunload', () => {
    if(!audio.paused) {
      audio.pause();
      audio.src = '';
    }
  });
});
</script>