<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'image' );

?>

<section class="default-show current-show">
    <div class="content-box">
        <div class="media">
            <div class="item-img">
			<?php if(!empty($getimg)) { ?>
			    <?php echo wp_kses_post($getimg);?>
			<?php } ?>
            </div>
            <div class="media-body">
                <?php if (!empty( $data['button_text'] ) )  { ?>
                <div class="show-status"><?php echo esc_html($data['button_text']); ?></div>
                <?php } ?>
                <?php if (!empty( $data['rj_title']))  { ?>
                <div class="host-name"><?php echo esc_html($data['rj_title']); ?></div>
                <?php } ?>
                <?php if (!empty( $data['show_title']))  { ?>
                <h3 class="item-title"><?php echo esc_html($data['show_title']); ?></h3>
                <?php } ?>
                <?php if (!empty($data['show_description']))  { ?>
                <p><?php echo esc_html( $data['show_description'] ); ?></p>
                <?php } ?>
            </div>
            <div class="show-time">
                <?php if (!empty( $data['show_time_text']))  { ?>
                <h4 class="item-title"><?php echo esc_html($data['show_time_text']); ?></h4>
                <?php } ?>
                <?php if (!empty( $data['show_time']))  { ?>
                <div class="item-time"><?php echo esc_html($data['show_time']); ?></div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>