<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
use Elementor\Group_Control_Image_Size;

extract($data);
?>
<?php

$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'image' );

$weeknames = array(
    'mon' => esc_html__('Monday', 'fmwave'),
    'tue' => esc_html__('Tuesday', 'fmwave'),
    'wed' => esc_html__('Wednesday', 'fmwave'),
    'thu' => esc_html__('Thursday', 'fmwave'),
    'fri' => esc_html__('Friday', 'fmwave'),
    'sat' => esc_html__('Saturday', 'fmwave'),
    'sun' => esc_html__('Sunday', 'fmwave'),
);
$weeknames = apply_filters('fmwave_weeknames', $weeknames);

?>
<section class="default-show current-show-3">
    <?php
    //next show start
    $today = Helper::get_today();

    $today_weekday = strtolower(date('D'));
    $today_time = date('g:i a');
    $time_now = esc_html(strtotime((str_replace(' ', '', ($today_time)))));

    $prefix = FMWAVE_CORE_CPT;
    $args = array(
        'posts_per_page' => 1,
        'post_type' => "{$prefix}_show",
        'post__in' => [ $data['fm_track_ids'] ],
        'fields' => 'ids'
    );

    $query = new WP_Query($args); 

    $rawIds = [];

    if (!empty($query->posts)) {
        foreach ($query->posts as $id) {
            $metas = get_post_meta($id, "{$prefix}_show_schedule", true);
            $day_name = wp_list_pluck($metas, 'week');
            $get_audio_track = get_post_meta( $data['fm_music_id'], "{$prefix}_track" , true );

            //next show start
            $current_day = false;
            $next_day = $next_start_time = $next_end_time = $short_desc = $next_day_name = '';
            $btn_text = '';

            if ($metas) {
                $i = 1;
                $has_next_day = true;
                $total_schedule = count($metas);
                foreach ($metas as $schedule) {
                    if ($current_day) {
                        $next_day = $schedule['week'];
                        $next_start_time = $schedule['start_time'];
                        $next_end_time = $schedule['end_time'];
                        $short_desc = $schedule['show_details'];
                        $btn_text = esc_html__('Next Show', 'fmwave-core');
                        break;
                    }

                    if ($schedule['week'] == $today) {
                        if ( Helper::check_in_range($schedule['start_time'], $schedule['end_time'], current_time('H:i')) ) {
                        // if (strtotime($schedule['start_time']) > strtotime(current_time('H:i'))) {

                            $next_day = $schedule['week'];
                            $next_start_time = $schedule['start_time'];
                            $next_end_time = $schedule['end_time'];
                            $short_desc = $schedule['show_details'];
                            $btn_text = esc_html__('Current Show', 'fmwave-core');
                            break;
                        } else {
                            $current_day = true;
                            if ($total_schedule == $i) {
                                $has_next_day = false;
                            }
                        }
                    } else {
                        if ( !in_array($today, $day_name) ) {
                            $has_next_day = false;
                        } 
                    } 
                    $i++;
                }
            }

            
            if ( !$has_next_day ) {  
                $next_day_name = $weeknames[$metas[0]['week']];
                $next_day = $metas[0]['week'];
                $next_start_time = $metas[0]['start_time'];
                $next_end_time = $metas[0]['end_time'];
                $short_desc = $metas[0]['show_details'];
            } else {  
                if (isset($weeknames[$next_day])) {
                    $next_day_name = $weeknames[$next_day];
                }
            }
            //next show end

            $start_time = !empty($next_start_time) ? strtotime($next_start_time) : false;
            $start_time = $start_time ? date(get_option('time_format'), $start_time) : '';

            $end_time = !empty($next_end_time) ? strtotime($next_end_time) : false;
            $end_time = $end_time ? date(get_option('time_format'), $end_time) : '';

            $rawIds[$id] = [
                'day' => array_search($next_day, array_keys($weeknames)),
                'time' => $next_start_time,
                'end_time' => $next_end_time,
                'short_desc' => $short_desc,
            ];
        }
    }

    $rawIds = Helper::array_sort($rawIds, 'day');
    $timeSortIds = [];
    foreach($rawIds as $id => $postData){
        $timeSortIds[$postData['day']][$id]=$postData;
    }
    $postIds = [];
    foreach($timeSortIds as $sortedIds){
        if(count($sortedIds) > 1){
            $postIds = $postIds + Helper::array_sort($sortedIds, 'time');
        }else{
            $postIds = $postIds + $sortedIds;
        }
    }

    ?>
    <?php if (!empty($postIds)) {
        foreach ($postIds as $id => $timeShedule) {
            global $post;
            $post = get_post($id);
            setup_postdata($post);
            $start_time = !empty($timeShedule['time']) ? strtotime($timeShedule['time']) : false;
            $start_time = $start_time ? date(get_option('time_format'), $start_time) : '';

            $end_time = !empty($timeShedule['end_time']) ? strtotime($timeShedule['end_time']) : false;
            $end_time = $end_time ? date(get_option('time_format'), $end_time) : '';
            $next_day_name = $weeknames[array_keys($weeknames)[$timeShedule['day']]];

    ?>
            <div class="content-box">
                <div class="item-img">
                    <?php if(!empty($getimg)) { ?>
                        <?php echo wp_kses_post($getimg);?>
                    <?php } ?>
                    <div class="item-content">
                        <h3 class="host-name"><span class="item-time"><?php echo esc_html($start_time); ?>-<?php echo esc_html($end_time); ?></span><?php echo get_the_title($metas[0]['team']); ?></h3>
                        <h4 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                    </div>
                </div>
            </div>
            <?php
            wp_reset_postdata();
        }
    } ?>
</section>