<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
	
namespace radiustheme\Fmwave_Core;
use radiustheme\fmwave\RDTheme;
use radiustheme\Fmwave\Helper;
// css classes
$schedule_class  = '';

$thumb_size = 'fmwave-show-isotope';

// week names array
$weeknames = array(
    'mon' => esc_html__( 'Monday', 'fmwave-core' ),
    'tue' => esc_html__( 'Tuesday', 'fmwave-core' ),
    'wed' => esc_html__( 'Wednesday', 'fmwave-core' ),
    'thu' => esc_html__( 'Thursday', 'fmwave-core' ),
    'fri' => esc_html__( 'Friday', 'fmwave-core' ),
    'sat' => esc_html__( 'Saturday', 'fmwave-core' ),
    'sun' => esc_html__( 'Sunday', 'fmwave-core' ),
);
$weeknames = apply_filters( 'fmwave_weeknames', $weeknames );
$prefix = FMWAVE_CORE_CPT;
// class post types array
$args = array(
    'posts_per_page'   => $data['post_per_page'],
    'post_type'        => "{$prefix}_show",
    'suppress_filters' => false
);

if ( !empty( $data['category'] ) ) {
    $args['tax_query'] = array(
        array(
	        'taxonomy' => "{$prefix}_show_category",
            'field' => 'term_id',
            'terms' => $data['category'],
        )
    );
}

$shows = get_posts( $args );

$uniqid = (int) rand();

$week_ids = array(
    'mon' => 'mon-'. $uniqid,
    'tue' => 'tue-'. $uniqid,
    'wed' => 'wed-'. $uniqid,
    'thu' => 'thu-'. $uniqid,
    'fri' => 'fri-'. $uniqid,
    'sat' => 'sat-'. $uniqid,
    'sun' => 'sun-'. $uniqid,
);

$schedule = array(
    'mon' => array(),
    'tue' => array(),
    'wed' => array(),
    'thu' => array(),
    'fri' => array(),
    'sat' => array(),
    'sun' => array(),
);

foreach ( $shows as $show ) {
	$show_name  = $show->post_title;
    $metas = get_post_meta( $show->ID, "{$prefix}_show_schedule", true );
    $schedule_date = get_post_meta( $show->ID, "{$prefix}_schedule_date", true );
    if ( has_post_thumbnail( $show->ID ) ){
        $post_thumbnail = get_the_post_thumbnail( $show->ID, $thumb_size );
    }
    $metas = ( $metas != '' ) ? $metas : array();
	
	
	$id            	= get_the_id();
	$socials       	= get_post_meta( $show->ID, "{$prefix}_show_social", true );
    $social_fields 	= Helper::team_socials();
    
    foreach ( $metas as $meta ) {
        //echo '<pre>' . var_export($meta['schedule_date'], true) . '</pre>';
        $start_time = !empty( $meta['start_time'] ) ? strtotime( $meta['start_time'] ) : false;
        $end_time   = !empty( $meta['end_time'] ) ? strtotime( $meta['end_time'] ) : false;
        $schedule_date   = !empty( $meta['schedule_date'] ) ? $meta['schedule_date'] : '';

        if ( RDTheme::$options['class_time_format'] == '24' ) {
            $start_time = $start_time ? date( "H:i", $start_time ) : '';
            $end_time   = $end_time ? date( "H:i", $end_time ) : '';
        }
        else {
            $start_time = $start_time ? date( get_option('time_format'), $start_time ) : '';
            $end_time   = $end_time ? date( get_option('time_format'), $end_time ) : '';
        }

        $schedule[$meta['week']][] = array(
            'show'        => $show_name,
            'team'        => !empty( $meta['team'] ) ? get_the_title( $meta['team'] ) : '',
            'start_time'  => $start_time,
            'end_time'    => $end_time,
            'schedule_date'  => $schedule_date,
            'week'        => $meta['week'],
            'socials'     => $socials,
            'pid'         => $show->ID,
        );
    }
}

// remove empty fields
foreach ( $schedule as $key => $value ) {
    if ( !$value ) {
        unset( $weeknames[$key] );
        unset( $week_ids[$key] );
    }
}

// sort by time
foreach ( $schedule as $key => $value ) {
    usort( $schedule[$key], array( $this, 'sort_by_time' ) );
}
?>
<div class="schedule-tab-default show-schedule-tab-3" id="show">
    <ul class="nav nav-tabs">
        <?php
        $count = 0;
        foreach ( $weeknames as $weekid => $weekname ){
            $id = $week_ids[$weekid];
            $count++;
			
			$timestamp = strtotime(date("Y-m-d"));
			$day = strtolower(date('D', $timestamp));
			if( $day == $weekid ) {
				$active_class = 'active';
			} else {
				$active_class = '';
			}
        ?>
            <li class="nav-item">
                <a class="nav-link <?php echo esc_attr( $active_class );?>" data-toggle="tab" href="#<?php echo esc_attr( $id );?>"><?php echo esc_html( $weekname );?></a>
            </li>
        <?php } ?>
    </ul>
    <div class="tab-content">
        <?php
            $count = 0;
            foreach ( $week_ids as $key => $id ) { ?>
            <?php
			$timestamp = strtotime(date("Y-m-d"));
			$day = strtolower(date('D', $timestamp));
			if( $day == $key ) {
				$active_class = 'active';
			} else {
				$active_class = '';
			}			
            $count++;
			
        ?>
            <div class="tab-pane fade show <?php echo esc_attr( $active_class );?>" id="<?php echo esc_attr( $id );?>" role="tabpanel">
            	<div class="row">
				<?php foreach ( $schedule[$key] as $value ) { ?>
				<?php					
				$time = $value['start_time'];
				if ( !empty( $value['end_time'] ) ) {
					$time .=  " - {$value['end_time']}";
				}
				$currentTime = current_time('h:i a');
				$current_show = false;
				if((strtotime($currentTime) >= strtotime($value['start_time'])) && (strtotime($currentTime) <= strtotime($value['end_time'])) ) {
				   $current_show = true;
				}
				
				?>
				<div class="col-lg-4 col-md-6">
					<div class="show-box">
						<div class="item-img">
							<?php echo get_the_post_thumbnail( $value['pid'], $thumb_size );  ?>
						</div>
                         <?php 
                            $current_day = strtolower( date('D') );
                        ?>
						<div class="item-content">
							<?php if ( $current_show && ( $current_day === $value['week'] ) ) { ?>
								<div class="show-status"><?php esc_html_e ( 'Current Show' , 'fmwave-core' ); ?></div>
							<?php } ?>
							<div class="show-time">
								<div class="item-hour"><?php echo esc_html( $time );?></div>								
							</div>
							<h3 class="item-title"><a href="<?php echo get_the_permalink( $value['pid'] ); ?>"><?php echo esc_html( $value['show'] );?></a></h3>
							<div class="item-subtitle"><?php echo esc_html( $value['team'] );?></div>
						</div>						
					</div>
				</div>
				<?php } ?>
				</div>
            </div>
        <?php } ?>
    </div>
</div>