<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;

$thumb_size = 'fmwave-show-isotope';

?>
<section class="shows-list">
    <div class="show-box today-schedule">
		<div class="item-heading">
			<?php if ( !empty( $data['schedule_addon_title'] ) ) { ?>
			<h3 class="item-title"><?php echo esc_html( $data['schedule_addon_title'] ); ?></h3>
			<?php } ?>
			<?php if ( !empty( $data['schedule_addon_url'] ) ) { ?>
				<a target="_blank" href="<?php echo esc_url( $data['schedule_addon_url'] ); ?>" class="view-all-btn"><?php esc_html_e( 'View All' , 'fmwave-core' ); ?></a>
			<?php } ?>
		</div>
        <ul class="show-list">
			<?php
			$today_weekday = strtolower(date('D'));
			$today_time = date('g:i a');
			$time_now = esc_html (strtotime((str_replace( ' ', '', ($today_time)))));

			$prefix = FMWAVE_CORE_CPT;
			$args = array(
				'posts_per_page'   => $data['post_per_page'],
				'post_type' => "{$prefix}_show",
			);

			if ( !empty( $data['category'] ) ) {
			    $args['tax_query'] = array(
			        array(
				        'taxonomy' => "{$prefix}_show_category",
			            'field' => 'term_id',
			            'terms' => $data['category'],
			        )
			    );
			}

			$query = new WP_Query( $args );

			$temp = Helper::wp_set_temp_query( $query );
			?>
			<?php if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();

			$metas = get_post_meta( get_the_ID(), "{$prefix}_show_schedule", true );
			$day_name = wp_list_pluck( $metas, 'week' );
			$pointer = array_search( $today_weekday , $day_name );

			$start_time = !empty( $metas[0]['start_time'] ) ? strtotime( $metas[0]['start_time'] ) : false;
			$start_time = $start_time ? date( get_option('time_format'), $start_time ) : '';
			?>

            <li>
                <div class="show-time"><i class="far fa-clock"></i><?php echo esc_html( $start_time ); ?></div>
                <div class="media">
                    <div class="item-img">
						<?php the_post_thumbnail( array( 60,60 ) ); ?>
                    </div>
                    <div class="media-body">
                        <h4 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <div class="host-name"><?php echo esc_html( get_the_title( $metas[0]['team'] ) ); ?></div>
                    </div>
                </div>
                <div class="notify-show">
                    <a href="<?php the_permalink(); ?>">
                        <i class="far fa-bell"></i>
                    </a>
                </div>
            </li>

				<?php
			}
			} ?>
			<?php Helper::wp_reset_temp_query( $temp );?>

        </ul>
    </div>
</section>
