<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use \WP_Query;
use radiustheme\fmwave\RDTheme;
use radiustheme\fmwave\Helper;
$thumb_size = 'fmwave-v3-b';
extract($data);
$args = array(
	'posts_per_page' => $data['number'],
	'category_name'  => !empty($data['cat']) && is_array($data['cat']) ? implode(',', $data['cat']) : '',
	'orderby'        => $data['orderby'],
);
switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$slider_nav_class = $data['slider_nav'] == 'yes' ? 'slider-nav-enabled' : '';
$slider_dot_class = $data['slider_dots'] == 'yes' ? ' slider-dot-enabled' : '';
$temp = Helper::wp_set_temp_query( $query );
?>
<div class="blog-default blog-grid-layout blog-grid-layout-3 owl-wrap rt-owl-nav-1 post-slider-<?php echo esc_attr( $data['style'] );?> <?php echo esc_attr( $slider_nav_class ); ?><?php echo esc_attr( $slider_dot_class ); ?>">
	<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $data['owl_data'] );?>">
		<?php if ( $query->have_posts() ) :?>
			<?php while ( $query->have_posts() ) : $query->the_post();?>
				<?php
				$post_title = wp_trim_words( get_the_title(), $data['title_count'] , ' ' );
				$content = Helper::get_current_post_content();
				$content = wp_trim_words( $content,  $data['word_count'] );
				$content = "<p>$content</p>";
				$post_date = get_the_date( 'j M Y' );
				?>	
				<div class="blog-box">
                    <?php if ( has_post_thumbnail() ) { ?>
                    <div class="item-img">
                        <a href="<?php the_permalink();?>">
							<?php the_post_thumbnail( $thumb_size ); ?>
                        </a>
                    </div>
                    <?php } ?>
                    <div class="item-content">
                        <h3 class="item-title"><a href="<?php the_permalink();?>"><?php echo esc_html( $post_title ); ?></a></h3>
                        <?php if ( $data['content_display'] == 'yes' ) { ?>
						<div class="blog-text"><?php echo wp_kses_post( $content );?></div>
						<?php } ?>
						<?php if ( $data['show_date'] == 'yes' || $data['show_author'] == 'yes' || $data['show_category'] == 'yes') { ?>
						<ul class="post-meta">
							<?php if ( $data['show_date'] == 'yes' ) { ?>
                            <li><i class="far fa-calendar"></i><?php echo esc_html( $post_date ); ?></li>
							<?php } if ( $data['show_author'] == 'yes' ) { ?>
							<li><i class="far fa-user"></i><?php esc_html_e( 'by' , 'fmwave-core' ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo esc_attr( get_the_author() ); ?>"><?php the_author(); ?></a></li>
							<?php } if ( $data['show_category'] == 'yes' ) { ?>
							<li class="blog-category"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
							<?php } ?>
                        </ul>
						<?php } ?>
                    </div>
                </div>
				<?php endwhile;?>
				<?php endif;?>
				<?php Helper::wp_reset_temp_query( $temp );?>
			</div>
		</div>