<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use \WP_Query;

$thumb_size     = "fmwave-v3-b";
$prefix = FMWAVE_CORE_CPT;

if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
    $paged = get_query_var('page');
}
else {
    $paged = 1;
}

$args = array(
    'post_type'         => "{$prefix}_podcast",
    'posts_per_page'    => $data['number'],
    'order'             => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
    'paged'          => $paged, 
);

if ( !empty( $data['cat'] ) ) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => "{$prefix}_podcast_category",
            'field' => 'term_id',
            'terms' => $data['cat'],
        )
    );
}

$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query ); ?>

<div class="video-story">
    <div class="row justify-content-center">
        <?php
        if ($query->have_posts()) {
            while ( $query->have_posts() ) { $query->the_post();
                $title = wp_trim_words(get_the_title(), $data['title_count'], '');
                ?>
                <div class="<?php echo esc_attr( $col_class ); ?>">
                    <div class="podcast-box">
                        <div class="item-img">
                            <a href="<?php the_permalink();?>"><?php the_post_thumbnail( $thumb_size ); ?></a>
                            <div class="video-icon">
                                <a class="play-btn " href="<?php the_permalink();?>">
                                    <i class="fa fa-volume-up"></i>
                                </a>
                            </div>
                        </div>
                        <div class="item-content">
                            <h3 class="item-title"><a href="<?php the_permalink();?>"><?php echo wp_kses_post( $title ); ?></a></h3>
                        </div>
                    </div>
                </div>
            <?php }
            
        } else { ?>
            <div class="text-center"><?php esc_attr_e('No Podcast Found' , 'fmwave-core'); ?></div>

        <?php } ?>
    </div>
    <?php if( $data['pod_pagination'] == 'yes' ) { ?>
        <?php Helper::pagination(); ?>
    <?php } ?>
    <?php Helper::wp_reset_temp_query( $temp );?>
</div>