<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
}
else {
	$title = $data['title'];
}

if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'info_image_size' , 'info_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'info_image_size', 'info_image' );
}
?>

<div class="service-box-layout2 service-box-layout2-img">
      <div class="media">
          <div class="item-icon">
					 <?php echo wp_kses_post($getimg);?>	
          </div>
          <div class="media-body">
          	 <<?php echo esc_html( $data['title_tag'] );?> class="item-title"> <?php echo wp_kses_post( $title );?> </<?php echo esc_html( $data['title_tag'] );?>>
          	 
				<?php  if ($data['title_style'] == "yes")  { ?>
					<div class="title-style"></div>				
				<?php } ?>	
				<?php  if ($data['content']) { ?>
					<p class="item-content"><?php echo wp_kses_post( $data['content'] );?></p>
				<?php } ?>             
          </div>
     </div>  
</div>


