<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use \WP_Query;
use radiustheme\Fmwave\Helper;
$prefix      = FMWAVE_CORE_THEME;
$cpt         = FMWAVE_CORE_CPT;
$thumb_size  = "fmwave-event-grid";

$args = array(
	'post_type'  => "{$cpt}_gallery",
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => "{$cpt}_music_category",
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
		$args['order'] = 'ASC';
		break;
}
   
$query = new WP_Query( $args );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
$temp = Helper::wp_set_temp_query( $query );
?>
<section class="gallery-inner-page">
    <?php $i = 100; $j = 1;
        if ( $query->have_posts() ) {
            echo '<div class="row">';
            while ( $query->have_posts() ) { $query->the_post();
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
        ?>
            <div class="<?php echo esc_attr( $col_class ); ?>">
                <div class="gallery-box <?php echo esc_attr( $data['animation_display'] ); ?> left-img<?php echo esc_attr( $j );?>" data-sal="slide-up" data-sal-delay="<?php echo esc_attr( $i )?>"> 
					<?php the_post_thumbnail( $thumb_size ); ?>
                    <div class="gallery-content">
                        <div class="gallery-content-inner">
                            <a href="<?php echo esc_url( $featured_img_url ); ?>" data-elementor-open-lightbox="yes"
                            data-elementor-lightbox-slideshow="1" data-elementor-lightbox-title="<?php echo the_title_attribute(); ?>"><i class="fas fa-search"></i></a>
                            <h3 class="item-title"><?php the_title(); ?></h3>
                        </div>
                    </div>                    
                </div>
            </div>
            
        <?php $i = $i + 100; $j++; } ?>
    <?php } ?>
    </div>
    <?php Helper::pagination();?>
    <?php Helper::wp_reset_temp_query( $temp );?>
    
</section>