<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$prefix = FMWAVE_CORE_CPT;
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']}";
?>
<div class="event-list" id="event">
    <div class="event-box" data-bg-image="<?php echo esc_url( $data['event_back_image']['url'] ); ?>">
        <div class="row no-gutters">
		<?php
			$args = array(
				'post_type'  => "{$prefix}_event",
				'posts_per_page' => $data['post_per_page'],
				'orderby' => 'menu_order',
			);

			if ( !empty( $data['event_cat'] ) ) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => "{$prefix}_event_category",
						'field' => 'term_id',
						'terms' => $data['event_cat'],
					)
				);
			}

			if ( !empty( $data['event_ids'] ) ) {
				$args['post__in'] = array( $data['event_ids'] );
			}

			$query = new WP_Query( $args );
			$temp = Helper::wp_set_temp_query( $query );
			$i = 1;

			if ($query->have_posts()) {
			while ( $query->have_posts() ) { $query->the_post();

			$get_length = get_post_meta( get_the_ID(), "{$prefix}_video_length" , true );

            $num_padded = sprintf("%02d", $i);
			?>
                <div class="<?php echo esc_attr( $col_class );?>">
                    <div class="event-content">
                        <div class="item-content">
                            <div class="sl-number"><?php echo esc_html( $num_padded ); ?></div>
                            <h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
							<?php if ( !empty( $data['button_text'] ) ) { ?>
                            <a href="<?php the_permalink(); ?>" class="item-btn"><?php echo esc_html( $data['button_text'] );?></a>
							<?php } ?>
                        </div>
                    </div>
                </div>
			<?php $i++; }
			} else { ?>
                <div class="text-center"><?php esc_attr_e('No Event Found' , 'fmwave-core'); ?></div>
			<?php } ?>
			<?php Helper::wp_reset_temp_query( $temp );?>

        </div>
    </div>
</div>