<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Group_Control_Image_Size;
use \WP_Query;

$prefix = FMWAVE_CORE_CPT;
 ?>
<div class="track-list-5">
    <ol>
        <?php
        $args = array(
            'post_type'  => "{$prefix}_music",
            'posts_per_page' => $data['post_per_page'],
            'orderby'        => $data['orderby'],
        );

        if ( !empty( $data['category'] ) ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => "{$prefix}_music_category",
                    'field' => 'term_id',
                    'terms' => $data['category'],
                )
            );
        }
        switch ( $data['orderby'] ) {
            case 'title':
            case 'menu_order':
            case 'date':
            $args['order'] = 'ASC';
            break;
        }

        if ( !empty( $data['fm_track_ids'] ) ) {
            $args['post__in'] = array( $data['fm_track_ids'] );
        }

        $query = new WP_Query( $args );
        $temp = Helper::wp_set_temp_query( $query );

        if ($query->have_posts()) {
            while ( $query->have_posts() ) { $query->the_post();
                $get_view = get_post_meta( get_the_ID(), 'video_view' , true );
                $get_audio_length = get_post_meta( get_the_ID(), "{$prefix}_track_length" , true );
                $get_audio_track = get_post_meta( get_the_ID(), "{$prefix}_track" , true );
                $get_artist = get_post_meta( get_the_ID(), "{$prefix}_artist" , true );
                $get_release_day = get_post_meta( get_the_ID(), "{$prefix}_release_day" , true );

                $get_produce = get_post_meta( get_the_ID(), "{$prefix}_produce" , true );
        ?>
            <li>                
                <div class="song-info">
					<div class="rt-music-play rt-music-player-wrap">
						<audio class="fmwave-audio-plybtn" style="display: none">
							<source src="<?php echo wp_get_attachment_url( $get_audio_track ); ?>" type="audio/mp3">
						</audio>
					</div>
                </div>
				<h3 class="song-name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> <span><?php echo esc_html( $get_artist ); ?></span></h3>
            </li>
        <?php }
        } else { ?>
            <div class="text-center"><?php esc_attr_e('No Audio/Track Found' , 'fmwave-core'); ?></div>
        <?php } ?>
        <?php Helper::wp_reset_temp_query( $temp );?>
    </ol>
</div>