<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Plugin;
use radiustheme\fmwave\Helper;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Custom_Widget_Init {
	public $version;
	public function __construct() {
		$this->version = "1.0";
			add_action( 'elementor/widgets/register', array( $this, 'init' ) );
			add_action( 'elementor/elements/categories_registered', array( $this, 'widget_categoty' ) );
			
			add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'after_enqueue_styles_elementor_editor' ), 10, 1 );
			add_filter( 'elementor/utils/get_placeholder_image_src',  array( $this, 'set_placeholder_image'));
			add_filter( 'elementor/icons_manager/additional_tabs',  [$this, 'fmwave_additional_tabs'], 10, 1 );
			add_action( 'elementor/editor/after_enqueue_styles',    array( $this, 'editor_style' ) );
	}

	public function editor_style() {
		$img = plugins_url( 'icon.png', __FILE__ );
		wp_add_inline_style( 'elementor-editor', '.elementor-element .icon .rdtheme-el-custom{content: url('.$img.');width: 28px;}' );
		wp_add_inline_style( 'elementor-editor', '.select2-container--default .select2-selection--single {min-width: 126px !important; min-height: 30px !important;}' );
	}

	// Placeholder image replacement
	public function set_placeholder_image() {
		return FMWAVE_CORE_ASSETS . 'imgs/placeholder.png';
	}

	public function init() {
		require_once __DIR__ . '/base.php';
		// Widgets -- filename=>classname
		$widgets1 = array(			
			'title'           			=> 'Title',
			'button'         			=> 'Button',
			'paragraph-title'       	=> 'Paragraph_Title',
			'text-with-title' 			=> 'Text_With_Title', // Fancy title - set wp_kses for content
			'info-box'        			=> 'Info_Box',
			'icon-box'        			=> 'Icon_Box',
			'icon-list'             	=> 'Icon_List',
			'counter'        			=> 'Counter',
			'cta'             			=> 'CTA',
			'blog-post' 	  			=> 'Blog_post',
			'post-slider' 	  			=> 'Post_Slider',
			'logo-slider'     			=> 'Logo_Slider',
			'team-members'    			=> 'Team_Members',
			'testimonial'    			=> 'RT_Testimonial',
			'contact'         			=> 'Contact',
			'track'         			=> 'RT_Track',
			'gallery'         			=> 'RT_Gallery',
			'pricing-table'         	=> 'Pricing_Table',
			'schedule'         			=> 'Schedule',
			'show-now'         			=> 'Show_Now',
			'tv-movie'         			=> 'TV_Movie',
			'tv-hero-slider'         	=> 'TV_Hero_Slider',
			'slider'         			=> 'Slider',
			'upcoming-show'    			=> 'Upcoming_Show',
			'countdown'    			    => 'Countdown',
			'video'			 			=> 'RT_Video',
			'chart'			 			=> 'RT_Chart',
			'event'			 			=> 'RT_Event',
			'podcast'			 		=> 'RT_Podcast',
			'shape_animation' 			=> 'RT_Shape_Animation',
			'video-with-image' 			=> 'Video_With_Image',			
			'coming-soon'    			=> 'Coming_Soon',
		);

		$widgets2 = [];
		if (class_exists('WooCommerce')) {
			$widgets2 = array(
				'woo-layout' 		=> 'Woo_Product_Layout',
			);
		}

		$widgets = array_merge($widgets1, $widgets2);

		foreach ( $widgets as $widget => $class ) {
			$template_name = "/elementor-custom/widgets/{$widget}.php";
			if ( file_exists( get_stylesheet_directory() . $template_name ) ) {
				$file = get_stylesheet_directory() . $template_name;
			}
			elseif ( file_exists( get_template_directory() . $template_name ) ) {
				$file = get_template_directory() . $template_name;
			}
			else {
				$file = __DIR__ . '/widgets/' . $widget. '.php';
			}

			require_once $file;
			
			$classname = __NAMESPACE__ . '\\' . $class;
			Plugin::instance()->widgets_manager->register( new $classname );
		}
	}

	public function widget_categoty( $elements_manager ) {
		$id         = FMWAVE_CORE_THEME . '-widgets';
		$categories[$id] = array(
			'title' => __('Fmwave Elements', 'fmwave-core'),
			'icon'  => 'fa fa-plug',
		);
		$old_categories = $elements_manager->get_categories();
		$categories = array_merge($categories, $old_categories);
		$set_categories = function ($categories) {
			$this->categories = $categories;
		};
		$set_categories->call( $elements_manager, $categories );
	}

	public function after_enqueue_styles_elementor_editor()
	{
		wp_enqueue_style( 'flaticon-elm', Helper::get_font_css( 'flaticon' ) );
	}

	 public function fmwave_additional_tabs($tabs)
	  {
	  	
	    $json_url3 = Helper::get_asset_file('flaticon-json/fmwave-flaticon.js');

	    $flaticon3 = [
	      'name'          => 'fmwave-flaticon',
	      'label'         => esc_html__( 'Fmwave Icons', 'fmwave-core' ),
	      'url'           => false,
	      'enqueue'       => false,
	      'prefix'        => '',
	      'displayPrefix' => '',
	      'labelIcon'     => 'fab fa-font-awesome-alt',
	      'ver'           => '1.0.0',
	      'fetchJson'     => $json_url3,
	    ];
	    array_push( $tabs, $flaticon3);
	    return $tabs;
	  }

}
new Custom_Widget_Init();