<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use \WP_Widget;
use \RT_Widget_Fields;

class Download_Now extends WP_Widget {
	public function __construct() {
		$id = 'download_now';
		parent::__construct(
            $id, // Base ID
            esc_html__( 'fmwave: Download Now', 'fmwave-core' ), // Name
            array( 'description' => esc_html__( 'fmwave: Download Now Widget', 'fmwave-core' )
            	) );
	}

	public function widget( $args, $instance ){
		echo wp_kses_post( $args['before_widget'] );

		if ( !empty( $instance['title'] ) ) {
			$html = apply_filters( 'widget_title', $instance['title'] );
			$html = $args['before_title'] . $html .$args['after_title'];
		}
		else {
			$html = '';
		}?>

<div class="widget-download">
	<?php if ( !empty( $instance['title'] ) ) {
		?>
	<div class="widget-title">
		<?php echo wp_kses_post( $html );?>
	</div>
	<?php } ?>
		<div class="item-list">
			<div>
			<a href="<?php echo esc_url( $instance['pdf'] ); ?>"><i class="far fa-file-pdf"></i><?php echo wp_kses_post( $instance['pdf_btn_txt'] ); ?></a>
			</div>
			<div>
			<a href="<?php echo esc_url( $instance['word'] ); ?>"><i class="far fa-file-word"></i><?php echo wp_kses_post( $instance['word_btn_txt'] ); ?></a>
			</div>
		</div>
</div>
<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ){
		$instance   = array();
		$instance['title']         					= ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['pdf']          					= ( ! empty( $new_instance['pdf'] ) ) ? sanitize_text_field( $new_instance['pdf'] ) : '';
		$instance['pdf_btn_txt']          	= ( ! empty( $new_instance['pdf_btn_txt'] ) ) ? sanitize_text_field( $new_instance['pdf_btn_txt'] ) : '';
		$instance['word']          					= ( ! empty( $new_instance['word'] ) ) ? sanitize_text_field( $new_instance['pdf'] ) : '';
		$instance['word_btn_txt']           = ( ! empty( $new_instance['word_btn_txt'] ) ) ? sanitize_text_field( $new_instance['word_btn_txt'] ) : '';
	
		return $instance;
	}

	public function form( $instance ){
		$defaults = array(
			'title'         				=> '',
			'pdf'          					=> '',
			'pdf_btn_txt'           		=> esc_html__( 'Document .Word Url', 'fmwave-core' ),
			'word'          				=> '',
			'word_btn_txt'          		=> 'Download Document .word'
		);
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'       => array(
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'type'    => 'text',
			),
			'pdf'        => array(
				'label'   => esc_html__( 'Document .pdf Url', 'fmwave-core' ),
				'type'    => 'url',
			),	
			'pdf_btn_txt'        => array(
				'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
				'type'    => 'text',
			),	
			'word'        => array(
				'label'   => esc_html__( 'Document .Word Url', 'fmwave-core' ),
				'type'    => 'url',
			),
			'word_btn_txt'        => array(
				'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
				'type'    => 'text',
			),	
			
		);

		RT_Widget_Fields::display( $fields, $instance, $this );
	}
}