<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.1
 */


namespace radiustheme\Fmwave_Core;

use \FW_Ext_Backups_Demo;
use \WPCF7_ContactFormTemplate;

if ( ! defined( 'ABSPATH' ) ) exit;

class Demo_Importer {

	protected static $instance;

	public function __construct() {
		add_filter( 'plugin_action_links_rt-demo-importer/rt-demo-importer.php', array( $this, 'add_action_links' ) ); // Link from plugins page 
		add_filter( 'rt_demo_installer_warning', array( $this, 'data_loss_warning' ) );
		add_filter( 'fw:ext:backups-demo:demos', array( $this, 'demo_config' ) );
		add_action( 'fw:ext:backups:tasks:success:id:demo-content-install', array( $this, 'after_demo_install' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	public function add_action_links( $links ) {
		$mylinks = array(
			'<a href="' . esc_url( admin_url( 'tools.php?page=fw-backups-demo-content' ) ) . '">'.__( 'Install Demo Contents', 'fmwave-core' ).'</a>',
		);
		return array_merge( $links, $mylinks );
	}

	public function data_loss_warning( $links ) {
		$html  = '<div style="margin-top:20px;color:#f00;font-size:20px;line-height:1.3;font-weight:600;margin-bottom:40px;border-color: #f00;border-style: dashed;border-width: 1px 0;padding:10px 0;">';
		$html .= __( 'Warning: All your old data will be lost if you install One Click demo data from here, so it is suitable only for a new website.', 'fmwave-core');
		$html .= '</div>';
		return $html;
	}

	public function demo_config( $demos ) {
		$demos_array = array(
			'demo1' => array(
				'title' => __( 'Home 1', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot1.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/',
			),
			'demo2' => array(
				'title' => __( 'Home 2', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot2.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-2/',
			),
			'demo3' => array(
				'title' => __( 'Home 3', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot3.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-3/',
			),
			'demo4' => array(
				'title' => __( 'Home 4', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot4.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-4/',
			),
			'demo5' => array(
				'title' => __( 'Home 5', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot5.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-5/',
			),
			'demo6' => array(
				'title' => __( 'Home 6', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot6.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-6/',
			),
		);

		$download_url = 'http://demo.radiustheme.com/wordpress/demo-content/fmwave/';

		foreach ($demos_array as $id => $data) {
			$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
				'url' => $download_url,
				'file_id' => $id,
			));
			$demo->set_title($data['title']);
			$demo->set_screenshot($data['screenshot']);
			$demo->set_preview_link($data['preview_link']);

			$demos[ $demo->get_id() ] = $demo;

			unset($demo);
		}

		return $demos;
	}

	public function after_demo_install( $collection ){
		// Update front page id
		$demos = array(
			'demo1'  => 1276,
			'demo2'  => 1281,			
			'demo3'  => 1401,
			'demo4'  => 5190,			
			'demo5'  => 5404,			
			'demo6'  => 5406,			
		);

		$data = $collection->to_array();

		foreach( $data['tasks'] as $task ) {
			if( $task['id'] == 'demo:demo-download' ){
				$demo_id = $task['args']['demo_id'];
				$page_id = $demos[$demo_id];
				update_option( 'page_on_front', $page_id );
				flush_rewrite_rules();
				break;
			}
		}

		// Update WooCommerce email options //todo
		$email = get_option( 'admin_email' );
		$name  = get_bloginfo( 'name', 'display' );

		update_option( 'woocommerce_stock_email_recipient', $email );
		update_option( 'woocommerce_email_from_address',    $email );
		update_option( 'woocommerce_email_from_name',       $name );

		// Update post author id
		global $wpdb;
		$id = get_current_user_id();
		$query = "UPDATE $wpdb->posts SET post_author = $id";
		$wpdb->query($query);
	}
}

Demo_Importer::instance();