<?php
/**
 * @author  RadiusTheme
 * @since   1.2
 * @version 1.2
 */

namespace radiustheme\Fmwave_Core;
use \WPCF7_ContactFormTemplate;

if ( ! defined( 'ABSPATH' ) ) exit;

class Demo_Importer_OCDI {

	public function __construct() {
		add_filter( 'pt-ocdi/import_files',          array( $this, 'demo_config' ) );
		add_filter( 'pt-ocdi/after_import',          array( $this, 'after_import' ) );
		add_filter( 'pt-ocdi/disable_pt_branding',   '__return_true' );
		add_action( 'init',                          array( $this, 'rewrite_flush_check' ) );
	}

	public function demo_config() {

		$demos_array = array(
			'demo1' => array(
				'title' => __( 'Home 1', 'fmwave-core' ),
				'page'  => __( 'Home 1', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot1.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/',
			),
			'demo2' => array(
				'title' => __( 'Home 2', 'fmwave-core' ),
				'page'  => __( 'Home 2', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot2.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-2/',
			),			
			'demo3' => array(
				'title' => __( 'Home 3', 'fmwave-core' ),
				'page'  => __( 'Home 3', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot3.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-3/',
			),			
			'demo4' => array(
				'title' => __( 'Home 4', 'fmwave-core' ),
				'page'  => __( 'Home 4', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot4.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-4/',
			),		
			'demo5' => array(
				'title' => __( 'Home 5', 'fmwave-core' ),
				'page'  => __( 'Home 5', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot5.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-5/',
			),		
			'demo6' => array(
				'title' => __( 'Home 6', 'fmwave-core' ),
				'page'  => __( 'Home 6', 'fmwave-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot6.jpg', dirname(__FILE__) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/fmwave/home-6/',
			),
		);

		$config = array();
		$import_path  = trailingslashit( get_template_directory() ) . 'sample-data/';
		$redux_option = 'fmwave';

		foreach ( $demos_array as $key => $demo ) {
			$config[] = array(
				'import_file_id'               => $key,
				'import_page_name'             => $demo['page'],
				'import_file_name'             => $demo['title'],
				'local_import_file'            => $import_path . 'contents.xml',
				'local_import_widget_file'     => $import_path . 'widgets.wie',
				'local_import_customizer_file' => $import_path . 'customizer.dat',
				'local_import_redux'           => array(
					array(
						'file_path'   => $import_path . 'options.json',
						'option_name' => $redux_option,
					),
				),
				'import_preview_image_url'   => $demo['screenshot'],
				'preview_url'                => $demo['preview_link'],
			);
		}

		return $config;
	}

	public function after_import( $selected_import ) {
		$this->assign_menu();
		$this->assign_frontpage( $selected_import );
		$this->assign_woocommerce_pages();
		$this->instagram_feed_settings();
		$this->update_contact_form_sender_email();
		$this->update_permalinks();
		update_option( 'fmwave_ocdi_importer_rewrite_flash', true );
	}

	private function assign_menu() {
		$primary  = get_term_by( 'name', 'Main Menu', 'nav_menu' );
		$vertical = get_term_by( 'name', 'CATEGORIES', 'nav_menu' );

		set_theme_mod( 'nav_menu_locations', array(
			'primary'  => $primary->term_id,
			'vertical' => $vertical->term_id,
		));
	}

	private function assign_frontpage( $selected_import ) {
		$blog_page  = get_page_by_title( 'Blog' );
		$front_page = get_page_by_title( $selected_import['import_page_name'] );

		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front',  $front_page->ID );
		update_option( 'page_for_posts', $blog_page->ID );
	}

	private function assign_woocommerce_pages() {
		$shop     = get_page_by_title( 'Shop' );
		$cart     = get_page_by_title( 'Cart' );
		$checkout = get_page_by_title( 'Checkout' );
		$account  = get_page_by_title( 'My Account' );

		update_option( 'woocommerce_shop_page_id',      $shop->ID );
		update_option( 'woocommerce_cart_page_id',      $cart->ID );
		update_option( 'woocommerce_checkout_page_id',  $checkout->ID );
		update_option( 'woocommerce_myaccount_page_id', $account->ID );
	}

	
	private function update_contact_form_sender_email() {
		$form1 = get_page_by_title( 'Contact', OBJECT, 'wpcf7_contact_form' );
		$form2 = get_page_by_title( 'Newsletter 1', OBJECT, 'wpcf7_contact_form' );
		$form3 = get_page_by_title( 'Newsletter 2', OBJECT, 'wpcf7_contact_form' );
		$form4 = get_page_by_title( 'Newsletter 3', OBJECT, 'wpcf7_contact_form' );

		$forms = array( $form1, $form2, $form3, $form4 );
		foreach ( $forms as $form ) {
			if ( !$form ) {
				continue;
			}
			$cf7id = $form->ID;
			$mail  = get_post_meta( $cf7id, '_mail', true );
			if ( class_exists( 'WPCF7_ContactFormTemplate' ) ) {
				$pattern = "/<[^@\s]*@[^@\s]*\.[^@\s]*>/"; // <email@email.com>
				$replacement = '<'. WPCF7_ContactFormTemplate::from_email().'>';
				$mail['sender'] = preg_replace($pattern, $replacement, $mail['sender']);
			}
			update_post_meta( $cf7id, '_mail', $mail );		
		}
	}

	private function update_permalinks() {
		update_option( 'permalink_structure', '/%postname%/' );
	}

	public function rewrite_flush_check() {
		if ( get_option( 'fmwave_ocdi_importer_rewrite_flash' ) == true  ) {
			flush_rewrite_rules();
			delete_option( 'fmwave_ocdi_importer_rewrite_flash' );
		}
	}
}

new Demo_Importer_OCDI;