<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Woo_Product_Layout extends Custom_Widget_Base {
	
	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT Woo Layout', 'fmwave-core' );
		$this->rt_base = 'rt-woo-layout';
		$this->rt_translate = array(
			'cols'  => array(
				'1' => esc_html__( '1 Col', 'fmwave-core' ),
				'6'  => esc_html__( '6 Col', 'fmwave-core' ),
				'4'  => esc_html__( '4 Col', 'fmwave-core' ),
				'3'  => esc_html__( '3 Col', 'fmwave-core' ),
				'2'  => esc_html__( '2 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_carousel_scripts(){
		wp_enqueue_style(  'owl-carousel' );
		wp_enqueue_style(  'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
	}

	public function rt_fields(){
		
		// find the category of products
		
		$terms  = get_terms( array( 'taxonomy' => 'product_cat', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'Please Selecet category', 'digeco-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' => esc_html__( 'Style 2', 'fmwave-core' ),
					'style3' => esc_html__( 'Style Slider 1', 'fmwave-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat_single_box',
				'label'   => esc_html__( 'Categories', 'fmwave-core' ),
				'options' => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'category_list',
				'label'   => esc_html__( 'Add as many Categories as you want', 'fmwave-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::SELECT2,
						'name'    => 'cat_multi_box',
						'label'   => esc_html__( 'Categories', 'fmwave-core' ),
						'options' => $category_dropdown,
						'multiple'=> false,
						'default' => '1',
					),
				),
			),		
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => esc_html__( 'Enter Post ID that will not display', 'fmwave-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => esc_html__( 'Post ID', 'fmwave-core' ),
						'default' => '0',
					),
				),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title Word count', 'fmwave-core' ),
				'default' => 5,
				'description' => esc_html__( 'Maximum number of words', 'fmwave-core' ),				
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'excerpt_count',
				'label'   => esc_html__( 'Word count', 'fmwave-core' ),
				'default' => 13,
				'description' => esc_html__( 'Maximum number of words', 'fmwave-core' ),
			),			
			
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'fmwave-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'fmwave-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'fmwave-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Post Sorting', 'fmwave-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'fmwave-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'fmwave-core' ),
					'menu_order' 	=> esc_html__( 'Custom Order', 'fmwave-core' ),
					'title' 		=> esc_html__( 'By Name', 'fmwave-core' ),
				),
				'default' => 'recent',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'itemnumber',
				'label'   => esc_html__( 'Item Number', 'fmwave-core' ),
				'default' => -1,
				'description' => esc_html__( 'Use -1 for showing all items( Showing items per category )', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			/*Title Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_colors',
				'label'   => esc_html__( 'Colors', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'box_bg_color',
				'label'   => esc_html__( 'Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-layout .item-box .item-img' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-layout .item-box .item-content .rtin-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_hoer_color',
				'label'   => esc_html__( 'Title Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-layout .item-box .item-content .rtin-title a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'pricr_color',
				'label'   => esc_html__( 'Price Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-layout .item-box .item-content .rtin-price' => 'color: {{VALUE}}',
				),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .default-layout .item-box .item-content .rtin-title',
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'price_typo',
				'label'   => esc_html__( 'Price Typography', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .default-layout .item-box .item-content .rtin-price',
			),
			array(
				'mode' => 'section_end',
			),
			
			
			/*Title Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_switch',
				'label'   => esc_html__( 'Off / On', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::SWITCHER,
				'id'      => 'cat_showhide',
				'label'   => esc_html__( 'Category', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'type'    => Controls_Manager::SWITCHER,
				'id'      => 'title_showhide',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'type'    => Controls_Manager::SWITCHER,
				'id'      => 'price_showhide',
				'label'   => esc_html__( 'Price Show/Hide', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'type'    => Controls_Manager::SWITCHER,
				'id'      => 'rating_showhide',
				'label'   => esc_html__( 'Rating Show/Hide', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'no',
			),
			array(
				'type'    => Controls_Manager::SWITCHER,
				'id'      => 'excerpt_display',
				'label'   => esc_html__( 'Short Detail Show/Hide', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'no',
			),
			
			array(
				'mode' => 'section_end',
			),
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xl',
				'label'   => esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Phones: > 576px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col',
				'label'   => esc_html__( 'Phones: < 576px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
			
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'fmwave-core' ),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_nav',
				'label'       => esc_html__( 'Navigation Arrow', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable navigation arrow. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_dots',
				'label'       => esc_html__( 'Navigation Dots', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => '',
				'description' => esc_html__( 'Enable or disable navigation dots. Default: Off', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => esc_html__( 'Stop on Hover', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Stop autoplay on mouse hover. Default: On', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'slider_interval',
				'label'   => esc_html__( 'Autoplay Interval', 'fmwave-core' ),
				'options' => array(
					'5000' => esc_html__( '5 Seconds', 'fmwave-core' ),
					'4000' => esc_html__( '4 Seconds', 'fmwave-core' ),
					'3000' => esc_html__( '3 Seconds', 'fmwave-core' ),
					'2000' => esc_html__( '2 Seconds', 'fmwave-core' ),
					'1000' => esc_html__( '1 Second',  'fmwave-core' ),
				),
				'default' => '5000',
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'fmwave-core' ),
				'default' => 200,
				'description' => esc_html__( 'Slide speed in milliseconds. Default: 200', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),			
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		
		$owl_data = array( 
			'nav'                => $data['slider_nav'] == 'yes' ? true : false,
			'dots'               => $data['slider_dots'] == 'yes' ? true : false,
			'navText'            => array( "<i class='fas fa-angle-left'></i>", "<i class='fas fa-angle-right'></i>" ),
			'autoplay'           => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplayTimeout'    => $data['slider_interval'],
			'autoplaySpeed'      => $data['slider_autoplay_speed'],
			'autoplayHoverPause' => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'               => $data['slider_loop'] == 'yes' ? true : false,
			'margin'             => 0,
			'responsive'         => array(
				'0'    => array( 'items' => 12 / $data['col'] ),
				'480'  => array( 'items' => 12 / $data['col_sm'] ),
				'768'  => array( 'items' => 12 / $data['col_md'] ),
				'992'  => array( 'items' => 12 / $data['col_lg'] ),
				'1200' => array( 'items' => 12 / $data['col_xl'] ),
			)
		);		
		
		switch ( $data['style'] ) {			
			case 'style3':
			$data['owl_data'] = json_encode( $owl_data );
			$this->rt_load_carousel_scripts();
			$template = 'woo-layout-3';
			break;
			case 'style2':
			$template = 'woo-layout-2';
			break;
			default:
			$template = 'woo-layout-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}