<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Upcoming_Show extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Upcoming Show', 'fmwave-core' );
		$this->rt_base = 'rt-upcoming-show';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	
	public function rt_fields(){
		$prefix = FMWAVE_CORE_CPT;
		global $post;
		$post_dropdown = array( '0' => esc_html__( 'All Show', 'fmwave-core' ) );
		$args = array( 'post_type' => "{$prefix}_show", 'numberposts' => -1);
		$myposts = get_posts( $args );
		foreach( $myposts as $post ) {
			setup_postdata($post);
			
			$post_dropdown[$post->ID] = $post->post_title;
			
		} wp_reset_postdata();
		
		$fields = array(
	
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_image_icon',
				'label'   => esc_html__( 'Options', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Show Display Type', 'fmwave-core' ),
				'options' => array(
					'manual'  => esc_html__( 'Show Layout 1', 'fmwave-core' ),
					'dynamic' => esc_html__( 'Show Layout 2', 'fmwave-core' ),
					'dynamic3' => esc_html__( 'Show Layout 3', 'fmwave-core' ),
					'dynamic2' => esc_html__( 'Next Show', 'fmwave-core' ),
				),
				'default' => 'manual',
				'description' => esc_html__( 'Manually type means you insert the show data, Dynamic type means it will automatically select show for database as per time of the show',
					'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_selected_show',
				'label'   => esc_html__( 'Enter Post ID that will not display', 'fmwave-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::SELECT2,
						'name'    => 'post_list',
						'label'   => esc_html__( 'Select Show Name', 'fmwave-core' ),
						'options' => $post_dropdown,
						'default' => '0',
					),
				),
			),
			array(
				'type'    		=> Controls_Manager::NUMBER,
				'id'      		=> 'number',
				'label'   		=> esc_html__( 'Total number of posts', 'fmwave-core' ),
				'default' 		=> 3,
				'description' => esc_html__( 'Write -1 to show all', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),	
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .default-upcoming .show-box .item-content .item-title',
			), 
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .default-upcoming .show-box .item-content .item-title a' => 'color: {{VALUE}}',
				),
			),	
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'rj_color',
				'label'   => __( 'RJ Color', 'fmwave-core' ),
				'default' => '',                       
				'selectors' => array(
					'{{WRAPPER}} .default-upcoming .show-box .item-content .host-name' => 'color: {{VALUE}}',
				),
			),	
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'mode'          => 'responsive',
				'id'      => 'title_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),
				'selectors' => array(
					'{{WRAPPER}} .default-upcoming .show-box .item-content .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'separator' => 'before',
			),
			array(
				'mode' => 'section_end',
			),
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   =>esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   =>esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   =>esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   =>esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   =>esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   =>esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
	
		);
		return $fields;
	}
	
	protected function render() {
		$data = $this->get_settings();
		
		switch ( $data['layout'] ) {
			case 'dynamic3':
				$template = 'upcoming-dynamic3';
				break;
			case 'dynamic2':
				$template = 'upcoming-dynamic2';
				break;
			case 'dynamic':
				$template = 'upcoming-dynamic';
				break;
			default:
				$template = 'upcoming-manually';
		}
		
		return $this->rt_template( $template, $data );
	}
	
}