<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;


if ( ! defined( 'ABSPATH' ) ) exit;
class TV_Hero_Slider extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'TV Hero Slider', 'fmwave-core' );
		$this->rt_base = 'rt-hero-slider';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style(  'owl-carousel' );
		wp_enqueue_style(  'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
	}

	public function rt_fields(){	

		$prefix = FMWAVE_CORE_CPT;

		$terms  = get_terms( array( 'taxonomy' => "{$prefix}_tvshow_category", 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'Please Selecet category', 'fmwave-core' ) );
		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'fmwave-core' ),
				'options' => $category_dropdown,
				'default' => '0',			
				'multiple' => true,
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Item tv show', 'fmwave-core' ),
				'default' => '6',
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'fmwave-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'fmwave-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'fmwave-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'post_orderby',
				'label'   => esc_html__( 'Post Sorting', 'fmwave-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'fmwave-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'fmwave-core' ),
					'title' 		=> esc_html__( 'By Name', 'fmwave-core' ),
				),
				'default' => 'recent',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title Count', 'fmwave-core' ),
				'default' => '3',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'category_display',
				'label'       => esc_html__( 'Show Category', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'director_display',
				'label'       => esc_html__( 'Show Director', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'rating_display',
				'label'       => esc_html__( 'Show Rating', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'video_display',
				'label'       => esc_html__( 'Show Video', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'yes',
			),
			array(
				'mode' => 'section_end',
			),

			array(
            'mode'    => 'section_start',
            'id'      => 'sec_style',
            'label'   => esc_html__( 'Style', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector' => '{{WRAPPER}} .tv-hero-slider .hero-box .item-title',
			),
	        array(
	            'type'    => Controls_Manager::COLOR,
	            'id'      => 'title_color',
	            'label'   => __( 'Color', 'fmwave-core' ),
	            'default' => '',                       
	            'selectors' => array(
	                '{{WRAPPER}} .tv-hero-slider .hero-box .item-title a' => 'color: {{VALUE}}',
	            ),
	        ),	        
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'bg_overlay_color',
				'label'   => esc_html__( 'Image Overlay Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .tv-hero-slider .hero-box:after' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   =>esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   =>esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   =>esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   =>esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   =>esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   =>esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_nav',
				'label'       => esc_html__( 'Navigation Arrow', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => '',
				'description' => esc_html__( 'Enable or disable navigation arrow. Default: Off', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_dots',
				'label'       => esc_html__( 'Navigation Dots', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable navigation dots. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => esc_html__( 'Stop on Hover', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Stop autoplay on mouse hover. Default: On', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'slider_interval',
				'label'   => esc_html__( 'Autoplay Interval', 'fmwave-core' ),
				'options' => array(
					'10000' => esc_html__( '10 Seconds', 'fmwave-core' ),
					'8000' => esc_html__( '8 Seconds', 'fmwave-core' ),
					'5000' => esc_html__( '5 Seconds', 'fmwave-core' ),
					'4000' => esc_html__( '4 Seconds', 'fmwave-core' ),
					'3000' => esc_html__( '3 Seconds', 'fmwave-core' ),
					'2000' => esc_html__( '2 Seconds', 'fmwave-core' ),
					'1000' => esc_html__( '1 Second',  'fmwave-core' ),
				),
				'default' => '5000',
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'fmwave-core' ),
				'default' => 200,
				'description' => esc_html__( 'Slide speed in milliseconds. Default: 200', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {

		$data = $this->get_settings();
		$owl_data = array( 
			'nav'                => $data['slider_nav'] == 'yes' ? true : false,
			'dots'               => $data['slider_dots'] == 'yes' ? true : false,
			'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
			'autoplay'           => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplayTimeout'    => $data['slider_interval'],
			'autoplaySpeed'      => $data['slider_autoplay_speed'],
			'autoplayHoverPause' => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'               => $data['slider_loop'] == 'yes' ? true : false,
			'margin'             => 0,
			'responsive'         => array(
				'0'    => array( 'items' => 12 / $data['col_mobile'] ),
				'480'  => array( 'items' => 12 / $data['col_xs'] ),
				'768'  => array( 'items' => 12 / $data['col_sm'] ),
				'992'  => array( 'items' => 12 / $data['col_md'] ),
				'1200' => array( 'items' => 12 / $data['col_lg'] ),
			)
		);

		$data['owl_data'] = json_encode( $owl_data );	

			$this->rt_load_scripts();
			$template = 'tv-hero-slider';

		return $this->rt_template( $template, $data );
	}
}