<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;
class Text_With_Title extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Fancy Heading', 'fmwave-core' );
		$this->rt_base = 'rt-text-with-title';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
			
			array(
				'mode'    => 'section_start',
				'id'      => 'twt_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   =>esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'style1' =>esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' =>esc_html__( 'Style 2', 'fmwave-core' ),
				),
				'default' => 'style1',
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'twt_top_title',
				'label'   => esc_html__( 'Top Title', 'fmwave-core' ),
				'condition'         => [
					'style'   => 'style2',
				],
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'top_title',
				'label'   => esc_html__( 'Top Title Text', 'fmwave-core' ),
				'default' => esc_html__('To Get Started', 'fmwave-core' ),
				'condition'         => ['style'   => 'style2',],
			),
			array(
				'mode' => 'section_end',
				'condition'         => [
					'style'   => 'style2',
				],
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'twt_general',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'default' => 'Fancy Title Here' ,
			),
            array(
				'type'    => Controls_Manager::CHOOSE,
				'id'      => 'title_tag',
				'label'   => esc_html__( 'Title HTML Tag', 'fmwave-core' ),
				'options' => array(
					'h1'  => [
						'title' => esc_html__( 'H1', 'fmwave-core' ),
						'icon' => 'eicon-editor-h1'
					],
					'h2'  => [
						'title' => esc_html__( 'H2', 'fmwave-core' ),
						'icon' => 'eicon-editor-h2'
					],
					'h3'  => [
						'title' => esc_html__( 'H3', 'fmwave-core' ),
						'icon' => 'eicon-editor-h3'
					],
					'h4'  => [
						'title' => esc_html__( 'H4', 'fmwave-core' ),
						'icon' => 'eicon-editor-h4'
					],
					'h5'  => [
						'title' => esc_html__( 'H5', 'fmwave-core' ),
						'icon' => 'eicon-editor-h5'
					],
					'h6'  => [
						'title' => esc_html__( 'H6', 'fmwave-core' ),
						'icon' => 'eicon-editor-h6'
					],
					'div'  => [
						'title' => esc_html__( 'div', 'fmwave-core' ),
						'icon' => 'eicon-font'
					]
				),
				'default' => 'h1',
            ),
			array(
				'mode' => 'section_end',
			),

	  array(
			'mode'    => 'section_start',
			'id'      => 'twt_content',
			'label'   => esc_html__( 'Content', 'fmwave-core' ),
		),
		array(
			'type'    => Controls_Manager::WYSIWYG,
			'id'      => 'content',
			'label'   => esc_html__( 'Content', 'fmwave-core' ),
			'default' => esc_html__('magnam aliquam quaerat voluptatemo qui quia dolor sit amedipisci develit.', 'fmwave-core' ),
		),
		array(
		  'mode' => 'section_end',
		),

	  array(
			'mode'    => 'section_start',
			'id'      => 'twt_btn',
			'label'   => esc_html__( 'Button', 'fmwave-core' ),
		),
		array(
			'type'    => Controls_Manager::TEXT,
			'id'      => 'buttontext',
			'label'   => esc_html__( 'Button Text', 'fmwave-core' ),
			'default' => 'Button Text',
		),
		array(
			'type'    => Controls_Manager::URL,
			'id'      => 'buttonurl',
			'label'   => esc_html__( 'Button URL', 'fmwave-core' ),
			'placeholder' => 'https://your-link.com',
		),
		array(
			  'mode' => 'section_end',
		),

		// Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'pwt_title_style',
            'label'   => esc_html__( 'Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ), 
        array(
            'type'    	=> Controls_Manager::COLOR,
            'id'      	=> 'title_color',
            'label'   	=> esc_html__( 'Color', 'fmwave-core' ),
            'default' 	=> '',                       
            'selectors' => array(
                    '{{WRAPPER}} .hero-content-2 .item-title' => 'color: {{VALUE}}',                          
                ),
			'condition'         => ['style'   => 'style2',],
        ),  
        array( 
            'mode'      => 'group',
            'type'      => Group_Control_Typography::get_type(),
            'name'      => 'title_font_size',                
            'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
            'selector'  => '{{WRAPPER}} .hero-content-default .item-title',       	
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'title_margin',
            'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .hero-content .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
                '{{WRAPPER}} .hero-content-2 .item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',               
            ),
            'separator' => 'before',
        ),
		array(
			'mode' => 'section_end',
		),
		
		// Title style
        array(
            'mode'    => 'section_start',
            'id'      => 'sub_title_style',
            'label'   => esc_html__( 'Sub Title', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
			'condition'         => ['style'   => 'style2',],
        ), 
        array(
            'type'    	=> Controls_Manager::COLOR,
            'id'      	=> 'sub_title_color',
            'label'   	=> esc_html__( 'Color', 'fmwave-core' ),
            'default' 	=> '',                       
            'selectors' => array(
				'{{WRAPPER}} .hero-content-2 .sub-title' => 'color: {{VALUE}}',                          
			),
        ),  
        array( 
            'mode'      => 'group',
            'type'      => Group_Control_Typography::get_type(),
            'name'      => 'sub_title_font_size',                
            'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
            'selector'  => '{{WRAPPER}} .hero-content-2 .sub-title',        	
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'sub_title_margin',
            'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .hero-content-2 .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',          
            ),
            'separator' => 'before',
        ),
		array(
			'mode' => 'section_end',
		),

        //section Content style
        array(
            'mode'    => 'section_start',
            'id'      => 'pwt_content_style',
            'label'   => esc_html__( 'Content', 'fmwave-core' ),
            'tab'     => Controls_Manager::TAB_STYLE,
        ),               
        array(
            'type'    => Controls_Manager::COLOR,
            'id'      => 'content_color',
            'label'   => esc_html__( 'Color', 'fmwave-core' ),
            'default' => '',                       
            'selectors' => array(
                '{{WRAPPER}} .hero-content-default .rtr-content' => 'color: {{VALUE}}',                         
            ),
        ),  
        array( 
            'mode'      => 'group',
            'type'      => Group_Control_Typography::get_type(),
            'name'      => 'content_font_size',                
            'label'     => esc_html__( 'Content Typography', 'fmwave-core' ),
            'selector'  => '{{WRAPPER}} .hero-content-default .rtr-content',
        ),
        array(
            'type'    => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'id'      => 'content_margin',
            'label'   => esc_html__( 'Margin', 'fmwave-core' ),                 
            'selectors' => array(
                '{{WRAPPER}} .hero-content-default .rtr-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
            ),
            'separator' => 'before',
        ),  
        array(
            'mode' => 'section_end',
        ),

		//section Button style
		array(
			'mode'    => 'section_start',
			'id'      => 'pwt_btn_style',
			'label'   => esc_html__( 'Button', 'fmwave-core' ),
			'tab'     => Controls_Manager::TAB_STYLE),
			array(
				'type'    	=> Controls_Manager::COLOR,
				'id'      	=> 'btn_color',
				'label'   	=> esc_html__( 'Color', 'fmwave-core' ),
				'default' 	=> '',
				'selectors' =>
				array(
					'{{WRAPPER}} .hero-content-default .item-btn' => 'color: {{VALUE}};',
				),
			),
			array(
				'type'    	=> Controls_Manager::COLOR,
				'id'      	=> 'btn_bg_color',
				'label'   	=> esc_html__( 'Background Color', 'fmwave-core' ),
				'default' 	=> '',
				'selectors' =>
				array(
					'{{WRAPPER}} .hero-content-default .item-btn' => 'background-color: {{VALUE}};',
				),
			),
			array(
				'type'    	=> Controls_Manager::COLOR,
				'id'      	=> 'btn_bg_hov_color',
				'label'   	=> esc_html__( 'Background Hover Color', 'fmwave-core' ),
				'default' 	=> '',
				'selectors' =>
				array(
					'{{WRAPPER}} .hero-content-default .item-btn:after' => 'background-color: {{VALUE}};',
				),
			),
			array(
				'type'    		=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'id'      		=> 'btn_padding',
				'label'   		=> esc_html__( 'Padding', 'fmwave-core' ),
				'selectors' 	=>
					array(
						'{{WRAPPER}} .hero-content-default .item-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
						),
				'separator' 	=> 'before',
			),
		array(
			'mode' => 'section_end',
		),

		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();

		switch ( $data['style'] ) {
			case 'style2':
				$template = 'fancy-heading-2';
				break;
			default:
				$template = 'fancy-heading-1';
				break;
		}

		return $this->rt_template( $template, $data );
	}
}