<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Testimonial extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Testimonial', 'fmwave-core' );
		$this->rt_base = 'rt-testimonial';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style(  'owl-carousel' );
		wp_enqueue_style(  'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
	}

	public function rt_fields(){
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'list_icon_class', [
				'type' => Controls_Manager::ICONS,
				'label'   => esc_html__( 'Icon', 'fmwave-core' ),
				'Description'  => esc_html__( 'Icon will place before features text', 'fmwave-core' ),
				'label_block' => true,
				'default' => array(
			      'value' => 'fas fa-quote-right',
			      'library' => 'fa-solid',
				),
			]
		);
		$repeater->add_control(
			'list_color', [
				'type' => Controls_Manager::COLOR,
				'label'   => esc_html__( 'Icon Color', 'fmwave-core' ),
				'default'  => '#ec1c24',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'title', [
				'type' => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'default' => esc_html__( 'Seth Reyes', 'fmwave-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'subtitle', [
				'type' => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Sub title', 'fmwave-core' ),
				'default' => esc_html__( 'CEO, Atcec', 'fmwave-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'content', [
				'type' => Controls_Manager::TEXTAREA,
				'label'   => esc_html__( 'Content', 'fmwave-core' ),
				'default' => esc_html__( 'Our service is always on top because of the great bonus packs that come with every initial order. Сheck out all the availble rates for your specific needs and preferences.', 'fmwave-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'image', [
				'type' => Controls_Manager::MEDIA,
				'label'   => esc_html__( 'Author Image', 'roofix-core' ),
				'description' => esc_html__( 'Image size should be 90x90 px', 'roofix-core' ),
				'label_block' => true,
			]
		);

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'testimonial',
				'label'   => esc_html__( 'Features ', 'fmwave-core' ),
				'fields' => $repeater->get_controls(),
				'default' => array(
					['text' => 'Up to 50Mbps', ],
					['text' => 'Night Turbo-Speed', ],
					['text' => 'WiFi router', ],
					['text' => 'Unlimited devices', ],
					['text' => 'Local Speed Youtube', ],
				),
			),
			array(
				'mode' => 'section_end',
			),
			// Item style
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_style',
				'label'       => esc_html__( 'Style', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'bgcolor',
				'label'   => esc_html__( 'Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-testimonial .item-box' => 'background: {{VALUE}}',
				)
			),			
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'border_radius',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Box Padding', 'fmwave-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .default-testimonial .item-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   =>esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   =>esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   =>esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   =>esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   =>esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   =>esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_nav',
				'label'       => esc_html__( 'Navigation Arrow', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => '',
				'description' => esc_html__( 'Enable or disable navigation arrow. Default: Off', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_dots',
				'label'       => esc_html__( 'Navigation Dots', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable navigation dots. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => esc_html__( 'Stop on Hover', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Stop autoplay on mouse hover. Default: On', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'slider_interval',
				'label'   => esc_html__( 'Autoplay Interval', 'fmwave-core' ),
				'options' => array(
					'5000' => esc_html__( '5 Seconds', 'fmwave-core' ),
					'4000' => esc_html__( '4 Seconds', 'fmwave-core' ),
					'3000' => esc_html__( '3 Seconds', 'fmwave-core' ),
					'2000' => esc_html__( '2 Seconds', 'fmwave-core' ),
					'1000' => esc_html__( '1 Second',  'fmwave-core' ),
				),
				'default' => '5000',
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'fmwave-core' ),
				'default' => 200,
				'description' => esc_html__( 'Slide speed in milliseconds. Default: 200', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
	
	protected function render() {
		$data = $this->get_settings();
		$owl_data = array( 
			'nav'                => $data['slider_nav'] == 'yes' ? true : false,
			'dots'               => $data['slider_dots'] == 'yes' ? true : false,
			'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
			'autoplay'           => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplayTimeout'    => $data['slider_interval'],
			'autoplaySpeed'      => $data['slider_autoplay_speed'],
			'autoplayHoverPause' => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'               => $data['slider_loop'] == 'yes' ? true : false,
			'margin'             => 30,
			'responsive'         => array(
				'0'    => array( 'items' => 12 / $data['col_mobile'] ),
				'480'  => array( 'items' => 12 / $data['col_xs'] ),
				'768'  => array( 'items' => 12 / $data['col_sm'] ),
				'992'  => array( 'items' => 12 / $data['col_md'] ),
				'1200' => array( 'items' => 12 / $data['col_lg'] ),
			)
		);

		$data['owl_data'] = json_encode( $owl_data );	
		
		$template = 'testimonial';

		return $this->rt_template( $template, $data );
	}
}