<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use radiustheme\Fmwave\Helper;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;
class Team_Members extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Team Member', 'fmwave-core' );
		$this->rt_base = 'rt-team-member';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'fmwave-core' ),
				'6'  => esc_html__( '2 Col', 'fmwave-core' ),
				'4'  => esc_html__( '3 Col', 'fmwave-core' ),
				'3'  => esc_html__( '4 Col', 'fmwave-core' ),
				'2'  => esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'isotope-pkgd' );
	}
	
	public function rt_fields(){
		$cpt = FMWAVE_CORE_CPT;
		$terms  = get_terms( array( 'taxonomy' => "{$cpt}_team_category", 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'fmwave-core' ) );
		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' => esc_html__( 'Style 2', 'fmwave-core' ),
					'style3' => esc_html__( 'Style 3', 'fmwave-core' ),
					'style4' => esc_html__( 'Style 4', 'fmwave-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    		=> Controls_Manager::NUMBER,
				'id'      		=> 'number',
				'label'   		=> esc_html__( 'Total number of items', 'fmwave-core' ),
				'default' 		=> 4,
				'description' 	=> esc_html__( 'Write -1 to show all', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'content_display',
				'label'       => esc_html__( 'Short details', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'fmwave-core' ),
				'condition' => array( 'style' => array( 'style2','style3')),
			),

			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => esc_html__( 'Word count', 'fmwave-core' ),
				'default' => 15,
				'description' => esc_html__( 'Maximum number of words', 'fmwave-core' ),
				'condition'   => array( 'content_display' => array( 'yes' ), 'style' => array( 'style2', 'style3' ) ),
				
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'fmwave-core' ),
				'options' => $category_dropdown,
				'default' => '0',
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'fmwave-core' ),
				'options' => array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'fmwave-core' ),
					'title'       => esc_html__( 'Title', 'fmwave-core' ),
					'menu_order'  => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'fmwave-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_display',
				'label'       => esc_html__( 'Show Display', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Designation. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'item_social',
				'label'       => esc_html__( 'Item Social', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Social link. Default: On', 'fmwave-core' ),
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'pagination_display',
				'label'       => esc_html__( 'Show Pagination', 'fmwave-core' ),
				'label_on'    => esc_html__( 'Show', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Hide', 'fmwave-core' ),
				'default'     => 'no',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'team_box_bgcolor',
				'label'   => esc_html__( 'Box Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-box' => 'background-color: {{VALUE}}',
				),
				'condition' => array( 'style' => array( 'style2', 'style3')),
			),		
			array(
				'mode' => 'section_end',
			),

			// Title Style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,				
			),			
			array( 
				'mode'      => 'group',
				'type'    	=> Group_Control_Typography::get_type(),
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Title Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .team-default-layout .item-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_hov_color',
				'label'   => esc_html__( 'Title Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-title a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type' 			=> Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      		=> 'title_spacing',
				'label'   		=> esc_html__( 'Title Spacing', 'fmwave-core' ),						
				'size_units' => array( 'px' ),
				'default' => array(
				'unit' => 'px',
				'size' => '',
				),
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				)
			),
			array(
				'mode' => 'section_end',
			),
			
			// Show Style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_show',
				'label'   => esc_html__( 'Show Name', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,				
			),
			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'show_typo',
				'label'     => esc_html__( 'Show Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .team-default-layout .item-subtitle',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'show_color',
				'label'   => esc_html__( 'Show Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-subtitle' => 'color: {{VALUE}}',
				),
			),
			array(
				'type' 			=> Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      		=> 'show_spacing',
				'label'   		=> esc_html__( 'Show Spacing', 'fmwave-core' ),						
				'size_units' => array( 'px' ),
				'default' => array(
				'unit' => 'px',
				'size' => '',
				),
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				)
			),
			array(
				'mode' => 'section_end',
			),
			
			// Date Style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_date',
				'label'   => esc_html__( 'Date', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,				
			),
			array( 
				'mode'      => 'group',
				'type'      => Group_Control_Typography::get_type(),
				'name'      => 'date_typo',
				'label'     => esc_html__( 'Date Typography', 'fmwave-core' ),
				'selector'  => '{{WRAPPER}} .team-default-layout .item-time',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'date_color',
				'label'   => esc_html__( 'Date Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-time' => 'color: {{VALUE}}',
				),
			),
			array(
				'type' 			=> Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      		=> 'date_spacing',
				'label'   		=> esc_html__( 'Date Spacing', 'fmwave-core' ),						
				'size_units' => array( 'px' ),
				'default' => array(
				'unit' => 'px',
				'size' => '',
				),
				'selectors' => array(
					'{{WRAPPER}} .team-default-layout .item-time' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				)
			),
			array(
				'mode' => 'section_end',
			),
			
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '3',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();				
		switch ( $data['style'] ) {
			case 'style4':
				$template = 'team-4';
			break;	
			case 'style3':
				$template = 'team-3';
			break;	
			case 'style2':
				$template = 'team-2';
			break;
			default:
				$template = 'team-1';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}