<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;
class RT_Shape_Animation extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Shape Animation', 'fmwave-core' );
		$this->rt_base = 'rt-shape-animation';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),
					'layout3' => esc_html__( 'Layout 3', 'fmwave-core' ),
					'layout4' => esc_html__( 'Layout 4', 'fmwave-core' ),
				),
				'default' => 'layout1',
			),
			array(
				'mode' => 'section_end',
			),
		);		
		return $fields;
	}
	private function rt_load_scripts(){	
		wp_enqueue_script( 'sal' );
	}

	protected function render() {
		$data = $this->get_settings();
		switch ( $data['layout'] ) {
			case 'layout4':
				$template = 'shape-animation-4';
				break;
			case 'layout3':
				$template = 'shape-animation-3';
				break;
			case 'layout2':
				$template = 'shape-animation-2';
				break;
			default:
				$template = 'shape-animation-1';
				break;
		}
		return $this->rt_template( $template, $data );
	}
}