<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
	
namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Schedule extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Schedule', 'fmwave-core' );
		$this->rt_base = 'rt-schedule';
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'isotope-pkgd' , '', 'fmwave-main' );
	}
	public function rt_fields(){
		$prefix = FMWAVE_CORE_CPT;
        $terms = get_terms( array( 'taxonomy' => "{$prefix}_show_category" ) );
        $category_dropdown = array( '0' => __( 'All Categories', 'fmwave-core' ) );
        foreach ( $terms as $category ) {
            $category_dropdown[$category->term_id] = $category->name;
        }

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'schedule_style',
				'label'   => __( 'Schedule Layout Style', 'fmwave-core' ),
				'options' => array(
					'isotope' => esc_html__( 'Isotope', 'fmwave-core' ),
					'tab'     => esc_html__( 'Weekday Tab', 'fmwave-core' ),
					'tab2'     => esc_html__( 'Weekday Tab 2', 'fmwave-core' ),
					'tab3'     => esc_html__( 'Weekday Tab 3', 'fmwave-core' ),
					'list1'   => esc_html__( 'List 1 ( Today\'s Schedule )', 'fmwave-core' ),
					'list2'   => esc_html__( 'List 2 ( Show List by Admin )', 'fmwave-core' ),
				),
				'default' => 'isotope',
			),
            array(
                'id'    => 'category',
                'label' => esc_html__( 'Category', 'fmwave-core' ),
                'type'  =>  Controls_Manager::SELECT,
                'options'   => $category_dropdown,
                'default'   => '0',
            ),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_per_page',
				'label'   => esc_html__( 'How many shows you want to show?', 'fmwave-core' ),
				'default' => '10',
			),
            array(
                'type'        => Controls_Manager::SWITCHER,
                'id'          => 'btn_display',
                'label'       => esc_html__( 'Display Button', 'fmwave-core' ),
                'label_on'    => esc_html__( 'On', 'fmwave-core' ),
                'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
                'default'     => 'yes',
                'description' => esc_html__( 'Show or Hide Button. Default: On', 'fmwave-core' ),
	            'condition' => array( 'schedule_style'    => array( 'list' ),  ),
            ),
            /*admin schedule list*/
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'schedule_addon_title',
				'label'   => esc_html__( 'Title Of the list', 'fmwave-core' ),
				'default' => '',
				'description' => esc_html__( 'Simple Text, Like: Our Programs', 'fmwave-core' ),
				'condition' => array( 'schedule_style'    => array( 'list1', 'list2' ),  ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'schedule_addon_url',
				'label'   => esc_html__( 'Schedule List Page Url', 'fmwave-core' ),
				'default' => '',
				'description' => esc_html__( 'Give the link of the schedule list page or any page, Like: Our Programs', 'fmwave-core' ),
				'condition' => array( 'schedule_style'    => array( 'list1', 'list2' ),  ),
			),
            array(
                'mode' => 'section_end',
            ),

			// Style Tab
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_style',
                'tab'     => Controls_Manager::TAB_STYLE,
                'label'   => __( 'Style', 'fmwave-core' ),
				'condition' => array( 'schedule_style'    => array( 'list1', 'list2' ),  ),
            ),
            array(
                'mode'     => 'group',
                'type'      => Group_Control_Typography::get_type(),
                'name'       => 'title_list2_typo',
                'label'    => __( 'Heading Title', 'fmwave-core' ),
                'selector' => '{{WRAPPER}} .our-program .item-heading .item-title, {{WRAPPER}} .shows-list .show-box .item-heading .item-title',
            ),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_list2_color',
				'label'   => esc_html__( 'Heading Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .our-program .item-heading .item-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shows-list .show-box .item-heading .item-title' => 'color: {{VALUE}}',
				),
			),
			
			//Title color
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Item Title Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .our-program li .media .media-body .item-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shows-list .show-list li .media .media-body .item-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_hover_color',
				'label'   => esc_html__( 'Item Title Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .our-program li .media .media-body .item-title a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shows-list .show-list li .media .media-body .item-title a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_color',
				'label'   => esc_html__( 'Meta Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .our-program li .notify-show a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shows-list .show-list li .notify-show a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shows-list .show-list li .media .media-body .host-name' => 'color: {{VALUE}}',
					'{{WRAPPER}} .our-program li .media .media-body .host-name' => 'color: {{VALUE}}',
				),
			),
			
			array(
                'mode' => 'section_end',
            ),
			
			// Style Button
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_button',
                'tab'     => Controls_Manager::TAB_STYLE,
                'label'   => __( 'Button Style', 'fmwave-core' ),
				'condition' => array( 'schedule_style'    => array( 'list1' ),  ),
            ),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_color',
				'label'   => esc_html__( 'Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-list li .show-time' => 'color: {{VALUE}}',
				),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_color',
				'label'   => esc_html__( 'Background Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-list li .show-time' => 'background-color: {{VALUE}}',
				),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_hov_color',
				'label'   => esc_html__( 'Background Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-list li:hover .show-time' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'id'      => 'button_padding',
				'label'   => __( 'Padding', 'fmwave-core' ),
				'mode'    => 'responsive',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-list li .show-time' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                   
				),
				'separator' => 'before',
			), 
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'id'      => 'button_margin',
				'label'   => __( 'Margin', 'fmwave-core' ),
				'mode'    => 'responsive',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-list li .show-time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                   
				),
				'separator' => 'before',
			), 
			
            array(
                'mode' => 'section_end',
            ),
			
			// Style Button
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_view',
                'tab'     => Controls_Manager::TAB_STYLE,
                'label'   => __( 'View All', 'fmwave-core' ),
				'condition' => array( 'schedule_style'    => array( 'list1', 'list2' ),  ),
            ),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'view_color',
				'label'   => esc_html__( 'Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-box .item-heading .view-all-btn' => 'color: {{VALUE}}',
					'{{WRAPPER}} .our-program .item-heading .view-all-btn' => 'color: {{VALUE}}',
				),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'view_hov_color',
				'label'   => esc_html__( 'Hover Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .shows-list .show-box .item-heading .view-all-btn:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .our-program .item-heading .view-all-btn:hover' => 'color: {{VALUE}}',
				),
			),			
            array(
                'mode' => 'section_end',
            ),
			
			// Style schedule
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_schedule',
                'tab'     => Controls_Manager::TAB_STYLE,
                'label'   => __( 'Style', 'fmwave-core' ),
				'condition' => array( 'schedule_style'    => array( 'tab','tab2','tab3' ),  ),
            ),
            array(
                'mode'     => 'group',
                'type'      => Group_Control_Typography::get_type(),
                'name'       => 'sche_title_typo',
                'label'    => __( 'Title Typo', 'fmwave-core' ),
                'selector' => '{{WRAPPER}} .schedule-tab-default .tab-content .show-box .media .media-body .item-title',
            ),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sche_day_color',
				'label'   => esc_html__( 'Day Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .schedule-tab-default .tab-content .show-box .show-time .show-day' => 'color: {{VALUE}}',
					'{{WRAPPER}} .schedule-tab-default .tab-content .show-box .show-day' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sche_time_color',
				'label'   => esc_html__( 'Time Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .schedule-tab-default .tab-content .show-box .show-time .show-hour' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sche_rj_color',
				'label'   => esc_html__( 'RJ Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .schedule-tab-default .tab-content .show-box .media .media-body .item-subtitle' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sche_box_hov_bg',
				'label'   => esc_html__( 'Hover Bg Color', 'fmwave-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .show-schedule-tab .tab-content .show-box:before' => 'background-color: {{VALUE}}',
				),
				'condition' => array( 'schedule_style'    => array( 'tab' ),  ),
			),
			
		);
		return $fields;
	}

    public function sort_by_time( $a, $b ) {
        return ( strtotime( $a['start_time'] ) <=> strtotime( $b['start_time'] ) );
    }

	protected function render() {
		$data = $this->get_settings();

		$this->rt_load_scripts();
		switch ( $data['schedule_style'] ) {
			case 'tab3':
                $template = 'schedule-tab3';
                break;
			case 'tab2':
                $template = 'schedule-tab2';
                break;
            case 'list2':
                $template = 'schedule-list-admin';
                break;
            case 'list1':
                $template = 'schedule-list';
                break;
            case 'tab':
                $template = 'schedule-tab';
                break;
            default:
                $template = 'schedule-isotope';
        }

		return $this->rt_template( $template, $data );
	}
}