<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;
class Post_Slider extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Post Slider', 'fmwave-core' );
		$this->rt_base = 'rt-post-slider';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'fmwave-core' ),
				'6'  => esc_html__( '2 Col', 'fmwave-core' ),
				'4'  => esc_html__( '3 Col', 'fmwave-core' ),
				'3'  => esc_html__( '4 Col', 'fmwave-core' ),
				'2'  => esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_style(  'owl-carousel' );
		wp_enqueue_style(  'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
	}

	private function rt_cat_dropdown() {  
		$terms = get_terms( [
			'taxonomy' => "category",
			'hide_empty' => true,
		]);

		$category_dropdown = [];
		foreach ( $terms as $category ) {
			$category_dropdown[$category->slug] = $category->name;
		}
		return $category_dropdown;
	}

	public function rt_fields(){
		$categories = get_categories();
		foreach ( $categories as $category ) {
			$category_dropdown[$category->slug] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   =>esc_html__( 'Style', 'fmwave-core' ),
				'options' => array(
					'style1' =>esc_html__( 'Style 1', 'fmwave-core' ),
					'style2' =>esc_html__( 'Style 2', 'fmwave-core' ),					
					'style3' =>esc_html__( 'Style 3', 'fmwave-core' ),					
					'style4' =>esc_html__( 'Style 4', 'fmwave-core' ),					
									
				),
				'default' => 'style1',
			),		
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'fmwave-core' ),
				'options' => $category_dropdown,
				'default' => '0',			
				'multiple' => true,
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'fmwave-core' ),
				'options' => array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'fmwave-core' ),
					'title'       => esc_html__( 'Title', 'fmwave-core' ),
					'menu_order'  => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'fmwave-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Total number of posts', 'fmwave-core' ),
				'default' => 5,
				'description' => esc_html__( 'Write -1 to show all', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'content_display',
				'label'       =>esc_html__( 'Post short Content ', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'no',
				'description' =>esc_html__( 'Show or Hide short Content. Default: On', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'word_count',
				'label'   =>esc_html__( 'Word count', 'fmwave-core' ),
				'default' => 18,
				'description' =>esc_html__( 'Maximum number of words', 'fmwave-core' ),
				'condition'   => array( 'content_display' => array( 'yes')),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_date',
				'label'       =>esc_html__( 'Post Date ', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide short Date. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_author',
				'label'       =>esc_html__( 'Post Author ', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' =>esc_html__( 'Show or Hide short Author. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_category',
				'label'       =>esc_html__( 'Post Category ', 'fmwave-core' ),
				'label_on'    =>esc_html__( 'On', 'fmwave-core' ),
				'label_off'   =>esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'no',
				'description' =>esc_html__( 'Show or Hide short Category. Default: Off', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   =>esc_html__( 'Title Word count', 'fmwave-core' ),
				'default' => 7,
				'description' =>esc_html__( 'Maximum number of words', 'fmwave-core' ),
			),	
			
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),

			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_nav',
				'label'       => esc_html__( 'Navigation Arrow', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => '',
				'description' => esc_html__( 'Enable or disable navigation arrow. Default: Off', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_dots',
				'label'       => esc_html__( 'Navigation Dots', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable navigation dots. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'fmwave-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => esc_html__( 'Stop on Hover', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Stop autoplay on mouse hover. Default: On', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'slider_interval',
				'label'   => esc_html__( 'Autoplay Interval', 'fmwave-core' ),
				'options' => array(
					'5000' => esc_html__( '5 Seconds', 'fmwave-core' ),
					'4000' => esc_html__( '4 Seconds', 'fmwave-core' ),
					'3000' => esc_html__( '3 Seconds', 'fmwave-core' ),
					'2000' => esc_html__( '2 Seconds', 'fmwave-core' ),
					'1000' => esc_html__( '1 Second',  'fmwave-core' ),
				),
				'default' => '5000',
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'fmwave-core' ),
				'default' => 200,
				'description' => esc_html__( 'Slide speed in milliseconds. Default: 200', 'fmwave-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'fmwave-core' ),
				'label_on'    => esc_html__( 'On', 'fmwave-core' ),
				'label_off'   => esc_html__( 'Off', 'fmwave-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$owl_data = array( 
			'nav'                => $data['slider_nav'] == 'yes' ? true : false,
			'dots'               => $data['slider_dots'] == 'yes' ? true : false,
			'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
			'autoplay'           => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplayTimeout'    => $data['slider_interval'],
			'autoplaySpeed'      => $data['slider_autoplay_speed'],
			'autoplayHoverPause' => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'               => $data['slider_loop'] == 'yes' ? true : false,
			'margin'             => 20,
			'responsive'         => array(
				'0'    => array( 'items' => 12 / $data['col_mobile'] ),
				'480'  => array( 'items' => 12 / $data['col_xs'] ),
				'768'  => array( 'items' => 12 / $data['col_sm'] ),
				'992'  => array( 'items' => 12 / $data['col_md'] ),
				'1200' => array( 'items' => 12 / $data['col_lg'] ),
			)
		);

		$data['owl_data'] = json_encode( $owl_data );
		$this->rt_load_scripts();

		switch ( $data['style'] ) {
			case 'style4':
			$template = 'post-slider-4';			
			break;
			case 'style3':
			$template = 'post-slider-3';			
			break;		
			case 'style2':
			$template = 'post-slider-2';			
			break;			
			default:
			$template = 'post-slider-1';
			break;
		}
		
		return $this->rt_template( $template, $data );
	}
}