<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Fmwave_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use radiustheme\Fmwave\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Event extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'Event Widget', 'fmwave-core' );
		$this->rt_base = 'rt-event';
		$this->rt_translate = array(
			'cols'  => array(
				'12' =>esc_html__( '1 Col', 'fmwave-core' ),
				'6'  =>esc_html__( '2 Col', 'fmwave-core' ),
				'4'  =>esc_html__( '3 Col', 'fmwave-core' ),
				'3'  =>esc_html__( '4 Col', 'fmwave-core' ),
				'2'  =>esc_html__( '6 Col', 'fmwave-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_script( 'wp-mediaelement' );
	}
	public function rt_fields(){

		$prefix = FMWAVE_CORE_CPT;
		$terms = get_terms( array( 'taxonomy' => "{$prefix}_event_category" ) );
		$category_dropdown = array( '0' => esc_html__( 'All Event Categories', 'fmwave-core' ) );
		foreach ( $terms as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'fmwave-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Layout 1', 'fmwave-core' ),
					'layout2' => esc_html__( 'Layout 2', 'fmwave-core' ),
				),
				'default' => 'layout1',
			),
			array(
				'type'    	=> Controls_Manager::MEDIA,
				'id'    	=> 'event_back_image',
				'default' 	=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
				'label'   => esc_html__( 'Widget Background Image', 'fmwave-core' ),
				'description' => esc_html__( 'Upload the Widget Background Image', 'fmwave-core' ),
				'condition' => array( 'layout' => array( 'layout1')),
			),
			array(
				'id'    => 'event_cat',
				'label' => esc_html__( 'Category', 'fmwave-core' ),
				'type'  =>  Controls_Manager::SELECT,
				'options'   => $category_dropdown,
				'default'   => '0',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_per_page',
				'label'   => esc_html__( 'How many events you want to show?', 'fmwave-core' ),
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'event_ids',
				'label'   => esc_html__( 'Post IDs to show post.', 'fmwave-core' ),
				'default' => '',
				'description' => esc_html__( 'Comma Separated Value, Like: 258,369,147,741,852,963', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'button_text',
				'label'   => esc_html__( 'Read More Text', 'fmwave-core' ),
				'default' => esc_html__( 'Read More', 'fmwave-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title', 'fmwave-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'fmwave-core' ),
				'default' => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .single-music .music-name .item-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_style_color',
				'label'   => esc_html__( 'Meta Color', 'fmwave-core' ),
				'default' => '#c9c9c9',
				'selectors' => array(
					'{{WRAPPER}} .single-music .music-name .item-subtitle' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'fmwave-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 1199px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '3',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Desktops: > 991px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Tablets: > 767px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => esc_html__( 'Phones: < 768px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => esc_html__( 'Small Phones: < 480px', 'fmwave-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		switch ( $data['layout'] ) {
			case 'layout2':
				$template = 'event-2';
			break;
			default:
				$template = 'event-1';
			break;
			}
		return $this->rt_template( $template, $data );
	}
}